/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Bundle;
import android.os.Handler;
import android.os.Process;
import android.support.v4.content.LocalBroadcastManager;
import android.util.SparseArray;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationActivity;
import com.microsoft.aad.adal.AuthenticationCallback;
import com.microsoft.aad.adal.AuthenticationCancelError;
import com.microsoft.aad.adal.AuthenticationDialog;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.AuthenticationRequest;
import com.microsoft.aad.adal.AuthenticationRequestState;
import com.microsoft.aad.adal.AuthenticationResult;
import com.microsoft.aad.adal.AuthenticationSettings;
import com.microsoft.aad.adal.Discovery;
import com.microsoft.aad.adal.ExceptionExtensions;
import com.microsoft.aad.adal.IConnectionService;
import com.microsoft.aad.adal.IDiscovery;
import com.microsoft.aad.adal.IJWSBuilder;
import com.microsoft.aad.adal.IWebRequestHandler;
import com.microsoft.aad.adal.IWindowComponent;
import com.microsoft.aad.adal.JWSBuilder;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.Oauth2;
import com.microsoft.aad.adal.PRNGFixes;
import com.microsoft.aad.adal.PackageHelper;
import com.microsoft.aad.adal.PromptBehavior;
import com.microsoft.aad.adal.StringExtensions;
import com.microsoft.aad.adal.TokenCache;
import com.microsoft.aad.adal.TokenCacheItem;
import com.microsoft.aad.adal.TokenCacheKey;
import com.microsoft.aad.adal.UserIdentifier;
import com.microsoft.aad.adal.UserInfo;
import com.microsoft.aad.adal.WebRequestHandler;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.crypto.NoSuchPaddingException;

public class AuthenticationContext {
    private static final int EXCLUDE_INDEX = 8;
    private static final String TAG = "AuthenticationContext";
    private Context mContext;
    private String mAuthority;
    private boolean mValidateAuthority;
    private boolean mAuthorityValidated = false;
    private TokenCache mTokenCacheStore;
    private static final ReentrantReadWriteLock RWL = new ReentrantReadWriteLock();
    private static final Lock READ_LOCK = RWL.readLock();
    private static final Lock WRITE_LOCK = RWL.writeLock();
    static SparseArray<AuthenticationRequestState> mDelegateMap = new SparseArray();
    private AuthenticationCallback<AuthenticationResult> mAuthorizationCallback;
    private IDiscovery mDiscovery = new Discovery();
    private IWebRequestHandler mWebRequest = new WebRequestHandler();
    private IJWSBuilder mJWSBuilder;
    private IConnectionService mConnectionService = null;
    private UUID mRequestCorrelationId = null;
    private static ExecutorService sThreadExecutor = Executors.newSingleThreadExecutor();
    private Handler mHandler;

    public AuthenticationContext(Context appContext, String authority, boolean validateAuthority) throws NoSuchAlgorithmException, NoSuchPaddingException {
        PRNGFixes.apply();
        TokenCache cache = new TokenCache(appContext);
        cache.initCache();
        this.initialize(appContext, authority, cache, validateAuthority, true);
    }

    public AuthenticationContext(Context appContext, String authority, boolean validateAuthority, TokenCache tokenCache) {
        this.initialize(appContext, authority, tokenCache, validateAuthority, false);
    }

    public AuthenticationContext(Context appContext, String authority, TokenCache tokenCache) {
        this.initialize(appContext, authority, tokenCache, true, false);
    }

    private void initialize(Context appContext, String authority, TokenCache tokenCacheStore, boolean validateAuthority, boolean defaultCache) {
        if (appContext == null) {
            throw new IllegalArgumentException("appContext");
        }
        if (authority == null) {
            throw new IllegalArgumentException("authority");
        }
        this.mContext = appContext;
        this.mConnectionService = new DefaultConnectionService(this.mContext);
        this.checkInternetPermission();
        this.mAuthority = AuthenticationContext.extractAuthority(authority);
        this.mValidateAuthority = validateAuthority;
        this.mTokenCacheStore = tokenCacheStore;
        this.mJWSBuilder = new JWSBuilder();
    }

    public TokenCache getCache() {
        return this.mTokenCacheStore;
    }

    public String getAuthority() {
        return this.mAuthority;
    }

    public boolean getValidateAuthority() {
        return this.mValidateAuthority;
    }

    public String getRedirectUriForBroker() {
        PackageHelper helper = new PackageHelper(this.mContext);
        String packageName = this.mContext.getPackageName();
        String signatureDigest = helper.getCurrentSignatureForPackage(packageName);
        String redirectUri = PackageHelper.getBrokerRedirectUrl(packageName, signatureDigest);
        Logger.v(TAG, "Broker redirectUri:" + redirectUri + " packagename:" + packageName + " signatureDigest:" + signatureDigest);
        return redirectUri;
    }

    public void acquireToken(Activity activity, String[] scope, String[] additionalScope, String clientId, String redirectUri, UserIdentifier user, AuthenticationCallback<AuthenticationResult> callback) {
        redirectUri = this.checkInputParameters(scope, additionalScope, clientId, redirectUri, PromptBehavior.Auto, callback);
        AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, scope, clientId, redirectUri, user, PromptBehavior.Auto, null, this.getRequestCorrelationId());
        this.acquireTokenLocal(this.wrapActivity(activity), false, request, callback);
    }

    public void acquireToken(Activity activity, String[] scope, String[] additionalScope, String clientId, String redirectUri, UserIdentifier user, String extraQueryParameters, AuthenticationCallback<AuthenticationResult> callback) {
        redirectUri = this.checkInputParameters(scope, additionalScope, clientId, redirectUri, PromptBehavior.Auto, callback);
        AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, scope, clientId, redirectUri, user, PromptBehavior.Auto, extraQueryParameters, this.getRequestCorrelationId());
        request.setAdditionalScope(additionalScope);
        this.acquireTokenLocal(this.wrapActivity(activity), false, request, callback);
    }

    public void acquireToken(Activity activity, String[] scope, String[] additionalScope, String clientId, String redirectUri, PromptBehavior prompt, AuthenticationCallback<AuthenticationResult> callback) {
        redirectUri = this.checkInputParameters(scope, additionalScope, clientId, redirectUri, prompt, callback);
        AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, scope, clientId, redirectUri, UserIdentifier.getAnyUser(), prompt, null, this.getRequestCorrelationId());
        request.setAdditionalScope(additionalScope);
        this.acquireTokenLocal(this.wrapActivity(activity), false, request, callback);
    }

    public void acquireToken(Activity activity, String[] scope, String[] additionalScope, String clientId, String redirectUri, PromptBehavior prompt, String extraQueryParameters, AuthenticationCallback<AuthenticationResult> callback) {
        redirectUri = this.checkInputParameters(scope, additionalScope, clientId, redirectUri, prompt, callback);
        AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, scope, clientId, redirectUri, UserIdentifier.getAnyUser(), prompt, extraQueryParameters, this.getRequestCorrelationId());
        request.setAdditionalScope(additionalScope);
        this.acquireTokenLocal(this.wrapActivity(activity), false, request, callback);
    }

    public void acquireToken(Activity activity, String[] scope, String[] additionalScope, String clientId, String redirectUri, UserIdentifier user, PromptBehavior prompt, String extraQueryParameters, AuthenticationCallback<AuthenticationResult> callback) {
        redirectUri = this.checkInputParameters(scope, additionalScope, clientId, redirectUri, prompt, callback);
        AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, scope, clientId, redirectUri, user, prompt, extraQueryParameters, this.getRequestCorrelationId());
        request.setAdditionalScope(additionalScope);
        this.acquireTokenLocal(this.wrapActivity(activity), false, request, callback);
    }

    public void acquireToken(Activity activity, String[] scope, String[] additionalScope, String policy, String clientId, String redirectUri, UserIdentifier user, PromptBehavior prompt, String extraQueryParameters, AuthenticationCallback<AuthenticationResult> callback) {
        redirectUri = this.checkInputParameters(scope, additionalScope, clientId, redirectUri, prompt, callback);
        AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, scope, clientId, redirectUri, user, prompt, extraQueryParameters, this.getRequestCorrelationId());
        request.setAdditionalScope(additionalScope);
        request.setPolicy(policy);
        this.acquireTokenLocal(this.wrapActivity(activity), false, request, callback);
    }

    public void acquireToken(IWindowComponent fragment, String[] scope, String[] additionalScope, String clientId, String redirectUri, UserIdentifier user, PromptBehavior prompt, String extraQueryParameters, AuthenticationCallback<AuthenticationResult> callback) {
        redirectUri = this.checkInputParameters(scope, additionalScope, clientId, redirectUri, prompt, callback);
        AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, scope, clientId, redirectUri, user, prompt, extraQueryParameters, this.getRequestCorrelationId());
        request.setAdditionalScope(additionalScope);
        this.acquireTokenLocal(fragment, false, request, callback);
    }

    public void acquireToken(String[] scope, String[] additionalScope, String clientId, String redirectUri, UserIdentifier user, PromptBehavior prompt, String extraQueryParameters, AuthenticationCallback<AuthenticationResult> callback) {
        redirectUri = this.checkInputParameters(scope, additionalScope, clientId, redirectUri, prompt, callback);
        AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, scope, clientId, redirectUri, user, prompt, extraQueryParameters, this.getRequestCorrelationId());
        request.setAdditionalScope(additionalScope);
        this.acquireTokenLocal(null, true, request, callback);
    }

    private IWindowComponent wrapActivity(final Activity activity) {
        return new IWindowComponent(){
            Activity refActivity;
            {
                this.refActivity = activity;
            }

            @Override
            public void startActivityForResult(Intent intent, int requestCode) {
                this.refActivity.startActivityForResult(intent, requestCode);
            }
        };
    }

    private String checkInputParameters(String[] scopeInput, String[] additionalScope, String clientId, String redirectUri, PromptBehavior behavior, AuthenticationCallback<AuthenticationResult> callback) {
        if (this.mContext == null) {
            throw new AuthenticationException(ADALError.DEVELOPER_CONTEXT_IS_NOT_PROVIDED);
        }
        if (scopeInput == null || scopeInput.length == 0) {
            throw new IllegalArgumentException("scope");
        }
        Set<String> set = StringExtensions.createSet(scopeInput, additionalScope);
        if (set.contains("openid")) {
            throw new IllegalArgumentException("API does not accept openid as a user-provided scope");
        }
        if (set.contains("offline_access")) {
            throw new IllegalArgumentException("API does not accept offline_access as a user-provided scope");
        }
        if (set.contains(clientId) && set.size() > 1) {
            throw new IllegalArgumentException("Client Id can only be provided as a single scope");
        }
        if (StringExtensions.IsNullOrBlank(clientId)) {
            throw new IllegalArgumentException("clientId");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback");
        }
        if (StringExtensions.IsNullOrBlank(redirectUri)) {
            redirectUri = this.getRedirectFromPackage();
        }
        return redirectUri;
    }

    public AuthenticationResult acquireTokenSilentSync(String[] scope, String clientId, UserIdentifier user) {
        Future<AuthenticationResult> futureResult = this.acquireTokenSilent(scope, clientId, user, null);
        try {
            return futureResult.get();
        }
        catch (InterruptedException e) {
            this.convertExceptionForSync(e);
        }
        catch (ExecutionException e) {
            this.convertExceptionForSync(e);
        }
        return null;
    }

    private void convertExceptionForSync(Exception e) {
        if (e.getCause() != null) {
            if (e.getCause() instanceof AuthenticationException) {
                throw (AuthenticationException)e.getCause();
            }
            if (e.getCause() instanceof IllegalArgumentException) {
                throw (IllegalArgumentException)e.getCause();
            }
            throw new AuthenticationException(ADALError.ERROR_SILENT_REQUEST, e.getCause().getMessage(), e.getCause());
        }
        throw new AuthenticationException(ADALError.ERROR_SILENT_REQUEST, e.getMessage(), e);
    }

    public Future<AuthenticationResult> acquireTokenSilent(String[] scope, String clientId, UserIdentifier user, AuthenticationCallback<AuthenticationResult> callback) {
        if (scope == null || scope.length == 0) {
            throw new IllegalArgumentException("scope");
        }
        if (StringExtensions.IsNullOrBlank(clientId)) {
            throw new IllegalArgumentException("clientId");
        }
        if (user == null) {
            throw new IllegalArgumentException("user");
        }
        AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, scope, clientId, user, this.getRequestCorrelationId());
        request.setSilent(true);
        request.setPrompt(PromptBehavior.Auto);
        return this.acquireTokenLocal(null, false, request, callback);
    }

    public Future<AuthenticationResult> acquireTokenSilent(String[] scope, String policy, String clientId, UserIdentifier user, AuthenticationCallback<AuthenticationResult> callback) {
        if (scope == null || scope.length == 0) {
            throw new IllegalArgumentException("scope");
        }
        if (StringExtensions.IsNullOrBlank(clientId)) {
            throw new IllegalArgumentException("clientId");
        }
        AuthenticationRequest request = new AuthenticationRequest(this.mAuthority, scope, clientId, user, this.getRequestCorrelationId());
        request.setSilent(true);
        request.setPrompt(PromptBehavior.Auto);
        request.setPolicy(policy);
        return this.acquireTokenLocal(null, false, request, callback);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 1001) {
            this.getHandler();
            if (data == null) {
                Logger.e(TAG, "onActivityResult BROWSER_FLOW data is null.", "", ADALError.ON_ACTIVITY_RESULT_INTENT_NULL);
            } else {
                Bundle extras = data.getExtras();
                final int requestId = extras.getInt("com.microsoft.aad.adal:RequestId");
                final AuthenticationRequestState waitingRequest = this.getWaitingRequest(requestId);
                if (waitingRequest == null) {
                    Logger.e(TAG, "onActivityResult did not find waiting request for RequestId:" + requestId, "", ADALError.ON_ACTIVITY_RESULT_INTENT_NULL);
                    return;
                }
                Logger.v(TAG, "onActivityResult RequestId:" + requestId);
                String correlationInfo = this.getCorrelationInfoFromWaitingRequest(waitingRequest);
                if (resultCode == 2004) {
                    String accessToken = data.getStringExtra("account.access.token");
                    long expireTime = data.getLongExtra("account.expiredate", 0L);
                    Date expire = new Date(expireTime);
                    String idtoken = data.getStringExtra("account.idtoken");
                    String tenantId = data.getStringExtra("account.userinfo.tenantid");
                    UserInfo userinfo = UserInfo.getUserInfoFromBrokerResult(data.getExtras());
                    AuthenticationResult brokerResult = new AuthenticationResult(accessToken, null, expire, false, userinfo, tenantId, idtoken);
                    if (brokerResult != null && brokerResult.getToken() != null) {
                        waitingRequest.mDelagete.onSuccess(brokerResult);
                        return;
                    }
                } else if (resultCode == 2001) {
                    Logger.v(TAG, "User cancelled the flow RequestId:" + requestId + correlationInfo);
                    this.waitingRequestOnError(waitingRequest, requestId, new AuthenticationCancelError("User cancelled the flow RequestId:" + requestId + correlationInfo));
                } else if (resultCode == 2005) {
                    Serializable authException = extras.getSerializable("com.microsoft.aad.adal:AuthenticationException");
                    if (authException != null && authException instanceof AuthenticationException) {
                        AuthenticationException exception = (AuthenticationException)authException;
                        Logger.w(TAG, "Webview returned exception", exception.getMessage(), ADALError.WEBVIEW_RETURNED_AUTHENTICATION_EXCEPTION);
                        this.waitingRequestOnError(waitingRequest, requestId, exception);
                    } else {
                        this.waitingRequestOnError(waitingRequest, requestId, new AuthenticationException(ADALError.WEBVIEW_RETURNED_INVALID_AUTHENTICATION_EXCEPTION));
                    }
                } else if (resultCode == 2002) {
                    String errCode = extras.getString("com.microsoft.aad.adal:BrowserErrorCode");
                    String errMessage = extras.getString("com.microsoft.aad.adal:BrowserErrorMessage");
                    Logger.v(TAG, "Error info:" + errCode + " " + errMessage + " for requestId: " + requestId + correlationInfo);
                    this.waitingRequestOnError(waitingRequest, requestId, new AuthenticationException(ADALError.SERVER_INVALID_REQUEST, errCode + " " + errMessage));
                } else if (resultCode == 2003) {
                    final AuthenticationRequest authenticationRequest = (AuthenticationRequest)extras.getSerializable("com.microsoft.aad.adal:BrowserRequestInfo");
                    final String endingUrl = extras.getString("com.microsoft.aad.adal:BrowserFinalUrl");
                    if (endingUrl.isEmpty()) {
                        AuthenticationException e = new AuthenticationException(ADALError.WEBVIEW_RETURNED_EMPTY_REDIRECT_URL, "Webview did not reach the redirectUrl. " + authenticationRequest.getLogInfo());
                        Logger.e(TAG, e.getMessage(), "", e.getCode());
                        this.waitingRequestOnError(waitingRequest, requestId, e);
                    } else {
                        final CallbackHandler callbackHandle = new CallbackHandler(this.mHandler, waitingRequest.mDelagete);
                        sThreadExecutor.submit(new Runnable(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public void run() {
                                Logger.v(AuthenticationContext.TAG, "Processing url for token. " + authenticationRequest.getLogInfo());
                                Oauth2 oauthRequest = new Oauth2(authenticationRequest, AuthenticationContext.this.mWebRequest);
                                AuthenticationResult result = null;
                                try {
                                    result = oauthRequest.getToken(endingUrl);
                                    Logger.v(AuthenticationContext.TAG, "OnActivityResult processed the result. " + authenticationRequest.getLogInfo());
                                }
                                catch (Exception exc) {
                                    String msg = "Error in processing code to get token. " + authenticationRequest.getLogInfo();
                                    Logger.e(AuthenticationContext.TAG, msg, ExceptionExtensions.getExceptionMessage(exc), ADALError.AUTHORIZATION_CODE_NOT_EXCHANGED_FOR_TOKEN, exc);
                                    AuthenticationContext.this.waitingRequestOnError(callbackHandle, waitingRequest, requestId, new AuthenticationException(ADALError.AUTHORIZATION_CODE_NOT_EXCHANGED_FOR_TOKEN, msg, exc));
                                    return;
                                }
                                try {
                                    if (result != null) {
                                        Logger.v(AuthenticationContext.TAG, "OnActivityResult is setting the token to cache. " + authenticationRequest.getLogInfo());
                                        if (!StringExtensions.IsNullOrBlank(result.getToken())) {
                                            AuthenticationContext.this.setItemToCache(authenticationRequest, result);
                                            if (waitingRequest != null && waitingRequest.mDelagete != null) {
                                                Logger.v(AuthenticationContext.TAG, "Sending result to callback. " + authenticationRequest.getLogInfo());
                                                callbackHandle.onSuccess(result);
                                            }
                                        } else {
                                            AuthenticationContext.this.waitingRequestOnError(callbackHandle, waitingRequest, requestId, new AuthenticationException(ADALError.AUTHORIZATION_CODE_NOT_EXCHANGED_FOR_TOKEN, result.getErrorDescription()));
                                        }
                                    } else {
                                        callbackHandle.onError(new AuthenticationException(ADALError.AUTHORIZATION_CODE_NOT_EXCHANGED_FOR_TOKEN));
                                    }
                                }
                                catch (Exception exc) {
                                    String msg = "Error in processing code to get token. " + authenticationRequest.getLogInfo();
                                    Logger.e(AuthenticationContext.TAG, msg, ExceptionExtensions.getExceptionMessage(exc), ADALError.DEVICE_CACHE_IS_NOT_WORKING, exc);
                                }
                                finally {
                                    AuthenticationContext.this.removeWaitingRequest(requestId);
                                }
                            }
                        });
                    }
                }
            }
        }
    }

    private static boolean isUserMisMatch(AuthenticationRequest request, AuthenticationResult result) {
        if (request.getUserIdentifier().getType().equals((Object)UserIdentifier.UserIdentifierType.OptionalDisplayableId)) {
            Logger.v(TAG, "OptionalId is specified.");
            return false;
        }
        if (result.getUserInfo() != null) {
            if (request.getUserIdentifier().getType().equals((Object)UserIdentifier.UserIdentifierType.UniqueId)) {
                String resultUniqueID = result.getUserInfo().getUniqueId();
                Logger.v(TAG, "UniqueId is specified.");
                if (resultUniqueID == null && request.getUserIdentifier().getId() == null) {
                    return false;
                }
                return resultUniqueID == null || !resultUniqueID.equalsIgnoreCase(request.getUserIdentifier().getId());
            }
            if (request.getUserIdentifier().getType().equals((Object)UserIdentifier.UserIdentifierType.RequiredDisplayableId)) {
                String resultDispID = result.getUserInfo().getDisplayableId();
                Logger.v(TAG, "RequiredDisplayableId is specified.");
                if (resultDispID == null && request.getUserIdentifier().getId() == null) {
                    return false;
                }
                return resultDispID == null || !resultDispID.equalsIgnoreCase(request.getUserIdentifier().getId());
            }
        }
        Logger.v(TAG, "result.getUserInfo() is null.");
        return false;
    }

    private String getCorrelationInfoFromWaitingRequest(AuthenticationRequestState waitingRequest) {
        UUID requestCorrelationID = this.getRequestCorrelationId();
        if (waitingRequest.mRequest != null) {
            requestCorrelationID = waitingRequest.mRequest.getCorrelationId();
        }
        String correlationInfo = String.format(" CorrelationId: %s", requestCorrelationID.toString());
        return correlationInfo;
    }

    private void waitingRequestOnError(AuthenticationRequestState waitingRequest, int requestId, AuthenticationException exc) {
        if (waitingRequest != null && waitingRequest.mDelagete != null) {
            Logger.v(TAG, "Sending error to callback" + this.getCorrelationInfoFromWaitingRequest(waitingRequest));
            waitingRequest.mDelagete.onError(exc);
        }
        if (exc != null && exc.getCode() != ADALError.AUTH_FAILED_CANCELLED) {
            this.removeWaitingRequest(requestId);
        }
    }

    private void waitingRequestOnError(CallbackHandler handler, AuthenticationRequestState waitingRequest, int requestId, AuthenticationException exc) {
        if (waitingRequest != null && waitingRequest.mDelagete != null) {
            Logger.v(TAG, "Sending error to callback" + this.getCorrelationInfoFromWaitingRequest(waitingRequest));
            handler.onError(exc);
        }
        if (exc != null && exc.getCode() != ADALError.AUTH_FAILED_CANCELLED) {
            this.removeWaitingRequest(requestId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeWaitingRequest(int requestId) {
        Logger.v(TAG, "Remove waiting request: " + requestId);
        WRITE_LOCK.lock();
        try {
            mDelegateMap.remove(requestId);
        }
        finally {
            WRITE_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthenticationRequestState getWaitingRequest(int requestId) {
        Logger.v(TAG, "Get waiting request: " + requestId);
        AuthenticationRequestState request = null;
        READ_LOCK.lock();
        try {
            request = (AuthenticationRequestState)mDelegateMap.get(requestId);
        }
        finally {
            READ_LOCK.unlock();
        }
        if (request == null && this.mAuthorizationCallback != null && requestId == this.mAuthorizationCallback.hashCode()) {
            Logger.e(TAG, "Request callback is not available for requestid:" + requestId + ". It will use last callback.", "", ADALError.CALLBACK_IS_NOT_FOUND);
            request = new AuthenticationRequestState(0, null, this.mAuthorizationCallback);
        }
        return request;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putWaitingRequest(int requestId, AuthenticationRequestState requestState) {
        Logger.v(TAG, "Put waiting request: " + requestId + this.getCorrelationInfoFromWaitingRequest(requestState));
        if (requestState != null) {
            WRITE_LOCK.lock();
            try {
                mDelegateMap.put(requestId, (Object)requestState);
            }
            finally {
                WRITE_LOCK.unlock();
            }
        }
    }

    public boolean cancelAuthenticationActivity(int requestId) {
        AuthenticationRequestState request = this.getWaitingRequest(requestId);
        if (request == null || request.mDelagete == null) {
            Logger.v(TAG, "Current callback is empty. There is not any active authentication.");
            return true;
        }
        String currentCorrelationInfo = this.getCorrelationInfoFromWaitingRequest(request);
        Logger.v(TAG, "Current callback is not empty. There is an active authentication Activity." + currentCorrelationInfo);
        Intent intent = new Intent("com.microsoft.aad.adal:BrowserCancel");
        Bundle extras = new Bundle();
        intent.putExtras(extras);
        intent.putExtra("com.microsoft.aad.adal:RequestId", requestId);
        boolean cancelResult = LocalBroadcastManager.getInstance((Context)this.mContext).sendBroadcast(intent);
        if (cancelResult) {
            Logger.v(TAG, "Cancel broadcast message was successful." + currentCorrelationInfo);
            request.mCancelled = true;
            request.mDelagete.onError(new AuthenticationCancelError("Cancel broadcast message was successful."));
        } else {
            Logger.w(TAG, "Cancel broadcast message was not successful." + currentCorrelationInfo, "", ADALError.BROADCAST_CANCEL_NOT_SUCCESSFUL);
        }
        return cancelResult;
    }

    private Future<AuthenticationResult> acquireTokenLocal(final IWindowComponent activity, final boolean useDialog, final AuthenticationRequest request, AuthenticationCallback<AuthenticationResult> externalCall) {
        this.getHandler();
        final CallbackHandler callbackHandle = new CallbackHandler(this.mHandler, externalCall);
        Logger.setCorrelationId(this.getRequestCorrelationId());
        Logger.v(TAG, "Sending async task from thread:" + Process.myTid());
        return sThreadExecutor.submit(new Callable<AuthenticationResult>(){

            @Override
            public AuthenticationResult call() {
                Logger.v(AuthenticationContext.TAG, "Running task in thread:" + Process.myTid());
                return AuthenticationContext.this.acquireTokenLocalCall(callbackHandle, activity, useDialog, request);
            }
        });
    }

    private AuthenticationResult acquireTokenLocalCall(CallbackHandler callbackHandle, IWindowComponent activity, boolean useDialog, AuthenticationRequest request) {
        URL authorityUrl = StringExtensions.getUrl(this.mAuthority);
        if (authorityUrl == null) {
            callbackHandle.onError(new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_URL));
            return null;
        }
        if (this.mValidateAuthority && !this.mAuthorityValidated) {
            try {
                URL authorityUrlInCallback = authorityUrl;
                boolean result = this.validateAuthority(authorityUrl);
                if (!result) {
                    Logger.v(TAG, "Call external callback since instance is invalid" + authorityUrlInCallback.toString());
                    callbackHandle.onError(new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_INSTANCE));
                    return null;
                }
                this.mAuthorityValidated = true;
                Logger.v(TAG, "Authority is validated: " + authorityUrlInCallback.toString());
            }
            catch (Exception exc) {
                Logger.e(TAG, "Authority validation has an error.", "", ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_INSTANCE, exc);
                callbackHandle.onError(new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_INSTANCE));
                return null;
            }
        }
        return this.acquireTokenAfterValidation(callbackHandle, activity, useDialog, request);
    }

    private boolean promptUser(PromptBehavior prompt) {
        return prompt == PromptBehavior.Always || prompt == PromptBehavior.REFRESH_SESSION;
    }

    private AuthenticationResult acquireTokenAfterValidation(CallbackHandler callbackHandle, IWindowComponent activity, boolean useDialog, AuthenticationRequest request) {
        Logger.v(TAG, "Token request started");
        try {
            return this.localFlow(callbackHandle, activity, useDialog, request);
        }
        catch (AuthenticationException e) {
            callbackHandle.onError(e);
        }
        catch (Exception e) {
            callbackHandle.onError(new AuthenticationException(ADALError.INTERNAL_ERROR, e.getMessage(), e));
        }
        return null;
    }

    private AuthenticationResult localFlow(CallbackHandler callbackHandle, IWindowComponent activity, boolean useDialog, AuthenticationRequest request) {
        AuthenticationResult cachedItem = this.getItemFromCache(request);
        if (cachedItem != null && AuthenticationContext.isUserMisMatch(request, cachedItem)) {
            if (callbackHandle.callback != null) {
                callbackHandle.onError(new AuthenticationException(ADALError.AUTH_FAILED_USER_MISMATCH));
                return null;
            }
            throw new AuthenticationException(ADALError.AUTH_FAILED_USER_MISMATCH);
        }
        if (!this.promptUser(request.getPrompt()) && this.isValidCache(cachedItem)) {
            Logger.v(TAG, "Token is returned from cache");
            if (callbackHandle.callback != null) {
                callbackHandle.onSuccess(cachedItem);
            }
            return cachedItem;
        }
        Logger.v(TAG, "Checking refresh tokens");
        RefreshItem refreshItem = this.getRefreshToken(request);
        if (!this.promptUser(request.getPrompt()) && refreshItem != null && !StringExtensions.IsNullOrBlank(refreshItem.mRefreshToken)) {
            Logger.v(TAG, "Refresh token is available and it will attempt to refresh token");
            return this.refreshToken(callbackHandle, activity, useDialog, request, refreshItem, true);
        }
        Logger.v(TAG, "Refresh token is not available");
        if (!request.isSilent() && callbackHandle.callback != null && (activity != null || useDialog)) {
            this.mAuthorizationCallback = callbackHandle.callback;
            request.setRequestId(callbackHandle.callback.hashCode());
            Logger.v(TAG, "Starting Authentication Activity with callback:" + callbackHandle.callback.hashCode());
            this.putWaitingRequest(callbackHandle.callback.hashCode(), new AuthenticationRequestState(callbackHandle.callback.hashCode(), request, callbackHandle.callback));
            if (useDialog) {
                AuthenticationDialog dialog = new AuthenticationDialog(this.mHandler, this.mContext, this, request);
                dialog.show();
            } else if (!this.startAuthenticationActivity(activity, request)) {
                callbackHandle.onError(new AuthenticationException(ADALError.DEVELOPER_ACTIVITY_IS_NOT_RESOLVED));
            }
        } else {
            Logger.e(TAG, "Prompt is not allowed and failed to get token:", "", ADALError.AUTH_REFRESH_FAILED_PROMPT_NOT_ALLOWED);
            callbackHandle.onError(new AuthenticationException(ADALError.AUTH_REFRESH_FAILED_PROMPT_NOT_ALLOWED));
        }
        return null;
    }

    protected boolean isRefreshable(AuthenticationResult cachedItem) {
        return cachedItem != null && !StringExtensions.IsNullOrBlank(cachedItem.getRefreshToken());
    }

    private boolean isValidCache(AuthenticationResult cachedItem) {
        return cachedItem != null && !StringExtensions.IsNullOrBlank(cachedItem.getToken()) && !cachedItem.isExpired();
    }

    private AuthenticationResult getItemFromCache(AuthenticationRequest request) {
        TokenCacheItem item;
        if (this.mTokenCacheStore != null && (item = this.mTokenCacheStore.getItem(TokenCacheKey.createCacheKey(request))) != null) {
            Logger.v(TAG, "getItemFromCache accessTokenId:" + this.getTokenHash(item.getAccessToken()) + " refreshTokenId:" + this.getTokenHash(item.getRefreshToken()));
            return AuthenticationResult.createResult(item);
        }
        return null;
    }

    private String getTokenHash(String token) {
        try {
            return StringExtensions.createHash(token);
        }
        catch (NoSuchAlgorithmException e) {
            Logger.e(TAG, "Digest error", "", ADALError.DEVICE_NO_SUCH_ALGORITHM, e);
        }
        catch (UnsupportedEncodingException e) {
            Logger.e(TAG, "Digest error", "", ADALError.ENCODING_IS_NOT_SUPPORTED, e);
        }
        return "";
    }

    private RefreshItem getRefreshToken(AuthenticationRequest request) {
        RefreshItem refreshItem = null;
        if (this.mTokenCacheStore != null) {
            boolean multiResource = true;
            TokenCacheKey keyUsed = TokenCacheKey.createCacheKey(request);
            Logger.v(TAG, "Looking for regular refresh token. Key:" + keyUsed.getLog());
            TokenCacheItem item = this.mTokenCacheStore.getItem(keyUsed);
            if (item == null || StringExtensions.IsNullOrBlank(item.getRefreshToken())) {
                Logger.v(TAG, "Looking for Multi Resource Refresh token");
                item = this.mTokenCacheStore.getItem(keyUsed);
                multiResource = true;
            }
            if (item != null && !StringExtensions.IsNullOrBlank(item.getRefreshToken())) {
                String refreshTokenHash = this.getTokenHash(item.getRefreshToken());
                Logger.v(TAG, "Refresh token is available and id:" + refreshTokenHash + " Key used:" + keyUsed);
                refreshItem = new RefreshItem(keyUsed, request, item, multiResource);
            }
        }
        return refreshItem;
    }

    private void setItemToCache(AuthenticationRequest request, AuthenticationResult result) throws AuthenticationException {
        if (this.mTokenCacheStore != null) {
            Logger.v(TAG, "Setting item to cache");
            this.logReturnedToken(request, result);
            TokenCacheKey key = TokenCacheKey.createCacheKey(request, result);
            Logger.v(TAG, "Clean up intersecting scopes");
            this.mTokenCacheStore.deleteIntersectingScope(key);
            TokenCacheItem cacheItem = new TokenCacheItem(request, result, result.getIsMultiResourceRefreshToken());
            String[] scopesInRequest = request.getScope();
            if (scopesInRequest != null && scopesInRequest.length == 1 && (scopesInRequest[0] == "openid" || scopesInRequest[0] == request.getClientId())) {
                String[] convertedScope = new String[]{request.getClientId()};
                key.setScope(convertedScope);
            }
            this.mTokenCacheStore.setItem(key, cacheItem);
        }
    }

    private void logReturnedToken(AuthenticationRequest request, AuthenticationResult result) {
        if (result != null && result.getToken() != null) {
            String accessTokenHash = this.getTokenHash(result.getToken());
            String refreshTokenHash = this.getTokenHash(result.getRefreshToken());
            Logger.v(TAG, String.format("Access TokenID %s and Refresh TokenID %s returned. CorrelationId: %s", accessTokenHash, refreshTokenHash, request.getCorrelationId()));
        }
    }

    private void setItemToCacheFromRefresh(RefreshItem refreshItem, AuthenticationRequest request, AuthenticationResult result) throws AuthenticationException {
        if (this.mTokenCacheStore != null) {
            Logger.v(TAG, "Setting refresh item to cache for key:" + refreshItem.mKey);
            this.logReturnedToken(request, result);
            this.mTokenCacheStore.setItem(refreshItem.mKey, new TokenCacheItem(request, result, refreshItem.mMultiResource));
        }
    }

    private void removeItemFromCache(RefreshItem refreshItem) throws AuthenticationException {
        if (this.mTokenCacheStore != null) {
            Logger.v(TAG, "Remove refresh item from cache:" + refreshItem.mKey);
            this.mTokenCacheStore.removeItem(refreshItem.mKey);
        }
    }

    private AuthenticationResult refreshToken(CallbackHandler callbackHandle, IWindowComponent activity, boolean useDialog, AuthenticationRequest request, RefreshItem refreshItem, boolean useCache) {
        Logger.v(TAG, "Process refreshToken for " + request.getLogInfo() + " refreshTokenId:" + this.getTokenHash(refreshItem.mRefreshToken));
        if (!this.mConnectionService.isConnectionAvailable()) {
            AuthenticationException exc = new AuthenticationException(ADALError.DEVICE_CONNECTION_IS_NOT_AVAILABLE, "Connection is not available to refresh token");
            Logger.w(TAG, "Connection is not available to refresh token", request.getLogInfo(), ADALError.DEVICE_CONNECTION_IS_NOT_AVAILABLE);
            callbackHandle.onError(exc);
            return null;
        }
        AuthenticationResult result = null;
        try {
            Oauth2 oauthRequest = new Oauth2(request, this.mWebRequest, this.mJWSBuilder);
            result = oauthRequest.refreshToken(refreshItem.mRefreshToken);
            if (result != null && StringExtensions.IsNullOrBlank(result.getRefreshToken())) {
                Logger.v(TAG, "Refresh token is not returned or empty");
                result.setRefreshToken(refreshItem.mRefreshToken);
            }
        }
        catch (Exception exc) {
            Logger.e(TAG, "Error in refresh token for request:" + request.getLogInfo(), ExceptionExtensions.getExceptionMessage(exc), ADALError.AUTH_FAILED_NO_TOKEN, exc);
            AuthenticationException authException = new AuthenticationException(ADALError.AUTH_FAILED_NO_TOKEN, ExceptionExtensions.getExceptionMessage(exc), exc);
            callbackHandle.onError(authException);
            return null;
        }
        if (useCache) {
            if (result == null || StringExtensions.IsNullOrBlank(result.getToken())) {
                String errLogInfo = result == null ? "" : result.getErrorLogInfo();
                Logger.w(TAG, "Refresh token did not return accesstoken.", request.getLogInfo() + errLogInfo, ADALError.AUTH_FAILED_NO_TOKEN);
                this.removeItemFromCache(refreshItem);
                return this.acquireTokenLocalCall(callbackHandle, activity, useDialog, request);
            }
            Logger.v(TAG, "It finished refresh token request:" + request.getLogInfo());
            if (result.getUserInfo() == null && refreshItem.mUserInfo != null) {
                Logger.v(TAG, "UserInfo is updated from cached result:" + request.getLogInfo());
                result.setUserInfo(refreshItem.mUserInfo);
                result.setProfileInfo(refreshItem.mRawIdToken);
                result.setTenantId(refreshItem.mTenantId);
            }
            Logger.v(TAG, "Cache is used. It will set item to cache" + request.getLogInfo());
            this.setItemToCacheFromRefresh(refreshItem, request, result);
            if (callbackHandle.callback != null) {
                callbackHandle.onSuccess(result);
            }
            return result;
        }
        Logger.v(TAG, "Cache is not used for Request:" + request.getLogInfo());
        if (callbackHandle.callback != null) {
            callbackHandle.onSuccess(result);
        }
        return result;
    }

    private boolean validateAuthority(URL authorityUrl) {
        if (this.mDiscovery != null) {
            Logger.v(TAG, "Start validating authority");
            this.mDiscovery.setCorrelationId(this.getRequestCorrelationId());
            try {
                boolean result = this.mDiscovery.isValidAuthority(authorityUrl);
                Logger.v(TAG, "Finish validating authority:" + authorityUrl + " result:" + result);
                return result;
            }
            catch (Exception exc) {
                Logger.e(TAG, "Instance validation returned error", "", ADALError.DEVELOPER_AUTHORITY_CAN_NOT_BE_VALIDED, exc);
            }
        }
        return false;
    }

    private String getRedirectFromPackage() {
        return this.mContext.getApplicationContext().getPackageName();
    }

    private boolean startAuthenticationActivity(IWindowComponent activity, AuthenticationRequest request) {
        Intent intent = this.getAuthenticationActivityIntent(activity, request);
        if (!this.resolveIntent(intent)) {
            Logger.e(TAG, "Intent is not resolved", "", ADALError.DEVELOPER_ACTIVITY_IS_NOT_RESOLVED);
            return false;
        }
        try {
            activity.startActivityForResult(intent, 1001);
        }
        catch (ActivityNotFoundException e) {
            Logger.e(TAG, "Activity login is not found after resolving intent", "", ADALError.DEVELOPER_ACTIVITY_IS_NOT_RESOLVED, e);
            return false;
        }
        return true;
    }

    private final boolean resolveIntent(Intent intent) {
        ResolveInfo resolveInfo = this.mContext.getPackageManager().resolveActivity(intent, 0);
        return resolveInfo != null;
    }

    private final Intent getAuthenticationActivityIntent(IWindowComponent activity, AuthenticationRequest request) {
        Intent intent = new Intent();
        if (AuthenticationSettings.INSTANCE.getActivityPackageName() != null) {
            intent.setClassName(AuthenticationSettings.INSTANCE.getActivityPackageName(), AuthenticationActivity.class.getName());
        } else {
            intent.setClass(this.mContext, AuthenticationActivity.class);
        }
        intent.putExtra("com.microsoft.aad.adal:BrowserRequestMessage", (Serializable)request);
        return intent;
    }

    public UUID getRequestCorrelationId() {
        if (this.mRequestCorrelationId == null) {
            return UUID.randomUUID();
        }
        return this.mRequestCorrelationId;
    }

    public void setRequestCorrelationId(UUID requestCorrelationId) {
        this.mRequestCorrelationId = requestCorrelationId;
        Logger.setCorrelationId(requestCorrelationId);
    }

    private synchronized Handler getHandler() {
        if (this.mHandler == null) {
            this.mHandler = new Handler(this.mContext.getMainLooper());
        }
        return this.mHandler;
    }

    private static String extractAuthority(String authority) {
        int fourthSlash;
        int thirdSlash;
        if (!(StringExtensions.IsNullOrBlank(authority) || (thirdSlash = authority.indexOf("/", 8)) < 0 || thirdSlash == authority.length() - 1 || (fourthSlash = authority.indexOf("/", thirdSlash + 1)) >= 0 && fourthSlash <= thirdSlash + 1)) {
            if (fourthSlash >= 0) {
                return authority.substring(0, fourthSlash);
            }
            return authority;
        }
        throw new IllegalArgumentException("authority");
    }

    private void checkInternetPermission() {
        PackageManager pm = this.mContext.getPackageManager();
        if (0 != pm.checkPermission("android.permission.INTERNET", this.mContext.getPackageName())) {
            throw new AuthenticationException(ADALError.DEVELOPER_INTERNET_PERMISSION_MISSING);
        }
    }

    public static String getVersionName() {
        return "2.0.3-alpha";
    }

    class DefaultConnectionService
    implements IConnectionService {
        private Context mConnectionContext;

        DefaultConnectionService(Context ctx) {
            this.mConnectionContext = ctx;
        }

        @Override
        public boolean isConnectionAvailable() {
            ConnectivityManager connectivityManager = (ConnectivityManager)this.mConnectionContext.getSystemService("connectivity");
            NetworkInfo activeNetwork = connectivityManager.getActiveNetworkInfo();
            boolean isConnected = activeNetwork != null && activeNetwork.isConnectedOrConnecting();
            return isConnected;
        }
    }

    private class RefreshItem {
        String mRefreshToken;
        TokenCacheKey mKey;
        boolean mMultiResource;
        UserInfo mUserInfo;
        String mRawIdToken;
        String mTenantId;

        public RefreshItem(TokenCacheKey keyInCache, AuthenticationRequest request, TokenCacheItem item, boolean multiResource) {
            this.mKey = keyInCache;
            this.mMultiResource = multiResource;
            if (item != null) {
                this.mRefreshToken = item.getRefreshToken();
                this.mUserInfo = item.getUserInfo();
                this.mRawIdToken = item.getRawIdToken();
                this.mTenantId = item.getTenantId();
                if (this.mUserInfo != null) {
                    if (StringExtensions.IsNullOrBlank(this.mKey.getDisplayableId()) && !StringExtensions.IsNullOrBlank(this.mUserInfo.getDisplayableId())) {
                        this.mKey.setDisplayableId(this.mUserInfo.getDisplayableId().toLowerCase(Locale.US));
                    }
                    if (StringExtensions.IsNullOrBlank(this.mKey.getUniqueId()) && !StringExtensions.IsNullOrBlank(this.mUserInfo.getUniqueId())) {
                        this.mKey.setUniqueId(this.mUserInfo.getUniqueId().toLowerCase(Locale.US));
                    }
                }
            }
        }
    }

    class CallbackHandler {
        private Handler mRefHandler;
        private AuthenticationCallback<AuthenticationResult> callback;

        public CallbackHandler(Handler ref, AuthenticationCallback<AuthenticationResult> callbackExt) {
            this.mRefHandler = ref;
            this.callback = callbackExt;
        }

        public void onError(final AuthenticationException e) {
            if (this.mRefHandler == null || this.callback == null) {
                throw e;
            }
            this.mRefHandler.post(new Runnable(){

                @Override
                public void run() {
                    CallbackHandler.this.callback.onError(e);
                }
            });
        }

        public void onSuccess(final AuthenticationResult result) {
            if (this.mRefHandler != null && this.callback != null) {
                this.mRefHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        CallbackHandler.this.callback.onSuccess(result);
                    }
                });
            }
        }
    }
}

