/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.content.Context;
import android.os.Build;
import android.os.Debug;
import android.os.Process;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.AuthenticationSettings;
import com.microsoft.aad.adal.DefaultConnectionService;
import com.microsoft.aad.adal.HttpUrlConnectionFactory;
import com.microsoft.aad.adal.HttpWebResponse;
import com.microsoft.aad.adal.Logger;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

class HttpWebRequest {
    static final String REQUEST_METHOD_POST = "POST";
    static final String REQUEST_METHOD_GET = "GET";
    private static final String UNAUTHORIZED_ERROR_MESSAGE_PRE18 = "Received authentication challenge is null";
    private static final String TAG = "HttpWebRequest";
    private static final int CONNECT_TIME_OUT = AuthenticationSettings.INSTANCE.getConnectTimeOut();
    private static final int READ_TIME_OUT = AuthenticationSettings.INSTANCE.getReadTimeOut();
    private static int sDebugSimulateDelay = 0;
    private boolean mUseCaches = false;
    private boolean mInstanceRedirectsFollow = true;
    private final String mRequestMethod;
    private final URL mUrl;
    private final byte[] mRequestContent;
    private final String mRequestContentType;
    private final Map<String, String> mRequestHeaders;

    public HttpWebRequest(URL requestURL, String requestMethod, Map<String, String> headers) {
        this(requestURL, requestMethod, headers, null, null);
    }

    public HttpWebRequest(URL requestURL, String requestMethod, Map<String, String> headers, byte[] requestContent, String requestContentType) {
        this.mUrl = requestURL;
        this.mRequestMethod = requestMethod;
        this.mRequestHeaders = new HashMap<String, String>();
        if (this.mUrl != null) {
            this.mRequestHeaders.put("Host", HttpWebRequest.getURLAuthority(this.mUrl));
        }
        this.mRequestHeaders.putAll(headers);
        this.mRequestContent = requestContent;
        this.mRequestContentType = requestContentType;
    }

    private HttpURLConnection setupConnection() throws IOException {
        Logger.v(TAG, "HttpWebRequest setupConnection thread:" + Process.myTid());
        if (this.mUrl == null) {
            throw new IllegalArgumentException("requestURL");
        }
        if (!this.mUrl.getProtocol().equalsIgnoreCase("http") && !this.mUrl.getProtocol().equalsIgnoreCase("https")) {
            throw new IllegalArgumentException("requestURL");
        }
        HttpURLConnection.setFollowRedirects(true);
        HttpURLConnection connection = HttpUrlConnectionFactory.createHttpUrlConnection(this.mUrl);
        connection.setConnectTimeout(CONNECT_TIME_OUT);
        if (Build.VERSION.SDK_INT > 13) {
            connection.setRequestProperty("Connection", "close");
        }
        for (String header : this.mRequestHeaders.keySet()) {
            Logger.v(TAG, "Setting header: " + header);
            connection.setRequestProperty(header, this.mRequestHeaders.get(header));
        }
        connection.setReadTimeout(READ_TIME_OUT);
        connection.setInstanceFollowRedirects(this.mInstanceRedirectsFollow);
        connection.setUseCaches(this.mUseCaches);
        connection.setRequestMethod(this.mRequestMethod);
        connection.setDoInput(true);
        HttpWebRequest.setRequestBody(connection, this.mRequestContent, this.mRequestContentType);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpWebResponse send() throws IOException {
        HttpWebResponse response;
        Logger.v(TAG, "HttpWebRequest send thread:" + Process.myTid());
        HttpURLConnection connection = this.setupConnection();
        InputStream responseStream = null;
        try {
            block8: {
                try {
                    responseStream = connection.getInputStream();
                }
                catch (IOException ex) {
                    Logger.e(TAG, "IOException:" + ex.getMessage(), "", ADALError.SERVER_ERROR);
                    responseStream = connection.getErrorStream();
                    if (responseStream != null) break block8;
                    throw ex;
                }
            }
            int statusCode = connection.getResponseCode();
            String responseBody = HttpWebRequest.convertStreamToString(responseStream);
            if (Debug.isDebuggerConnected() && sDebugSimulateDelay > 0) {
                Logger.v(TAG, "Sleeping to simulate slow network response");
                try {
                    Thread.sleep(sDebugSimulateDelay);
                }
                catch (InterruptedException e) {
                    Logger.v(TAG, "Thread.sleep got interrupted exception " + e);
                }
            }
            Logger.v(TAG, "Response is received");
            response = new HttpWebResponse(statusCode, responseBody, connection.getHeaderFields());
        }
        finally {
            HttpWebRequest.safeCloseStream(responseStream);
        }
        return response;
    }

    static void throwIfNetworkNotAvaliable(Context context) throws AuthenticationException {
        DefaultConnectionService connectionService = new DefaultConnectionService(context);
        if (!connectionService.isConnectionAvailable()) {
            AuthenticationException authenticationException = new AuthenticationException(ADALError.DEVICE_CONNECTION_IS_NOT_AVAILABLE, "Connection is not available to refresh token");
            Logger.w(TAG, "Connection is not available to refresh token", "", ADALError.DEVICE_CONNECTION_IS_NOT_AVAILABLE);
            throw authenticationException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertStreamToString(InputStream is) throws IOException {
        try (BufferedReader reader = null;){
            String line;
            reader = new BufferedReader(new InputStreamReader(is));
            StringBuilder sb = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (sb.length() > 0) {
                    sb.append("\n");
                }
                sb.append(line);
            }
            String string2 = sb.toString();
            return string2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setRequestBody(HttpURLConnection connection, byte[] contentRequest, String requestContentType) throws IOException {
        if (null != contentRequest) {
            connection.setDoOutput(true);
            if (null != requestContentType && !requestContentType.isEmpty()) {
                connection.setRequestProperty("Content-Type", requestContentType);
            }
            connection.setRequestProperty("Content-Length", Integer.toString(contentRequest.length));
            connection.setFixedLengthStreamingMode(contentRequest.length);
            OutputStream out = null;
            try {
                out = connection.getOutputStream();
                out.write(contentRequest);
            }
            finally {
                HttpWebRequest.safeCloseStream(out);
            }
        }
    }

    private static void safeCloseStream(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                Logger.e(TAG, "Failed to close the stream: ", "", ADALError.IO_EXCEPTION, e);
            }
        }
    }

    private static String getURLAuthority(URL requestURL) {
        String authority = requestURL.getAuthority();
        if (requestURL.getPort() == -1) {
            if (requestURL.getProtocol().equalsIgnoreCase("http")) {
                authority = authority + ":80";
            } else if (requestURL.getProtocol().equalsIgnoreCase("https")) {
                authority = authority + ":443";
            }
        }
        return authority;
    }
}

