/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import java.util.Map;

public class ClientAnalytics {
    private IEventListener mEventListener;

    private ClientAnalytics() {
    }

    public static ClientAnalytics getInstance() {
        return InstanceHolder.sInstance;
    }

    static void logEvent(Event event) {
        ClientAnalytics.logEvent(event.mName, event.mProperties);
    }

    static void logEvent(String eventName, Map<String, String> properties) {
        InstanceHolder.sInstance.log(eventName, properties);
    }

    public void setEventListener(IEventListener eventListener) {
        this.mEventListener = eventListener;
    }

    private void log(String eventName, Map<String, String> properties) {
        if (this.mEventListener != null) {
            this.mEventListener.logEvent(eventName, properties);
        }
    }

    private static final class InstanceHolder {
        private static ClientAnalytics sInstance = new ClientAnalytics();

        private InstanceHolder() {
        }
    }

    public static interface IEventListener {
        public void logEvent(String var1, Map<String, String> var2);
    }

    static class Event {
        private final String mName;
        private final Map<String, String> mProperties;

        public Event(String name, Map<String, String> properties) {
            this.mName = name;
            this.mProperties = properties;
        }
    }
}

