/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.text.TextUtils;
import android.util.Log;
import com.microsoft.aad.adal.HttpWebResponse;
import com.microsoft.aad.adal.StringExtensions;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.json.JSONException;
import org.json.JSONObject;

final class HashMapExtensions {
    private static final String TAG = "HashMapExtensions";

    HashMapExtensions() {
    }

    static final HashMap<String, String> URLFormDecode(String query) {
        HashMap<String, String> result = HashMapExtensions.URLFormDecodeData(query, "&");
        return result;
    }

    static final HashMap<String, String> URLFormDecodeData(String parameters, String delimiter) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (!StringExtensions.IsNullOrBlank(parameters)) {
            StringTokenizer parameterTokenizer = new StringTokenizer(parameters, delimiter);
            while (parameterTokenizer.hasMoreTokens()) {
                String pair = parameterTokenizer.nextToken();
                String[] elements = pair.split("=");
                if (elements == null || elements.length != 2) continue;
                String key = null;
                String value = null;
                try {
                    key = StringExtensions.URLFormDecode(elements[0].trim());
                    value = StringExtensions.URLFormDecode(elements[1].trim());
                }
                catch (UnsupportedEncodingException e) {
                    Log.d((String)TAG, (String)e.getMessage());
                }
                if (StringExtensions.IsNullOrBlank(key) || StringExtensions.IsNullOrBlank(value)) continue;
                result.put(key, value);
            }
        }
        return result;
    }

    static final Map<String, String> getJsonResponse(HttpWebResponse webResponse) throws JSONException {
        HashMap<String, String> response = new HashMap<String, String>();
        if (webResponse != null && !TextUtils.isEmpty((CharSequence)webResponse.getBody())) {
            JSONObject jsonObject = new JSONObject(webResponse.getBody());
            Iterator i = jsonObject.keys();
            while (i.hasNext()) {
                String key = (String)i.next();
                response.put(key, jsonObject.getString(key));
            }
        }
        return response;
    }
}

