/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.accounts.AccountManager;
import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Bundle;
import android.util.Base64;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.Logger;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class PackageHelper {
    private static final String TAG = "CallerInfo";
    private Context mContext;
    private final AccountManager mAcctManager;

    public PackageHelper(Context ctx) {
        this.mContext = ctx;
        this.mAcctManager = AccountManager.get((Context)this.mContext);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressLint(value={"WrongConstant"})
    Object getValueFromMetaData(String packageName, ComponentName component, String metaDataName) {
        try {
            Logger.i(TAG, "", "Calling package:" + packageName);
            if (component != null) {
                Logger.v(TAG, "component:" + component.flattenToString());
                ActivityInfo ai = this.mContext.getPackageManager().getActivityInfo(component, 129);
                if (ai == null) return null;
                Bundle metaData = ai.metaData;
                if (metaData != null) return metaData.get(metaDataName);
                Logger.v(TAG, "metaData is null. Unable to get meta data for " + metaDataName);
                return null;
            } else {
                Logger.v(TAG, "calling component is null.");
            }
            return null;
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.e(TAG, "ActivityInfo is not found", "", ADALError.BROKER_ACTIVITY_INFO_NOT_FOUND, e);
        }
        return null;
    }

    @SuppressLint(value={"PackageManagerGetSignatures"})
    public String getCurrentSignatureForPackage(String packagename) {
        try {
            PackageInfo info = this.mContext.getPackageManager().getPackageInfo(packagename, 64);
            if (info != null && info.signatures != null && info.signatures.length > 0) {
                Signature signature = info.signatures[0];
                MessageDigest md = MessageDigest.getInstance("SHA");
                md.update(signature.toByteArray());
                return Base64.encodeToString((byte[])md.digest(), (int)2);
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.e(TAG, "Calling App's package does not exist in PackageManager. ", "", ADALError.APP_PACKAGE_NAME_NOT_FOUND);
        }
        catch (NoSuchAlgorithmException e) {
            Logger.e(TAG, "Digest SHA algorithm does not exists. ", "", ADALError.DEVICE_NO_SUCH_ALGORITHM);
        }
        return null;
    }

    public int getUIDForPackage(String packageName) {
        int callingUID = 0;
        try {
            ApplicationInfo info = this.mContext.getPackageManager().getApplicationInfo(packageName, 0);
            if (info != null) {
                callingUID = info.uid;
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.e(TAG, "Package is not found. ", "Package name: " + packageName, ADALError.PACKAGE_NAME_NOT_FOUND, e);
        }
        return callingUID;
    }

    public static String getBrokerRedirectUrl(String packageName, String signatureDigest) {
        if (!StringExtensions.isNullOrBlank((String)packageName) && !StringExtensions.isNullOrBlank((String)signatureDigest)) {
            if (packageName.equals("com.azure.authenticator") && signatureDigest.equals("ho040S3ffZkmxqtQrSwpTVOn9r0=")) {
                return "urn:ietf:wg:oauth:2.0:oob";
            }
            try {
                return String.format("%s://%s/%s", "msauth", URLEncoder.encode(packageName, "UTF_8"), URLEncoder.encode(signatureDigest, "UTF_8"));
            }
            catch (UnsupportedEncodingException e) {
                Logger.e(TAG, ADALError.ENCODING_IS_NOT_SUPPORTED.getDescription(), "", ADALError.ENCODING_IS_NOT_SUPPORTED, e);
            }
        }
        return "";
    }
}

