/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationContext;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.internal.logging.DiagnosticContext;
import com.microsoft.identity.common.internal.logging.ILoggerCallback;
import com.microsoft.identity.common.internal.logging.IRequestContext;
import com.microsoft.identity.common.internal.logging.Logger;
import com.microsoft.identity.common.internal.logging.RequestContext;
import java.util.UUID;

public class Logger {
    private static Logger sINSTANCE = new Logger();
    private ILogger mExternalLogger = null;
    private String mCorrelationId = null;

    public static Logger getInstance() {
        return sINSTANCE;
    }

    public void setLogLevel(LogLevel logLevel) {
        switch (logLevel) {
            case Error: {
                com.microsoft.identity.common.internal.logging.Logger.getInstance().setLogLevel(Logger.LogLevel.ERROR);
                break;
            }
            case Warn: {
                com.microsoft.identity.common.internal.logging.Logger.getInstance().setLogLevel(Logger.LogLevel.WARN);
                break;
            }
            case Info: {
                com.microsoft.identity.common.internal.logging.Logger.getInstance().setLogLevel(Logger.LogLevel.INFO);
                break;
            }
            case Verbose: {
                com.microsoft.identity.common.internal.logging.Logger.getInstance().setLogLevel(Logger.LogLevel.VERBOSE);
                break;
            }
            case Debug: {
                com.microsoft.identity.common.internal.logging.Logger.getInstance().setLogLevel(Logger.LogLevel.INFO);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown logLevel");
            }
        }
    }

    public synchronized void setExternalLogger(ILogger externalLogger) {
        com.microsoft.identity.common.internal.logging.Logger.getInstance().setExternalLogger(new ILoggerCallback(){

            public void log(String tag, Logger.LogLevel logLevel, String message, boolean containsPII) {
                if (Logger.this.mExternalLogger != null) {
                    if (!com.microsoft.identity.common.internal.logging.Logger.getAllowPii() && containsPII) {
                        return;
                    }
                    ADALError adalError = this.mapMessageToAdalError(message);
                    switch (logLevel) {
                        case ERROR: {
                            Logger.this.mExternalLogger.Log(tag, message, null, LogLevel.Error, adalError);
                            break;
                        }
                        case WARN: {
                            Logger.this.mExternalLogger.Log(tag, message, null, LogLevel.Warn, adalError);
                            break;
                        }
                        case VERBOSE: {
                            Logger.this.mExternalLogger.Log(tag, message, null, LogLevel.Verbose, adalError);
                            break;
                        }
                        case INFO: {
                            Logger.this.mExternalLogger.Log(tag, message, null, LogLevel.Info, adalError);
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unknown logLevel");
                        }
                    }
                }
            }

            private ADALError mapMessageToAdalError(String message) {
                ADALError mappedError = null;
                for (ADALError adalError : ADALError.values()) {
                    if (null == message || !message.contains(adalError.name() + ":")) continue;
                    mappedError = adalError;
                    break;
                }
                return mappedError;
            }
        });
        this.mExternalLogger = externalLogger;
    }

    public void setAndroidLogEnabled(boolean androidLogEnabled) {
        com.microsoft.identity.common.internal.logging.Logger.setAllowLogcat((boolean)androidLogEnabled);
    }

    public void setEnablePII(boolean enablePII) {
        com.microsoft.identity.common.internal.logging.Logger.setAllowPii((boolean)enablePII);
    }

    private void commonCoreWrapper(String tag, String message, String additionalMessage, LogLevel logLevel, ADALError errorCode, Throwable throwable) {
        switch (logLevel) {
            case Error: {
                if (!StringExtensions.isNullOrBlank((String)message)) {
                    com.microsoft.identity.common.internal.logging.Logger.error((String)tag, (String)Logger.getInstance().getCorrelationId(), (String)((errorCode == null ? "" : errorCode.name() + ":") + this.formatMessage(message)), null);
                }
                if (StringExtensions.isNullOrBlank((String)additionalMessage)) break;
                com.microsoft.identity.common.internal.logging.Logger.errorPII((String)tag, (String)Logger.getInstance().getCorrelationId(), (String)((errorCode == null ? "" : errorCode.name() + ":") + this.formatMessage(additionalMessage)), (Throwable)throwable);
                break;
            }
            case Warn: {
                if (!StringExtensions.isNullOrBlank((String)message)) {
                    com.microsoft.identity.common.internal.logging.Logger.warn((String)tag, (String)Logger.getInstance().getCorrelationId(), (String)((errorCode == null ? "" : errorCode.name() + ":") + this.formatMessage(message)));
                }
                if (StringExtensions.isNullOrBlank((String)additionalMessage)) break;
                com.microsoft.identity.common.internal.logging.Logger.warnPII((String)tag, (String)Logger.getInstance().getCorrelationId(), (String)((errorCode == null ? "" : errorCode.name() + ":") + this.formatMessage(additionalMessage)));
                break;
            }
            case Info: {
                if (!StringExtensions.isNullOrBlank((String)message)) {
                    com.microsoft.identity.common.internal.logging.Logger.info((String)tag, (String)Logger.getInstance().getCorrelationId(), (String)((errorCode == null ? "" : errorCode.name() + ":") + this.formatMessage(message)));
                }
                if (StringExtensions.isNullOrBlank((String)additionalMessage)) break;
                com.microsoft.identity.common.internal.logging.Logger.infoPII((String)tag, (String)Logger.getInstance().getCorrelationId(), (String)((errorCode == null ? "" : errorCode.name() + ":") + this.formatMessage(additionalMessage)));
                break;
            }
            case Verbose: {
                if (!StringExtensions.isNullOrBlank((String)message)) {
                    com.microsoft.identity.common.internal.logging.Logger.verbose((String)tag, (String)Logger.getInstance().getCorrelationId(), (String)((errorCode == null ? "" : errorCode.name() + ":") + this.formatMessage(message)));
                }
                if (StringExtensions.isNullOrBlank((String)additionalMessage)) break;
                com.microsoft.identity.common.internal.logging.Logger.verbosePII((String)tag, (String)Logger.getInstance().getCorrelationId(), (String)((errorCode == null ? "" : errorCode.name() + ":") + this.formatMessage(additionalMessage)));
                break;
            }
            case Debug: {
                com.microsoft.identity.common.internal.logging.Logger.info((String)tag, (String)Logger.getInstance().mCorrelationId, (String)this.formatMessage(message));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown loglevel");
            }
        }
    }

    @Deprecated
    public static void d(String tag, String message) {
        if (StringExtensions.isNullOrBlank((String)message)) {
            return;
        }
        Logger.getInstance().commonCoreWrapper(tag, message, null, LogLevel.Debug, null, null);
    }

    @Deprecated
    public static void i(String tag, String message, String additionalMessage) {
        Logger.getInstance().commonCoreWrapper(tag, message, additionalMessage, LogLevel.Info, null, null);
    }

    @Deprecated
    public static void i(String tag, String message, String additionalMessage, ADALError errorCode) {
        Logger.getInstance().commonCoreWrapper(tag, message, additionalMessage, LogLevel.Info, errorCode, null);
    }

    @Deprecated
    public static void v(String tag, String message) {
        Logger.getInstance().commonCoreWrapper(tag, message, null, LogLevel.Verbose, null, null);
    }

    @Deprecated
    public static void v(String tag, String message, String additionalMessage, ADALError errorCode) {
        Logger.getInstance().commonCoreWrapper(tag, message, additionalMessage, LogLevel.Verbose, errorCode, null);
    }

    @Deprecated
    public static void w(String tag, String message, String additionalMessage, ADALError errorCode) {
        Logger.getInstance().commonCoreWrapper(tag, message, additionalMessage, LogLevel.Warn, errorCode, null);
    }

    @Deprecated
    public static void w(String tag, String message) {
        Logger.getInstance().commonCoreWrapper(tag, message, null, LogLevel.Warn, null, null);
    }

    @Deprecated
    public static void e(String tag, String message, String additionalMessage, ADALError errorCode) {
        Logger.getInstance().commonCoreWrapper(tag, message, additionalMessage, LogLevel.Error, errorCode, null);
    }

    @Deprecated
    public static void e(String tag, String message, String additionalMessage, ADALError errorCode, Throwable throwable) {
        Logger.getInstance().commonCoreWrapper(tag, message, additionalMessage, LogLevel.Error, errorCode, throwable);
    }

    @Deprecated
    public static void e(String tag, String message, Throwable throwable) {
        Logger.getInstance().commonCoreWrapper(tag, message, null, LogLevel.Error, null, throwable);
    }

    public static void e(String tag, String message) {
        Logger.getInstance().commonCoreWrapper(tag, message, null, LogLevel.Error, null, null);
    }

    public static void setCorrelationId(UUID correlation) {
        Logger.getInstance().mCorrelationId = "";
        if (correlation != null) {
            String correlationId;
            Logger.getInstance().mCorrelationId = correlationId = correlation.toString();
            RequestContext requestContext = new RequestContext();
            requestContext.put((Object)"correlation_id", (Object)correlationId);
            DiagnosticContext.setRequestContext((IRequestContext)requestContext);
        }
    }

    public String getCorrelationId() {
        return this.mCorrelationId;
    }

    private String formatMessage(String message) {
        return message + " ver:" + AuthenticationContext.getVersionName();
    }

    public static interface ILogger {
        public void Log(String var1, String var2, String var3, LogLevel var4, ADALError var5);
    }

    public static enum LogLevel {
        Error(0),
        Warn(1),
        Info(2),
        Verbose(3),
        Debug(4);

        private int mValue;

        private LogLevel(int val) {
            this.mValue = val;
        }
    }
}

