/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.AuthenticationResult;
import com.microsoft.aad.adal.InstanceDiscoveryMetadata;
import com.microsoft.aad.adal.UserInfo;
import com.microsoft.identity.common.exception.BaseException;
import com.microsoft.identity.common.exception.ServiceException;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryAccount;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryCloud;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectoryTokenResponse;

final class CoreAdapter {
    private CoreAdapter() {
    }

    public static AzureActiveDirectoryAccount asAadAccount(UserInfo userInfo) {
        AzureActiveDirectoryAccount account = new AzureActiveDirectoryAccount();
        account.setDisplayableId(userInfo.getDisplayableId());
        account.setName(userInfo.getGivenName());
        account.setIdentityProvider(account.getIdentityProvider());
        account.setUid(userInfo.getUserId());
        return account;
    }

    public static UserInfo asUserInfo(AzureActiveDirectoryAccount account) {
        return new UserInfo(account.getUserId(), account.getName(), account.getFamilyName(), account.getIdentityProvider(), account.getDisplayableId());
    }

    public static AzureActiveDirectoryTokenResponse asAadTokenResponse(AuthenticationResult result) {
        AzureActiveDirectoryTokenResponse adTokenResponse = new AzureActiveDirectoryTokenResponse();
        adTokenResponse.setAccessToken(result.getAccessToken());
        adTokenResponse.setTokenType(result.getAccessTokenType());
        adTokenResponse.setRefreshToken(result.getRefreshToken());
        adTokenResponse.setExpiresOn(result.getExpiresOn());
        adTokenResponse.setExtExpiresOn(result.getExtendedExpiresOn());
        adTokenResponse.setIdToken(result.getIdToken());
        adTokenResponse.setExpiresIn(result.getExpiresIn());
        adTokenResponse.setResponseReceivedTime(result.getResponseReceived());
        adTokenResponse.setFamilyId(result.getFamilyClientId());
        adTokenResponse.setClientId(result.getClientId());
        adTokenResponse.setResource(result.getResource());
        adTokenResponse.setScope(result.getResource());
        if (null != result.getClientInfo()) {
            adTokenResponse.setClientInfo(result.getClientInfo().getRawClientInfo());
        }
        return adTokenResponse;
    }

    public static AuthenticationException asAuthenticationException(BaseException ex) {
        AuthenticationException newException = ADALError.fromCommon(ex);
        if (ex instanceof ServiceException) {
            ServiceException serviceException = (ServiceException)ex;
            newException.setHttpResponseBody(serviceException.getHttpResponseBody());
            newException.setHttpResponseHeaders(serviceException.getHttpResponseHeaders());
            newException.setServiceStatusCode(serviceException.getHttpStatusCode());
        }
        return newException;
    }

    public static AzureActiveDirectoryCloud asAadCloud(InstanceDiscoveryMetadata cloud) {
        AzureActiveDirectoryCloud adCloud = new AzureActiveDirectoryCloud(cloud.getPreferredNetwork(), cloud.getPreferredCache(), cloud.getAliases());
        return adCloud;
    }
}

