/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import com.microsoft.aad.adal.DefaultDispatcher;
import com.microsoft.aad.adal.IDispatcher;
import com.microsoft.aad.adal.IEvents;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

final class AggregatedDispatcher
extends DefaultDispatcher {
    AggregatedDispatcher(IDispatcher dispatcher) {
        super(dispatcher);
    }

    @Override
    synchronized void flush(String requestId) {
        HashMap<String, String> dispatchMap = new HashMap<String, String>();
        if (this.getDispatcher() == null) {
            return;
        }
        List<IEvents> events = this.getObjectsToBeDispatched().remove(requestId);
        if (events == null || events.isEmpty()) {
            return;
        }
        for (int i = 0; i < events.size(); ++i) {
            IEvents event = events.get(i);
            event.processEvent(dispatchMap);
        }
        this.getDispatcher().dispatchEvent(dispatchMap);
    }

    @Override
    void receive(String requestId, IEvents events) {
        List<IEvents> eventsList = this.getObjectsToBeDispatched().get(requestId);
        if (eventsList == null) {
            eventsList = new ArrayList<IEvents>();
        }
        eventsList.add(events);
        this.getObjectsToBeDispatched().put(requestId, eventsList);
    }
}

