/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.content.Context;
import android.net.Uri;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.ADFSWebFingerValidator;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.AuthorityValidationMetadataCache;
import com.microsoft.aad.adal.ClientMetrics;
import com.microsoft.aad.adal.DRSMetadata;
import com.microsoft.aad.adal.DRSMetadataRequestor;
import com.microsoft.aad.adal.HttpWebRequest;
import com.microsoft.aad.adal.InstanceDiscoveryMetadata;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.WebFingerMetadata;
import com.microsoft.aad.adal.WebFingerMetadataRequestParameters;
import com.microsoft.aad.adal.WebFingerMetadataRequestor;
import com.microsoft.identity.common.adal.internal.net.HttpWebResponse;
import com.microsoft.identity.common.adal.internal.net.IWebRequestHandler;
import com.microsoft.identity.common.adal.internal.net.WebRequestHandler;
import com.microsoft.identity.common.adal.internal.util.HashMapExtensions;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import com.microsoft.identity.common.internal.providers.microsoft.azureactivedirectory.AzureActiveDirectory;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import org.json.JSONException;

class Discovery {
    private static final String TAG = "Discovery";
    private static final String API_VERSION_KEY = "api-version";
    private static final String API_VERSION_VALUE = "1.1";
    private static final String AUTHORIZATION_ENDPOINT_KEY = "authorization_endpoint";
    private static final String INSTANCE_DISCOVERY_SUFFIX = "common/discovery/instance";
    private static final String AUTHORIZATION_COMMON_ENDPOINT = "/common/oauth2/authorize";
    private static volatile ReentrantLock sInstanceDiscoveryNetworkRequestLock;
    private static final Set<String> AAD_WHITELISTED_HOSTS;
    private static final Map<String, Set<URI>> ADFS_VALIDATED_AUTHORITIES;
    private static final String TRUSTED_QUERY_INSTANCE = "login.microsoftonline.com";
    private UUID mCorrelationId;
    private Context mContext;
    private final IWebRequestHandler mWebrequestHandler;

    public Discovery(Context context) {
        this.initValidList();
        this.mContext = context;
        this.mWebrequestHandler = new WebRequestHandler();
    }

    void validateAuthorityADFS(URL authorizationEndpoint, String domain) throws AuthenticationException {
        if (StringExtensions.isNullOrBlank((String)domain)) {
            throw new IllegalArgumentException("Cannot validate AD FS Authority with domain [null]");
        }
        Discovery.validateADFS(authorizationEndpoint, domain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateAuthority(URL authorizationEndpoint) throws AuthenticationException {
        Discovery.verifyAuthorityValidInstance(authorizationEndpoint);
        if (AuthorityValidationMetadataCache.containsAuthorityHost(authorizationEndpoint)) {
            return;
        }
        String authorityHost = authorizationEndpoint.getHost().toLowerCase(Locale.US);
        String trustedHost = AAD_WHITELISTED_HOSTS.contains(authorizationEndpoint.getHost().toLowerCase(Locale.US)) ? authorityHost : TRUSTED_QUERY_INSTANCE;
        try {
            sInstanceDiscoveryNetworkRequestLock = Discovery.getLock();
            sInstanceDiscoveryNetworkRequestLock.lock();
            this.performInstanceDiscovery(authorizationEndpoint, trustedHost);
        }
        finally {
            sInstanceDiscoveryNetworkRequestLock.unlock();
        }
    }

    private static void validateADFS(URL authorizationEndpoint, String domain) throws AuthenticationException {
        URI authorityUri;
        try {
            authorityUri = authorizationEndpoint.toURI();
        }
        catch (URISyntaxException e) {
            throw new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_URL, "Authority URL/URI must be RFC 2396 compliant to use AD FS validation");
        }
        if (ADFS_VALIDATED_AUTHORITIES.get(domain) != null && ADFS_VALIDATED_AUTHORITIES.get(domain).contains(authorityUri)) {
            return;
        }
        DRSMetadata drsMetadata = new DRSMetadataRequestor().requestMetadata(domain);
        WebFingerMetadata webFingerMetadata = new WebFingerMetadataRequestor().requestMetadata(new WebFingerMetadataRequestParameters(authorizationEndpoint, drsMetadata));
        if (!ADFSWebFingerValidator.realmIsTrusted(authorityUri, webFingerMetadata)) {
            throw new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_INSTANCE);
        }
        if (ADFS_VALIDATED_AUTHORITIES.get(domain) == null) {
            ADFS_VALIDATED_AUTHORITIES.put(domain, new HashSet());
        }
        ADFS_VALIDATED_AUTHORITIES.get(domain).add(authorityUri);
    }

    public void setCorrelationId(UUID requestCorrelationId) {
        this.mCorrelationId = requestCorrelationId;
    }

    static URL constructAuthorityUrl(URL originalAuthority, String host) throws MalformedURLException {
        String path = originalAuthority.getPath().replaceFirst("/", "");
        Uri.Builder builder = new Uri.Builder().scheme(originalAuthority.getProtocol()).authority(host).appendPath(path);
        return new URL(builder.build().toString());
    }

    private void initValidList() {
        if (AAD_WHITELISTED_HOSTS.isEmpty()) {
            AAD_WHITELISTED_HOSTS.add("login.windows.net");
            AAD_WHITELISTED_HOSTS.add(TRUSTED_QUERY_INSTANCE);
            AAD_WHITELISTED_HOSTS.add("login.chinacloudapi.cn");
            AAD_WHITELISTED_HOSTS.add("login.microsoftonline.de");
            AAD_WHITELISTED_HOSTS.add("login-us.microsoftonline.com");
            AAD_WHITELISTED_HOSTS.add("login.microsoftonline.us");
        }
    }

    private void performInstanceDiscovery(URL authorityUrl, String trustedHost) throws AuthenticationException {
        boolean result;
        String methodName = ":performInstanceDiscovery";
        if (AuthorityValidationMetadataCache.containsAuthorityHost(authorityUrl)) {
            return;
        }
        HttpWebRequest.throwIfNetworkNotAvailable(this.mContext);
        try {
            URL queryUrl = this.buildQueryString(trustedHost, this.getAuthorizationCommonEndpoint(authorityUrl));
            Map<String, String> discoveryResponse = this.sendRequest(queryUrl);
            AzureActiveDirectory.initializeCloudMetadata((String)authorityUrl.getHost().toLowerCase(Locale.US), discoveryResponse);
            AuthorityValidationMetadataCache.processInstanceDiscoveryMetadata(authorityUrl, discoveryResponse);
            if (!AuthorityValidationMetadataCache.containsAuthorityHost(authorityUrl)) {
                ArrayList<String> aliases = new ArrayList<String>();
                aliases.add(authorityUrl.getHost());
                AuthorityValidationMetadataCache.updateInstanceDiscoveryMap(authorityUrl.getHost(), new InstanceDiscoveryMetadata(authorityUrl.getHost(), authorityUrl.getHost(), aliases));
            }
            result = AuthorityValidationMetadataCache.isAuthorityValidated(authorityUrl);
        }
        catch (JSONException e) {
            Logger.e("Discovery:performInstanceDiscovery", "Error when validating authority. ", "", ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_INSTANCE, e);
            throw new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_INSTANCE, e.getMessage(), e);
        }
        catch (SocketTimeoutException e) {
            Logger.e("Discovery:performInstanceDiscovery", "Error when validating authority. ", "", ADALError.DEVICE_CONNECTION_IS_NOT_AVAILABLE, e);
            throw new AuthenticationException(ADALError.DEVICE_CONNECTION_IS_NOT_AVAILABLE, e.getMessage(), e);
        }
        catch (IOException e) {
            Logger.e("Discovery:performInstanceDiscovery", "Error when validating authority. ", "", ADALError.IO_EXCEPTION, e);
            throw new AuthenticationException(ADALError.IO_EXCEPTION, e.getMessage(), e);
        }
        if (!result) {
            throw new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_INSTANCE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> sendRequest(URL queryUrl) throws IOException, JSONException, AuthenticationException {
        Logger.v(TAG, "Sending discovery request to query url. ", "queryUrl: " + queryUrl, null);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Accept", "application/json");
        if (this.mCorrelationId != null) {
            headers.put("client-request-id", this.mCorrelationId.toString());
            headers.put("return-client-request-id", "true");
        }
        try {
            ClientMetrics.INSTANCE.beginClientMetricsRecord(queryUrl, this.mCorrelationId, headers);
            HttpWebResponse webResponse = this.mWebrequestHandler.sendGet(queryUrl, headers);
            ClientMetrics.INSTANCE.setLastError(null);
            Map<String, String> discoveryResponse = this.parseResponse(webResponse);
            if (discoveryResponse.containsKey("error_codes")) {
                String errorCodes = discoveryResponse.get("error_codes");
                ClientMetrics.INSTANCE.setLastError(errorCodes);
                throw new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_INSTANCE, "Fail to valid authority with errors: " + errorCodes);
            }
            Map<String, String> map = discoveryResponse;
            return map;
        }
        finally {
            ClientMetrics.INSTANCE.endClientMetricsRecord("instance", this.mCorrelationId);
        }
    }

    static void verifyAuthorityValidInstance(URL authorizationEndpoint) throws AuthenticationException {
        if (authorizationEndpoint == null || StringExtensions.isNullOrBlank((String)authorizationEndpoint.getHost()) || !authorizationEndpoint.getProtocol().equals("https") || !StringExtensions.isNullOrBlank((String)authorizationEndpoint.getQuery()) || !StringExtensions.isNullOrBlank((String)authorizationEndpoint.getRef()) || StringExtensions.isNullOrBlank((String)authorizationEndpoint.getPath())) {
            throw new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_INSTANCE);
        }
    }

    private Map<String, String> parseResponse(HttpWebResponse webResponse) throws JSONException {
        return HashMapExtensions.getJsonResponse((HttpWebResponse)webResponse);
    }

    private String getAuthorizationCommonEndpoint(URL authorizationEndpointUrl) {
        return new Uri.Builder().scheme("https").authority(authorizationEndpointUrl.getHost()).appendPath(AUTHORIZATION_COMMON_ENDPOINT).build().toString();
    }

    private URL buildQueryString(String instance, String authorizationEndpointUrl) throws MalformedURLException {
        Uri.Builder builder = new Uri.Builder();
        builder.scheme("https").authority(instance);
        builder.appendEncodedPath(INSTANCE_DISCOVERY_SUFFIX).appendQueryParameter(API_VERSION_KEY, API_VERSION_VALUE).appendQueryParameter(AUTHORIZATION_ENDPOINT_KEY, authorizationEndpointUrl);
        return new URL(builder.build().toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ReentrantLock getLock() {
        if (sInstanceDiscoveryNetworkRequestLock != null) return sInstanceDiscoveryNetworkRequestLock;
        Class<Discovery> clazz = Discovery.class;
        synchronized (Discovery.class) {
            if (sInstanceDiscoveryNetworkRequestLock != null) return sInstanceDiscoveryNetworkRequestLock;
            sInstanceDiscoveryNetworkRequestLock = new ReentrantLock();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstanceDiscoveryNetworkRequestLock;
        }
    }

    static Set<String> getValidHosts() {
        return AAD_WHITELISTED_HOSTS;
    }

    static {
        AAD_WHITELISTED_HOSTS = Collections.synchronizedSet(new HashSet());
        ADFS_VALIDATED_AUTHORITIES = Collections.synchronizedMap(new HashMap());
    }
}

