/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.content.Intent;
import android.text.TextUtils;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.AuthenticationRequest;
import com.microsoft.aad.adal.ChallengeResponseBuilder;
import com.microsoft.aad.adal.JWSBuilder;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.Oauth2;
import com.microsoft.identity.common.adal.internal.util.StringExtensions;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;

public class WebviewHelper {
    private static final String TAG = "WebviewHelper";
    private final Intent mRequestIntent;
    private final AuthenticationRequest mRequest;
    private final Oauth2 mOauth;

    public WebviewHelper(Intent requestIntent) {
        this.mRequestIntent = requestIntent;
        this.mRequest = this.getAuthenticationRequestFromIntent(this.mRequestIntent);
        this.mOauth = new Oauth2(this.mRequest);
    }

    public void validateRequestIntent() {
        if (this.mRequest == null) {
            Logger.v(TAG, "Request item is null, so it returns to caller");
            throw new IllegalArgumentException("Request is null");
        }
        if (TextUtils.isEmpty((CharSequence)this.mRequest.getAuthority())) {
            throw new IllegalArgumentException("Authority is null");
        }
        if (TextUtils.isEmpty((CharSequence)this.mRequest.getResource())) {
            throw new IllegalArgumentException("Resource is null");
        }
        if (TextUtils.isEmpty((CharSequence)this.mRequest.getClientId())) {
            throw new IllegalArgumentException("ClientId is null");
        }
        if (TextUtils.isEmpty((CharSequence)this.mRequest.getRedirectUri())) {
            throw new IllegalArgumentException("RedirectUri is null");
        }
    }

    public String getStartUrl() throws UnsupportedEncodingException {
        return this.mOauth.getCodeRequestUrl();
    }

    public String getRedirectUrl() {
        return this.mRequest.getRedirectUri();
    }

    public Intent getResultIntent(String finalUrl) {
        if (this.mRequestIntent != null) {
            AuthenticationRequest authRequest = this.getAuthenticationRequestFromIntent(this.mRequestIntent);
            Intent resultIntent = new Intent();
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserFinalUrl", finalUrl);
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserRequestInfo", (Serializable)authRequest);
            resultIntent.putExtra("com.microsoft.aad.adal:RequestId", authRequest.getRequestId());
            return resultIntent;
        }
        throw new IllegalArgumentException("requestIntent is null");
    }

    private AuthenticationRequest getAuthenticationRequestFromIntent(Intent callingIntent) {
        AuthenticationRequest authRequest = null;
        Serializable request = callingIntent.getSerializableExtra("com.microsoft.aad.adal:BrowserRequestMessage");
        if (request instanceof AuthenticationRequest) {
            authRequest = (AuthenticationRequest)request;
        }
        return authRequest;
    }

    public PreKeyAuthInfo getPreKeyAuthInfo(String challengeUrl) throws UnsupportedEncodingException, AuthenticationException {
        JWSBuilder jwsBuilder = new JWSBuilder();
        ChallengeResponseBuilder certHandler = new ChallengeResponseBuilder(jwsBuilder);
        ChallengeResponseBuilder.ChallengeResponse challengeResponse = certHandler.getChallengeResponseFromUri(challengeUrl);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", challengeResponse.getAuthorizationHeaderValue());
        String loadUrl = challengeResponse.getSubmitUrl();
        HashMap parameters = StringExtensions.getUrlParameters((String)challengeResponse.getSubmitUrl());
        Logger.i(TAG, "Get submit url. ", "SubmitUrl:" + challengeResponse.getSubmitUrl());
        if (!parameters.containsKey("client_id")) {
            loadUrl = loadUrl + "?" + this.mOauth.getAuthorizationEndpointQueryParameters();
        }
        return new PreKeyAuthInfo(headers, loadUrl);
    }

    public static class PreKeyAuthInfo {
        private final HashMap<String, String> mHttpHeaders;
        private final String mLoadUrl;

        public PreKeyAuthInfo(HashMap<String, String> httpHeaders, String loadUrl) {
            this.mHttpHeaders = httpHeaders;
            this.mLoadUrl = loadUrl;
        }

        public HashMap<String, String> getHttpHeaders() {
            return this.mHttpHeaders;
        }

        public String getLoadUrl() {
            return this.mLoadUrl;
        }
    }
}

