/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.util.Pair;
import com.microsoft.aad.adal.DefaultEvent;
import com.microsoft.aad.adal.Discovery;
import com.microsoft.aad.adal.StringExtensions;
import com.microsoft.aad.adal.TelemetryUtils;
import java.net.URL;
import java.util.List;
import java.util.Map;

final class HttpEvent
extends DefaultEvent {
    private static final String TAG = HttpEvent.class.getSimpleName();

    HttpEvent(String eventName) {
        this.getEventList().add((Pair<String, String>)Pair.create((Object)"Microsoft.ADAL.event_name", (Object)eventName));
    }

    void setUserAgent(String userAgent) {
        this.setProperty("Microsoft.ADAL.user_agent", userAgent);
    }

    void setMethod(String method) {
        this.setProperty("Microsoft.ADAL.method", method);
    }

    void setQueryParameters(String queryParameters) {
        this.setProperty("Microsoft.ADAL.query_params", queryParameters);
    }

    void setResponseCode(int responseCode) {
        this.setProperty("Microsoft.ADAL.response_code", String.valueOf(responseCode));
    }

    void setApiVersion(String apiVersion) {
        this.setProperty("Microsoft.ADAL.api_version", apiVersion);
    }

    void setHttpPath(URL httpPath) {
        String authority = httpPath.getAuthority();
        if (!Discovery.getValidHosts().contains(authority)) {
            return;
        }
        String[] splitArray = httpPath.getPath().split("/");
        StringBuilder logPath = new StringBuilder();
        logPath.append(httpPath.getProtocol());
        logPath.append("://");
        logPath.append(authority);
        logPath.append("/");
        for (int i = 2; i < splitArray.length; ++i) {
            logPath.append(splitArray[i]);
            logPath.append("/");
        }
        this.setProperty("Microsoft.ADAL.http_path", logPath.toString());
    }

    void setOauthErrorCode(String errorCode) {
        this.setProperty("Microsoft.ADAL.oauth_error_code", errorCode);
    }

    void setRequestIdHeader(String requestIdHeader) {
        this.setProperty("Microsoft.ADAL.x_ms_request_id", requestIdHeader);
    }

    void setXMsCliTelemData(TelemetryUtils.CliTelemInfo cliTelemInfo) {
        if (null == cliTelemInfo) {
            return;
        }
        this.setServerErrorCode(cliTelemInfo.getServerErrorCode());
        this.setServerSubErrorCode(cliTelemInfo.getServerSubErrorCode());
        this.setRefreshTokenAge(cliTelemInfo.getRefreshTokenAge());
        this.setSpeRing(cliTelemInfo.getSpeRing());
    }

    void setServerErrorCode(String errorCode) {
        if (!StringExtensions.isNullOrBlank(errorCode) && !errorCode.equals("0")) {
            this.setProperty("Microsoft.ADAL.server_error_code", errorCode.trim());
        }
    }

    void setServerSubErrorCode(String subErrorCode) {
        if (!StringExtensions.isNullOrBlank(subErrorCode) && !subErrorCode.equals("0")) {
            this.setProperty("Microsoft.ADAL.server_sub_error_code", subErrorCode.trim());
        }
    }

    void setRefreshTokenAge(String tokenAge) {
        if (!StringExtensions.isNullOrBlank(tokenAge)) {
            this.setProperty("Microsoft.ADAL.rt_age", tokenAge.trim());
        }
    }

    void setSpeRing(String speRing) {
        if (!StringExtensions.isNullOrBlank(speRing)) {
            this.setProperty("Microsoft.ADAL.spe_info", speRing.trim());
        }
    }

    @Override
    public void processEvent(Map<String, String> dispatchMap) {
        String countObject = dispatchMap.get("Microsoft.ADAL.http_event_count");
        if (countObject == null) {
            dispatchMap.put("Microsoft.ADAL.http_event_count", "1");
        } else {
            dispatchMap.put("Microsoft.ADAL.http_event_count", Integer.toString(Integer.parseInt(countObject) + 1));
        }
        if (dispatchMap.containsKey("Microsoft.ADAL.response_code")) {
            dispatchMap.put("Microsoft.ADAL.response_code", "");
        }
        if (dispatchMap.containsKey("Microsoft.ADAL.oauth_error_code")) {
            dispatchMap.put("Microsoft.ADAL.oauth_error_code", "");
        }
        if (dispatchMap.containsKey("Microsoft.ADAL.http_path")) {
            dispatchMap.put("Microsoft.ADAL.http_path", "");
        }
        if (dispatchMap.containsKey("Microsoft.ADAL.x_ms_request_id")) {
            dispatchMap.put("Microsoft.ADAL.x_ms_request_id", "");
        }
        if (dispatchMap.containsKey("Microsoft.ADAL.server_error_code")) {
            dispatchMap.remove("Microsoft.ADAL.server_error_code");
        }
        if (dispatchMap.containsKey("Microsoft.ADAL.server_sub_error_code")) {
            dispatchMap.remove("Microsoft.ADAL.server_sub_error_code");
        }
        if (dispatchMap.containsKey("Microsoft.ADAL.rt_age")) {
            dispatchMap.remove("Microsoft.ADAL.rt_age");
        }
        if (dispatchMap.containsKey("Microsoft.ADAL.spe_info")) {
            dispatchMap.remove("Microsoft.ADAL.spe_info");
        }
        List<Pair<String, String>> eventList = this.getEventList();
        for (Pair<String, String> eventPair : eventList) {
            String name = (String)eventPair.first;
            if (!name.equals("Microsoft.ADAL.response_code") && !name.equals("Microsoft.ADAL.x_ms_request_id") && !name.equals("Microsoft.ADAL.oauth_error_code") && !name.equals("Microsoft.ADAL.http_path") && !name.equals("Microsoft.ADAL.server_error_code") && !name.equals("Microsoft.ADAL.server_sub_error_code") && !name.equals("Microsoft.ADAL.rt_age") && !name.equals("Microsoft.ADAL.spe_info")) continue;
            dispatchMap.put(name, (String)eventPair.second);
        }
    }
}

