/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationActivity;
import com.microsoft.aad.adal.AuthenticationDialog;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.AuthenticationRequest;
import com.microsoft.aad.adal.AuthenticationResult;
import com.microsoft.aad.adal.AuthenticationSettings;
import com.microsoft.aad.adal.HttpWebRequest;
import com.microsoft.aad.adal.IWindowComponent;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.Oauth2;
import com.microsoft.aad.adal.PromptBehavior;
import com.microsoft.aad.adal.StringExtensions;
import com.microsoft.aad.adal.TokenCacheAccessor;
import com.microsoft.aad.adal.WebRequestHandler;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;

final class AcquireTokenInteractiveRequest {
    private static final String TAG = AcquireTokenInteractiveRequest.class.getSimpleName();
    private final Context mContext;
    private final TokenCacheAccessor mTokenCacheAccessor;
    private final AuthenticationRequest mAuthRequest;

    AcquireTokenInteractiveRequest(Context context, AuthenticationRequest authRequest, TokenCacheAccessor tokenCacheAccessor) {
        this.mContext = context;
        this.mTokenCacheAccessor = tokenCacheAccessor;
        this.mAuthRequest = authRequest;
    }

    void acquireToken(IWindowComponent activity, AuthenticationDialog dialog) throws AuthenticationException {
        String methodName = ":acquireToken";
        HttpWebRequest.throwIfNetworkNotAvailable(this.mContext);
        if (PromptBehavior.FORCE_PROMPT == this.mAuthRequest.getPrompt()) {
            Logger.v(TAG + ":acquireToken", "FORCE_PROMPT is set for embedded flow, reset it as Always.");
            this.mAuthRequest.setPrompt(PromptBehavior.Always);
        }
        if (dialog != null) {
            dialog.show();
        } else if (!this.startAuthenticationActivity(activity)) {
            throw new AuthenticationException(ADALError.DEVELOPER_ACTIVITY_IS_NOT_RESOLVED);
        }
    }

    AuthenticationResult acquireTokenWithAuthCode(String url) throws AuthenticationException {
        AuthenticationResult result;
        String methodName = ":acquireTokenWithAuthCode";
        Logger.v(TAG + ":acquireTokenWithAuthCode", "Start token acquisition with auth code.", this.mAuthRequest.getLogInfo(), null);
        Oauth2 oauthRequest = new Oauth2(this.mAuthRequest, new WebRequestHandler());
        try {
            result = oauthRequest.getToken(url);
            Logger.v(TAG + ":acquireTokenWithAuthCode", "OnActivityResult processed the result.");
        }
        catch (AuthenticationException | IOException exc) {
            String msg = "Error in processing code to get token. " + this.getCorrelationInfo();
            throw new AuthenticationException(ADALError.AUTHORIZATION_CODE_NOT_EXCHANGED_FOR_TOKEN, msg, exc);
        }
        if (result == null) {
            Logger.e(TAG + ":acquireTokenWithAuthCode", "Returned result with exchanging auth code for token is null" + this.getCorrelationInfo(), "", ADALError.AUTHORIZATION_CODE_NOT_EXCHANGED_FOR_TOKEN);
            throw new AuthenticationException(ADALError.AUTHORIZATION_CODE_NOT_EXCHANGED_FOR_TOKEN, this.getCorrelationInfo());
        }
        if (!StringExtensions.isNullOrBlank(result.getErrorCode())) {
            Logger.e(TAG + ":acquireTokenWithAuthCode", " ErrorCode:" + result.getErrorCode(), " ErrorDescription:" + result.getErrorDescription(), ADALError.AUTH_FAILED);
            throw new AuthenticationException(ADALError.AUTH_FAILED, " ErrorCode:" + result.getErrorCode());
        }
        if (!StringExtensions.isNullOrBlank(result.getAccessToken()) && this.mTokenCacheAccessor != null) {
            try {
                this.mTokenCacheAccessor.updateTokenCache(this.mAuthRequest.getResource(), this.mAuthRequest.getClientId(), result);
            }
            catch (MalformedURLException e) {
                throw new AuthenticationException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_URL, e.getMessage(), e);
            }
        }
        return result;
    }

    private boolean startAuthenticationActivity(IWindowComponent activity) {
        String methodName = ":startAuthenticationActivity";
        Intent intent = this.getAuthenticationActivityIntent();
        if (!this.resolveIntent(intent)) {
            Logger.e(TAG + ":startAuthenticationActivity", "Intent is not resolved", "", ADALError.DEVELOPER_ACTIVITY_IS_NOT_RESOLVED);
            return false;
        }
        try {
            activity.startActivityForResult(intent, 1001);
        }
        catch (ActivityNotFoundException e) {
            Logger.e(TAG + ":startAuthenticationActivity", "Activity login is not found after resolving intent", "", ADALError.DEVELOPER_ACTIVITY_IS_NOT_RESOLVED, e);
            return false;
        }
        return true;
    }

    private Intent getAuthenticationActivityIntent() {
        Intent intent = new Intent();
        if (AuthenticationSettings.INSTANCE.getActivityPackageName() != null) {
            intent.setClassName(AuthenticationSettings.INSTANCE.getActivityPackageName(), AuthenticationActivity.class.getName());
        } else {
            intent.setClass(this.mContext, AuthenticationActivity.class);
        }
        intent.putExtra("com.microsoft.aad.adal:BrowserRequestMessage", (Serializable)this.mAuthRequest);
        return intent;
    }

    private boolean resolveIntent(Intent intent) {
        ResolveInfo resolveInfo = this.mContext.getPackageManager().resolveActivity(intent, 0);
        return resolveInfo != null;
    }

    private String getCorrelationInfo() {
        return String.format(" CorrelationId: %s", this.mAuthRequest.getCorrelationId().toString());
    }
}

