/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import com.microsoft.aad.adal.ITokenCacheStore;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.TokenCacheItem;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class MemoryTokenCacheStore
implements ITokenCacheStore {
    private static final long serialVersionUID = 3465700945655867086L;
    private static final String TAG = "MemoryTokenCacheStore";
    private final Map<String, TokenCacheItem> mCache = new HashMap<String, TokenCacheItem>();
    private transient Object mCacheLock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TokenCacheItem getItem(String key) {
        if (key == null) {
            throw new IllegalArgumentException("The input key is null.");
        }
        Logger.v(TAG, "Get Item from cache. Key:" + key);
        Object object = this.mCacheLock;
        synchronized (object) {
            return this.mCache.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setItem(String key, TokenCacheItem item) {
        if (item == null) {
            throw new IllegalArgumentException("item");
        }
        if (key == null) {
            throw new IllegalArgumentException("key");
        }
        Logger.v(TAG, "Set Item to cache. Key:" + key);
        Object object = this.mCacheLock;
        synchronized (object) {
            this.mCache.put(key, item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeItem(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key");
        }
        Logger.v(TAG, "Remove Item from cache. Key:" + key.hashCode());
        Object object = this.mCacheLock;
        synchronized (object) {
            this.mCache.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() {
        Logger.v(TAG, "Remove all items from cache. Key:");
        Object object = this.mCacheLock;
        synchronized (object) {
            this.mCache.clear();
        }
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream inputStream) throws IOException, ClassNotFoundException {
        inputStream.defaultReadObject();
        this.mCacheLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(String key) {
        if (key == null) {
            throw new IllegalArgumentException("key");
        }
        Logger.v(TAG, "contains Item from cache. Key:" + key);
        Object object = this.mCacheLock;
        synchronized (object) {
            return this.mCache.get(key) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Iterator<TokenCacheItem> getAll() {
        Logger.v(TAG, "Retrieving all items from cache. ");
        Object object = this.mCacheLock;
        synchronized (object) {
            return this.mCache.values().iterator();
        }
    }
}

