/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Process;
import android.os.RemoteException;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.BrokerEvent;
import com.microsoft.aad.adal.BrokerProxy;
import com.microsoft.aad.adal.Callback;
import com.microsoft.aad.adal.CallbackExecutor;
import com.microsoft.aad.adal.IBrokerAccountService;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.UserInfo;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;

final class BrokerAccountServiceHandler {
    private static final String TAG = BrokerAccountServiceHandler.class.getSimpleName();
    private static final String BROKER_ACCOUNT_SERVICE_INTENT_FILTER = "com.microsoft.workaccount.BrokerAccount";
    private ConcurrentMap<BrokerAccountServiceConnection, CallbackExecutor<BrokerAccountServiceConnection>> mPendingConnections = new ConcurrentHashMap<BrokerAccountServiceConnection, CallbackExecutor<BrokerAccountServiceConnection>>();
    private static ExecutorService sThreadExecutor = Executors.newCachedThreadPool();

    public static BrokerAccountServiceHandler getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private BrokerAccountServiceHandler() {
    }

    UserInfo[] getBrokerUsers(Context context) throws IOException {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final AtomicReference<Object> userBundle = new AtomicReference<Object>(null);
        final AtomicReference<Object> exception = new AtomicReference<Object>(null);
        this.performAsyncCallOnBound(context, new Callback<BrokerAccountServiceConnection>(){

            @Override
            public void onSuccess(BrokerAccountServiceConnection connection) {
                IBrokerAccountService brokerAccountService = connection.getBrokerAccountServiceProvider();
                try {
                    userBundle.set(brokerAccountService.getBrokerUsers());
                }
                catch (RemoteException ex) {
                    exception.set(ex);
                }
                countDownLatch.countDown();
            }

            @Override
            public void onError(Throwable throwable) {
                exception.set(throwable);
                countDownLatch.countDown();
            }
        }, null);
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            exception.set(e);
        }
        Throwable exceptionForRetrievingBrokerUsers = exception.getAndSet(null);
        if (exceptionForRetrievingBrokerUsers != null) {
            throw new IOException(exceptionForRetrievingBrokerUsers.getMessage(), exceptionForRetrievingBrokerUsers);
        }
        Bundle userBundleResult = userBundle.getAndSet(null);
        return this.convertUserInfoBundleToArray(userBundleResult);
    }

    public Bundle getAuthToken(final Context context, final Bundle requestBundle, BrokerEvent brokerEvent) throws AuthenticationException {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final AtomicReference<Object> bundleResult = new AtomicReference<Object>(null);
        final AtomicReference<Object> exception = new AtomicReference<Object>(null);
        this.performAsyncCallOnBound(context, new Callback<BrokerAccountServiceConnection>(){

            @Override
            public void onSuccess(BrokerAccountServiceConnection result) {
                IBrokerAccountService brokerAccountService = result.getBrokerAccountServiceProvider();
                try {
                    bundleResult.set(brokerAccountService.acquireTokenSilently(BrokerAccountServiceHandler.this.prepareGetAuthTokenRequestData(context, requestBundle)));
                }
                catch (RemoteException remoteException) {
                    exception.set(remoteException);
                }
                countDownLatch.countDown();
            }

            @Override
            public void onError(Throwable throwable) {
                exception.set(throwable);
                countDownLatch.countDown();
            }
        }, brokerEvent);
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            exception.set(e);
        }
        Throwable throwable = exception.getAndSet(null);
        if (throwable != null) {
            throw new AuthenticationException(ADALError.AUTH_REFRESH_FAILED_PROMPT_NOT_ALLOWED, throwable.getMessage(), throwable);
        }
        return bundleResult.getAndSet(null);
    }

    public Intent getIntentForInteractiveRequest(Context context, BrokerEvent brokerEvent) {
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        final AtomicReference<Object> bundleResult = new AtomicReference<Object>(null);
        final AtomicReference<Object> exception = new AtomicReference<Object>(null);
        this.performAsyncCallOnBound(context, new Callback<BrokerAccountServiceConnection>(){

            @Override
            public void onSuccess(BrokerAccountServiceConnection result) {
                IBrokerAccountService brokerAccountService = result.getBrokerAccountServiceProvider();
                try {
                    bundleResult.set(brokerAccountService.getIntentForInteractiveRequest());
                }
                catch (RemoteException remoteException) {
                    exception.set(remoteException);
                }
                countDownLatch.countDown();
            }

            @Override
            public void onError(Throwable throwable) {
                exception.set(throwable);
                countDownLatch.countDown();
            }
        }, brokerEvent);
        try {
            countDownLatch.await();
        }
        catch (InterruptedException e) {
            exception.set(e);
        }
        Throwable throwable = exception.getAndSet(null);
        if (throwable != null) {
            Logger.e(TAG, "Didn't receive the activity to launch from broker: " + throwable.getMessage(), "", null, throwable);
        }
        return bundleResult.getAndSet(null);
    }

    public void removeAccounts(Context context) {
        this.performAsyncCallOnBound(context, new Callback<BrokerAccountServiceConnection>(){

            @Override
            public void onSuccess(BrokerAccountServiceConnection result) {
                try {
                    result.getBrokerAccountServiceProvider().removeAccounts();
                }
                catch (RemoteException remoteException) {
                    Logger.e(TAG, "Encounter exception when removing accounts from broker", remoteException.getMessage(), null, remoteException);
                }
            }

            @Override
            public void onError(Throwable throwable) {
                Logger.e(TAG, "Encounter exception when removing accounts from broker", throwable.getMessage(), null, throwable);
            }
        }, null);
    }

    public static Intent getIntentForBrokerAccountService(Context context) {
        BrokerProxy brokerProxy = new BrokerProxy(context);
        String brokerAppName = brokerProxy.getCurrentActiveBrokerPackageName();
        if (brokerAppName == null) {
            Logger.v(TAG, "No recognized broker is installed on the device.");
            return null;
        }
        Intent brokerAccountServiceToBind = new Intent(BROKER_ACCOUNT_SERVICE_INTENT_FILTER);
        brokerAccountServiceToBind.setPackage(brokerAppName);
        brokerAccountServiceToBind.setClassName(brokerAppName, "com.microsoft.aad.adal.BrokerAccountService");
        return brokerAccountServiceToBind;
    }

    private Map<String, String> prepareGetAuthTokenRequestData(Context context, Bundle requestBundle) {
        Set requestBundleKeys = requestBundle.keySet();
        HashMap<String, String> requestData = new HashMap<String, String>();
        for (String key : requestBundleKeys) {
            if (key.equals("com.microsoft.aad.adal:RequestId")) {
                requestData.put(key, String.valueOf(requestBundle.getInt(key)));
                continue;
            }
            requestData.put(key, requestBundle.getString(key));
        }
        requestData.put("caller.info.package", context.getPackageName());
        return requestData;
    }

    private UserInfo[] convertUserInfoBundleToArray(Bundle usersBundle) {
        if (usersBundle == null) {
            Logger.v(TAG, "No user info returned from broker account service.");
            return new UserInfo[0];
        }
        ArrayList<UserInfo> brokerUsers = new ArrayList<UserInfo>();
        Set users = usersBundle.keySet();
        for (String user : users) {
            Bundle userBundle = usersBundle.getBundle(user);
            String userId = userBundle.getString("account.userinfo.userid");
            String givenName = userBundle.getString("account.userinfo.given.name");
            String familyName = userBundle.getString("account.userinfo.family.name");
            String identityProvider = userBundle.getString("account.userinfo.identity.provider");
            String displayableId = userBundle.getString("account.userinfo.userid.displayable");
            brokerUsers.add(new UserInfo(userId, givenName, familyName, identityProvider, displayableId));
        }
        return brokerUsers.toArray(new UserInfo[brokerUsers.size()]);
    }

    private void performAsyncCallOnBound(final Context context, final Callback<BrokerAccountServiceConnection> callback, BrokerEvent event) {
        this.bindToBrokerAccountService(context, new Callback<BrokerAccountServiceConnection>(){

            @Override
            public void onSuccess(final BrokerAccountServiceConnection result) {
                if (Looper.myLooper() != Looper.getMainLooper()) {
                    callback.onSuccess(result);
                    result.unBindService(context);
                } else {
                    sThreadExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            callback.onSuccess(result);
                            result.unBindService(context);
                        }
                    });
                }
            }

            @Override
            public void onError(Throwable throwable) {
                callback.onError(throwable);
            }
        }, event);
    }

    private void bindToBrokerAccountService(Context context, Callback<BrokerAccountServiceConnection> callback, BrokerEvent brokerEvent) {
        Logger.v(TAG, "Binding to BrokerAccountService for caller uid: " + Process.myUid());
        Intent brokerAccountServiceToBind = BrokerAccountServiceHandler.getIntentForBrokerAccountService(context);
        BrokerAccountServiceConnection connection = new BrokerAccountServiceConnection();
        if (brokerEvent != null) {
            connection.setTelemetryEvent(brokerEvent);
            brokerEvent.setBrokerAccountServerStartsBinding();
        }
        CallbackExecutor<BrokerAccountServiceConnection> callbackExecutor = new CallbackExecutor<BrokerAccountServiceConnection>(callback);
        this.mPendingConnections.put(connection, callbackExecutor);
        boolean serviceBound = context.bindService(brokerAccountServiceToBind, (ServiceConnection)connection, 1);
        Logger.v(TAG, "The status for brokerAccountService bindService call is: " + Boolean.valueOf(serviceBound));
        if (brokerEvent != null) {
            brokerEvent.setBrokerAccountServiceBindingSucceed(serviceBound);
        }
    }

    private class BrokerAccountServiceConnection
    implements ServiceConnection {
        private IBrokerAccountService mBrokerAccountService;
        private boolean mBound;
        private BrokerEvent mEvent;

        private BrokerAccountServiceConnection() {
        }

        public IBrokerAccountService getBrokerAccountServiceProvider() {
            return this.mBrokerAccountService;
        }

        public void onServiceConnected(ComponentName name, IBinder service) {
            CallbackExecutor callbackExecutor;
            Logger.v(TAG, "Broker Account service is connected.");
            this.mBrokerAccountService = IBrokerAccountService.Stub.asInterface(service);
            this.mBound = true;
            if (this.mEvent != null) {
                this.mEvent.setBrokerAccountServiceConnected();
            }
            if ((callbackExecutor = (CallbackExecutor)BrokerAccountServiceHandler.this.mPendingConnections.remove(this)) != null) {
                callbackExecutor.onSuccess(this);
            } else {
                Logger.v(TAG, "No callback is found.");
            }
        }

        public void onServiceDisconnected(ComponentName name) {
            Logger.v(TAG, "Broker Account service is disconnected.");
            this.mBound = false;
        }

        public void unBindService(final Context context) {
            Handler handler = new Handler(Looper.getMainLooper());
            handler.post(new Runnable(){

                @Override
                public void run() {
                    if (BrokerAccountServiceConnection.this.mBound) {
                        try {
                            context.unbindService((ServiceConnection)BrokerAccountServiceConnection.this);
                        }
                        catch (IllegalArgumentException exception) {
                            Logger.e(TAG, "Unbind threw IllegalArgumentException", "", null, exception);
                        }
                        finally {
                            BrokerAccountServiceConnection.this.mBound = false;
                        }
                    }
                }
            });
        }

        public void setTelemetryEvent(BrokerEvent event) {
            this.mEvent = event;
        }
    }

    private static final class InstanceHolder {
        static final BrokerAccountServiceHandler INSTANCE = new BrokerAccountServiceHandler();

        private InstanceHolder() {
        }
    }
}

