/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AccountManagerFuture;
import android.accounts.AuthenticatorDescription;
import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Base64;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.AuthenticationRequest;
import com.microsoft.aad.adal.AuthenticationResult;
import com.microsoft.aad.adal.AuthenticationSettings;
import com.microsoft.aad.adal.BrokerAccountServiceHandler;
import com.microsoft.aad.adal.IBrokerProxy;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.PromptBehavior;
import com.microsoft.aad.adal.StringExtensions;
import com.microsoft.aad.adal.UrlExtensions;
import com.microsoft.aad.adal.UsageAuthenticationException;
import com.microsoft.aad.adal.UserInfo;
import com.microsoft.aad.adal.Utility;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;

@TargetApi(value=14)
class BrokerProxy
implements IBrokerProxy {
    private static final String TAG = "BrokerProxy";
    private Context mContext;
    private AccountManager mAcctManager;
    private Handler mHandler;
    private final String mBrokerTag;
    private static final String KEY_ACCOUNT_LIST_DELIM = "|";
    private static final String KEY_SHARED_PREF_ACCOUNT_LIST = "com.microsoft.aad.adal.account.list";
    private static final String KEY_APP_ACCOUNTS_FOR_TOKEN_REMOVAL = "AppAccountsForTokenRemoval";
    public static final String DATA_USER_INFO = "com.microsoft.workaccount.user.info";
    private static final int ACCOUNT_MANAGER_ERROR_CODE_BAD_AUTHENTICATION = 9;
    private static final String AUTHENTICATOR_CANCELS_REQUEST = "Authenticator cancels the request";

    public BrokerProxy() {
        this.mBrokerTag = AuthenticationSettings.INSTANCE.getBrokerSignature();
    }

    public BrokerProxy(Context ctx) {
        this.mContext = ctx;
        this.mAcctManager = AccountManager.get((Context)this.mContext);
        this.mHandler = new Handler(this.mContext.getMainLooper());
        this.mBrokerTag = AuthenticationSettings.INSTANCE.getBrokerSignature();
    }

    @Override
    public SwitchToBroker canSwitchToBroker(String authorityUrlStr) {
        boolean canSwitchToBroker;
        URL authorityUrl;
        try {
            authorityUrl = new URL(authorityUrlStr);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(ADALError.DEVELOPER_AUTHORITY_IS_NOT_VALID_URL.name());
        }
        String packageName = this.mContext.getPackageName();
        boolean bl = canSwitchToBroker = AuthenticationSettings.INSTANCE.getUseBroker() && !packageName.equalsIgnoreCase(AuthenticationSettings.INSTANCE.getBrokerPackageName()) && !packageName.equalsIgnoreCase("com.azure.authenticator") && this.verifyAuthenticator(this.mAcctManager) && !UrlExtensions.isADFSAuthority(authorityUrl);
        if (!canSwitchToBroker) {
            Logger.v(TAG, "Broker auth is turned off or no valid broker is available on the device, cannot switch to broker.");
            return SwitchToBroker.CANNOT_SWITCH_TO_BROKER;
        }
        if (!this.isBrokerAccountServiceSupported()) {
            boolean bl2 = canSwitchToBroker = canSwitchToBroker && this.checkAccount(this.mAcctManager, "", "");
            if (!canSwitchToBroker) {
                Logger.v(TAG, "No valid account existed in broker, cannot switch to broker for auth.");
                return SwitchToBroker.CANNOT_SWITCH_TO_BROKER;
            }
            try {
                this.verifyBrokerPermissionsAPI23AndHigher();
            }
            catch (UsageAuthenticationException exception) {
                Logger.v(TAG, "Missing GET_ACCOUNTS permission, cannot switch to broker.");
                return SwitchToBroker.NEED_PERMISSIONS_TO_SWITCH_TO_BROKER;
            }
        }
        return SwitchToBroker.CAN_SWITCH_TO_BROKER;
    }

    @Override
    public boolean verifyUser(String username, String uniqueid) {
        if (!this.isBrokerAccountServiceSupported()) {
            return this.checkAccount(this.mAcctManager, username, uniqueid);
        }
        return true;
    }

    @Override
    public boolean canUseLocalCache(String authorityUrlStr) {
        if (this.canSwitchToBroker(authorityUrlStr) == SwitchToBroker.CANNOT_SWITCH_TO_BROKER) {
            Logger.v(TAG, "It does not use broker");
            return true;
        }
        String packageName = this.mContext.getPackageName();
        if (this.verifySignature(packageName)) {
            Logger.v(TAG, "Broker installer can use local cache");
            return true;
        }
        return false;
    }

    public boolean verifyBrokerPermissionsAPI22AndLess() throws UsageAuthenticationException {
        StringBuilder permissionMissing = new StringBuilder();
        if (Build.VERSION.SDK_INT < 23) {
            permissionMissing.append(this.checkPermission("android.permission.GET_ACCOUNTS"));
            permissionMissing.append(this.checkPermission("android.permission.MANAGE_ACCOUNTS"));
            permissionMissing.append(this.checkPermission("android.permission.USE_CREDENTIALS"));
            if (permissionMissing.length() == 0) {
                return true;
            }
            throw new UsageAuthenticationException(ADALError.DEVELOPER_BROKER_PERMISSIONS_MISSING, "Broker related permissions are missing for " + permissionMissing.toString());
        }
        Logger.v(TAG, "Misused of the checking function. This is function is only used to checking the broker permissions of API 22 or less.");
        return true;
    }

    @TargetApi(value=23)
    public boolean verifyBrokerPermissionsAPI23AndHigher() throws UsageAuthenticationException {
        StringBuilder permissionMissing = new StringBuilder();
        if (Build.VERSION.SDK_INT >= 23) {
            permissionMissing.append(this.checkPermission("android.permission.GET_ACCOUNTS"));
            if (permissionMissing.length() == 0) {
                return true;
            }
            throw new UsageAuthenticationException(ADALError.DEVELOPER_BROKER_PERMISSIONS_MISSING, "Broker related permissions are missing for " + permissionMissing.toString());
        }
        Logger.v(TAG, "Device is lower than 23, skip the GET_ACCOUNTS permission check.");
        return true;
    }

    private String checkPermission(String permissionName) {
        PackageManager pm = this.mContext.getPackageManager();
        if (pm.checkPermission(permissionName, this.mContext.getPackageName()) != 0) {
            Logger.w(TAG, "Broker related permissions are missing for " + permissionName, "", ADALError.DEVELOPER_BROKER_PERMISSIONS_MISSING);
            return permissionName + ' ';
        }
        return "";
    }

    private void verifyNotOnMainThread() {
        Looper looper = Looper.myLooper();
        if (looper != null && looper == this.mContext.getMainLooper()) {
            IllegalStateException exception = new IllegalStateException("calling this from your main thread can lead to deadlock");
            Logger.e(TAG, "calling this from your main thread can lead to deadlock and/or ANRs", "", ADALError.DEVELOPER_CALLING_ON_MAIN_THREAD, exception);
            if (this.mContext.getApplicationInfo().targetSdkVersion >= 8) {
                throw exception;
            }
        }
    }

    private Account findAccount(String accountName, Account[] accountList) {
        if (accountList != null) {
            for (Account account : accountList) {
                if (account == null || account.name == null || !account.name.equalsIgnoreCase(accountName)) continue;
                return account;
            }
        }
        return null;
    }

    private UserInfo findUserInfo(String userid, UserInfo[] userList) {
        if (userList != null) {
            for (UserInfo user : userList) {
                if (user == null || TextUtils.isEmpty((CharSequence)user.getUserId()) || !user.getUserId().equalsIgnoreCase(userid)) continue;
                return user;
            }
        }
        return null;
    }

    @Override
    public AuthenticationResult getAuthTokenInBackground(AuthenticationRequest request) throws AuthenticationException {
        this.verifyNotOnMainThread();
        Bundle requestBundle = this.getBrokerOptions(request);
        Bundle bundleResult = this.isBrokerAccountServiceSupported() ? BrokerAccountServiceHandler.getInstance().getAuthToken(this.mContext, requestBundle) : this.getAuthTokenFromAccountManager(request, requestBundle);
        if (bundleResult == null) {
            Logger.v(TAG, "No bundle result returned from broker for silent request.");
            return null;
        }
        return this.getResultFromBrokerResponse(bundleResult, request);
    }

    private Bundle getAuthTokenFromAccountManager(AuthenticationRequest request, Bundle requestBundle) throws AuthenticationException {
        Account targetAccount = this.getTargetAccount(request);
        Bundle bundleResult = null;
        if (targetAccount != null) {
            try {
                AccountManagerFuture result = this.mAcctManager.getAuthToken(targetAccount, "adal.authtoken.type", requestBundle, false, null, this.mHandler);
                Logger.v(TAG, "Received result from broker");
                bundleResult = (Bundle)result.getResult();
            }
            catch (OperationCanceledException e) {
                Logger.e(TAG, AUTHENTICATOR_CANCELS_REQUEST, "", ADALError.AUTH_FAILED_CANCELLED, e);
            }
            catch (AuthenticatorException e) {
                Logger.e(TAG, AUTHENTICATOR_CANCELS_REQUEST, "", ADALError.BROKER_AUTHENTICATOR_NOT_RESPONDING);
                if (e.getMessage() != null && e.getMessage().contains(ADALError.DEVICE_CONNECTION_IS_NOT_AVAILABLE.getDescription())) {
                    throw new AuthenticationException(ADALError.DEVICE_CONNECTION_IS_NOT_AVAILABLE, "Received error from broker, errorCode: " + e.getMessage());
                }
            }
            catch (IOException e) {
                Logger.e(TAG, AUTHENTICATOR_CANCELS_REQUEST, "", ADALError.BROKER_AUTHENTICATOR_IO_EXCEPTION);
            }
            Logger.v(TAG, "Returning result from broker");
            return bundleResult;
        }
        Logger.v(TAG, "Target account is not found");
        return null;
    }

    private boolean isBrokerAccountServiceSupported() {
        Intent brokerAccountServiceIntent = BrokerAccountServiceHandler.getIntentForBrokerAccountService(this.mContext);
        return this.isServiceSupported(this.mContext, brokerAccountServiceIntent);
    }

    private boolean isServiceSupported(Context context, Intent intent) {
        if (intent == null) {
            return false;
        }
        PackageManager packageManager = context.getPackageManager();
        List infos = packageManager.queryIntentServices(intent, 0);
        return infos != null && infos.size() > 0;
    }

    private Account getTargetAccount(AuthenticationRequest request) {
        Account targetAccount = null;
        Account[] accountList = this.mAcctManager.getAccountsByType("com.microsoft.workaccount");
        if (!TextUtils.isEmpty((CharSequence)request.getBrokerAccountName())) {
            targetAccount = this.findAccount(request.getBrokerAccountName(), accountList);
        } else {
            try {
                UserInfo[] users = this.getBrokerUsers();
                UserInfo matchingUser = this.findUserInfo(request.getUserId(), users);
                if (matchingUser != null) {
                    targetAccount = this.findAccount(matchingUser.getDisplayableId(), accountList);
                }
            }
            catch (AuthenticatorException | OperationCanceledException | IOException e) {
                Logger.e(TAG, e.getMessage(), "", ADALError.BROKER_AUTHENTICATOR_IO_EXCEPTION, e);
            }
        }
        return targetAccount;
    }

    private AuthenticationResult getResultFromBrokerResponse(Bundle bundleResult, AuthenticationRequest request) throws AuthenticationException {
        Date expires;
        if (bundleResult == null) {
            throw new IllegalArgumentException("bundleResult");
        }
        int errCode = bundleResult.getInt("errorCode");
        String msg = bundleResult.getString("errorMessage");
        String oauth2ErrorCode = bundleResult.getString("error");
        String oauth2ErrorDescription = bundleResult.getString("error_description");
        if (!StringExtensions.isNullOrBlank(msg)) {
            ADALError adalErrorCode;
            switch (errCode) {
                case 7: {
                    adalErrorCode = ADALError.BROKER_AUTHENTICATOR_BAD_ARGUMENTS;
                    break;
                }
                case 9: {
                    adalErrorCode = ADALError.BROKER_AUTHENTICATOR_BAD_AUTHENTICATION;
                    break;
                }
                case 6: {
                    adalErrorCode = ADALError.BROKER_AUTHENTICATOR_UNSUPPORTED_OPERATION;
                    break;
                }
                case 3: {
                    adalErrorCode = ADALError.DEVICE_CONNECTION_IS_NOT_AVAILABLE;
                    break;
                }
                default: {
                    adalErrorCode = ADALError.BROKER_AUTHENTICATOR_ERROR_GETAUTHTOKEN;
                }
            }
            throw new AuthenticationException(adalErrorCode, msg);
        }
        if (!StringExtensions.isNullOrBlank(oauth2ErrorCode) && request.isSilent()) {
            throw new AuthenticationException(ADALError.AUTH_REFRESH_FAILED_PROMPT_NOT_ALLOWED, "Received error from broker, errorCode: " + oauth2ErrorCode + "; ErrorDescription: " + oauth2ErrorDescription);
        }
        boolean initialRequest = bundleResult.getBoolean("account.initial.request");
        if (initialRequest) {
            return AuthenticationResult.createResultForInitialRequest();
        }
        UserInfo userinfo = UserInfo.getUserInfoFromBrokerResult(bundleResult);
        String tenantId = bundleResult.getString("account.userinfo.tenantid", "");
        if (bundleResult.getLong("account.expiredate") == 0L) {
            Logger.v(TAG, "Broker doesn't return expire date, set it current date plus one hour");
            GregorianCalendar currentTime = new GregorianCalendar();
            ((Calendar)currentTime).add(13, 3600);
            expires = currentTime.getTime();
        } else {
            expires = new Date(bundleResult.getLong("account.expiredate"));
        }
        return new AuthenticationResult(bundleResult.getString("authtoken"), "", expires, false, userinfo, tenantId, "", null);
    }

    @Override
    public void saveAccount(String accountName) {
        if (accountName == null || accountName.isEmpty()) {
            return;
        }
        SharedPreferences prefs = this.mContext.getSharedPreferences(KEY_SHARED_PREF_ACCOUNT_LIST, 0);
        String accountList = prefs.getString(KEY_APP_ACCOUNTS_FOR_TOKEN_REMOVAL, "");
        if (!accountList.contains(KEY_ACCOUNT_LIST_DELIM + accountName)) {
            accountList = accountList + KEY_ACCOUNT_LIST_DELIM + accountName;
            SharedPreferences.Editor prefsEditor = prefs.edit();
            prefsEditor.putString(KEY_APP_ACCOUNTS_FOR_TOKEN_REMOVAL, accountList);
            prefsEditor.apply();
        }
    }

    @Override
    public void removeAccounts() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (BrokerProxy.this.isBrokerAccountServiceSupported()) {
                    BrokerAccountServiceHandler.getInstance().removeAccounts(BrokerProxy.this.mContext);
                } else {
                    BrokerProxy.this.removeAccountFromAccountManager();
                }
            }
        }).start();
    }

    private void removeAccountFromAccountManager() {
        Logger.v(TAG, "removeAccounts:");
        Account[] accountList = this.mAcctManager.getAccountsByType("com.microsoft.workaccount");
        if (accountList.length != 0) {
            for (Account targetAccount : accountList) {
                Logger.v(TAG, "remove tokens for:" + targetAccount.name);
                Bundle brokerOptions = new Bundle();
                brokerOptions.putString("account.remove.tokens", "account.remove.tokens.value");
                this.mAcctManager.getAuthToken(targetAccount, "adal.authtoken.type", brokerOptions, false, null, this.mHandler);
            }
        }
    }

    @Override
    public Intent getIntentForBrokerActivity(AuthenticationRequest request) {
        Intent intent;
        Bundle requestBundle = this.getBrokerOptions(request);
        if (this.isBrokerAccountServiceSupported()) {
            intent = BrokerAccountServiceHandler.getInstance().getIntentForInteractiveRequest(this.mContext);
            intent.putExtras(requestBundle);
        } else {
            intent = this.getIntentForBrokerActivityFromAccountManager(requestBundle);
        }
        if (intent != null) {
            intent.putExtra("com.microsoft.aadbroker.adal.broker.request", "com.microsoft.aadbroker.adal.broker.request");
            if (!this.isBrokerWithPRTSupport(intent) && PromptBehavior.FORCE_PROMPT == request.getPrompt()) {
                Logger.v(TAG, "FORCE_PROMPT is set for broker auth via old version of broker app, reset to ALWAYS.");
                intent.putExtra("account.prompt", PromptBehavior.Always.name());
            }
        }
        return intent;
    }

    private Intent getIntentForBrokerActivityFromAccountManager(Bundle addAccountOptions) {
        Intent intent = null;
        try {
            AccountManagerFuture result = this.mAcctManager.addAccount("com.microsoft.workaccount", "adal.authtoken.type", null, addAccountOptions, null, null, this.mHandler);
            Bundle bundleResult = (Bundle)result.getResult();
            intent = (Intent)bundleResult.getParcelable("intent");
        }
        catch (OperationCanceledException e) {
            Logger.e(TAG, AUTHENTICATOR_CANCELS_REQUEST, "", ADALError.AUTH_FAILED_CANCELLED, e);
        }
        catch (AuthenticatorException e) {
            Logger.e(TAG, AUTHENTICATOR_CANCELS_REQUEST, "", ADALError.BROKER_AUTHENTICATOR_NOT_RESPONDING, e);
        }
        catch (IOException e) {
            Logger.e(TAG, AUTHENTICATOR_CANCELS_REQUEST, "", ADALError.BROKER_AUTHENTICATOR_IO_EXCEPTION, e);
        }
        return intent;
    }

    @Override
    public String getCurrentActiveBrokerPackageName() {
        AuthenticatorDescription[] authenticators;
        for (AuthenticatorDescription authenticator : authenticators = this.mAcctManager.getAuthenticatorTypes()) {
            if (!authenticator.type.equals("com.microsoft.workaccount")) continue;
            return authenticator.packageName;
        }
        return null;
    }

    @Override
    public String getBrokerAppVersion(String brokerAppPackageName) throws PackageManager.NameNotFoundException {
        PackageInfo packageInfo = this.mContext.getPackageManager().getPackageInfo(brokerAppPackageName, 0);
        return "VersionName=" + packageInfo.versionName + ";VersonCode=" + packageInfo.versionCode + ".";
    }

    private Bundle getBrokerOptions(AuthenticationRequest request) {
        String username;
        Bundle brokerOptions = new Bundle();
        brokerOptions.putInt("com.microsoft.aad.adal:RequestId", request.getRequestId());
        brokerOptions.putString("account.authority", request.getAuthority());
        brokerOptions.putString("account.resource", request.getResource());
        brokerOptions.putString("account.redirect", request.getRedirectUri());
        brokerOptions.putString("account.clientid.key", request.getClientId());
        brokerOptions.putString("adal.version.key", request.getVersion());
        brokerOptions.putString("account.userinfo.userid", request.getUserId());
        brokerOptions.putString("account.extra.query.param", request.getExtraQueryParamsAuthentication());
        if (request.getCorrelationId() != null) {
            brokerOptions.putString("account.correlationid", request.getCorrelationId().toString());
        }
        if (StringExtensions.isNullOrBlank(username = request.getBrokerAccountName())) {
            username = request.getLoginHint();
        }
        brokerOptions.putString("account.login.hint", username);
        brokerOptions.putString("account.name", username);
        if (request.getPrompt() != null) {
            brokerOptions.putString("account.prompt", request.getPrompt().name());
        }
        if (Utility.isClaimsChallengePresent(request)) {
            brokerOptions.putString("skip.cache", Boolean.toString(true));
            brokerOptions.putString("account.claims", request.getClaimsChallenge());
        }
        return brokerOptions;
    }

    private boolean isBrokerWithPRTSupport(Intent intent) {
        if (intent == null) {
            throw new IllegalArgumentException("intent");
        }
        String brokerVersion = intent.getStringExtra("broker.version");
        return "v2".equalsIgnoreCase(brokerVersion);
    }

    @Override
    public String getCurrentUser() {
        if (this.isBrokerAccountServiceSupported()) {
            UserInfo[] users;
            this.verifyNotOnMainThread();
            try {
                users = BrokerAccountServiceHandler.getInstance().getBrokerUsers(this.mContext);
            }
            catch (IOException e) {
                Logger.e(TAG, "No current user could be retrieved.", "", null, e);
                return null;
            }
            return users.length == 0 ? null : users[0].getDisplayableId();
        }
        Account[] accountList = this.mAcctManager.getAccountsByType("com.microsoft.workaccount");
        if (accountList.length > 0) {
            return accountList[0].name;
        }
        return null;
    }

    private boolean checkAccount(AccountManager am, String username, String uniqueId) {
        AuthenticatorDescription[] authenticators;
        for (AuthenticatorDescription authenticator : authenticators = am.getAuthenticatorTypes()) {
            if (!authenticator.type.equals("com.microsoft.workaccount")) continue;
            Account[] accountList = this.mAcctManager.getAccountsByType("com.microsoft.workaccount");
            if (!authenticator.packageName.equalsIgnoreCase("com.azure.authenticator") && !authenticator.packageName.equalsIgnoreCase("com.microsoft.windowsintune.companyportal") && !authenticator.packageName.equalsIgnoreCase(AuthenticationSettings.INSTANCE.getBrokerPackageName())) continue;
            if (this.hasSupportToAddUserThroughBroker(authenticator.packageName)) {
                return true;
            }
            if (accountList.length <= 0) continue;
            return this.verifyAccount(accountList, username, uniqueId);
        }
        return false;
    }

    private boolean verifyAccount(Account[] accountList, String username, String uniqueId) {
        if (!StringExtensions.isNullOrBlank(username)) {
            return username.equalsIgnoreCase(accountList[0].name);
        }
        if (!StringExtensions.isNullOrBlank(uniqueId)) {
            try {
                UserInfo[] users = this.getBrokerUsers();
                UserInfo matchingUser = this.findUserInfo(uniqueId, users);
                return matchingUser != null;
            }
            catch (AuthenticatorException | OperationCanceledException | IOException e) {
                Logger.e(TAG, "VerifyAccount:" + e.getMessage(), "", ADALError.BROKER_AUTHENTICATOR_EXCEPTION, e);
                Logger.v(TAG, "It could not check the uniqueid from broker. It is not using broker");
                return false;
            }
        }
        return true;
    }

    private boolean hasSupportToAddUserThroughBroker(String brokerPackageName) {
        Intent intent = new Intent();
        intent.setPackage(brokerPackageName);
        intent.setClassName(brokerPackageName, brokerPackageName + ".ui.AccountChooserActivity");
        PackageManager packageManager = this.mContext.getPackageManager();
        List infos = packageManager.queryIntentActivities(intent, 0);
        return infos.size() > 0;
    }

    private boolean verifySignature(String brokerPackageName) {
        try {
            List<X509Certificate> certs = this.readCertDataForBrokerApp(brokerPackageName);
            this.verifySignatureHash(certs);
            if (certs.size() > 1) {
                this.verifyCertificateChain(certs);
            }
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.e(TAG, "Broker related package does not exist", "", ADALError.BROKER_PACKAGE_NAME_NOT_FOUND);
        }
        catch (NoSuchAlgorithmException e) {
            Logger.e(TAG, "Digest SHA algorithm does not exists", "", ADALError.DEVICE_NO_SUCH_ALGORITHM);
        }
        catch (AuthenticationException | IOException | GeneralSecurityException e) {
            Logger.e(TAG, e.getMessage(), "", ADALError.BROKER_VERIFICATION_FAILED, e);
        }
        return false;
    }

    private void verifySignatureHash(List<X509Certificate> certs) throws NoSuchAlgorithmException, CertificateEncodingException, AuthenticationException {
        for (X509Certificate x509Certificate : certs) {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            messageDigest.update(x509Certificate.getEncoded());
            String signatureHash = Base64.encodeToString((byte[])messageDigest.digest(), (int)2);
            if (!this.mBrokerTag.equals(signatureHash) && !"ho040S3ffZkmxqtQrSwpTVOn9r0=".equals(signatureHash)) continue;
            return;
        }
        throw new AuthenticationException(ADALError.BROKER_APP_VERIFICATION_FAILED);
    }

    @SuppressLint(value={"PackageManagerGetSignatures"})
    private List<X509Certificate> readCertDataForBrokerApp(String brokerPackageName) throws PackageManager.NameNotFoundException, AuthenticationException, IOException, GeneralSecurityException {
        PackageInfo packageInfo = this.mContext.getPackageManager().getPackageInfo(brokerPackageName, 64);
        if (packageInfo == null) {
            throw new AuthenticationException(ADALError.APP_PACKAGE_NAME_NOT_FOUND, "No broker package existed.");
        }
        if (packageInfo.signatures == null || packageInfo.signatures.length == 0) {
            throw new AuthenticationException(ADALError.BROKER_APP_VERIFICATION_FAILED, "No signature associated with the broker package.");
        }
        ArrayList<X509Certificate> certificates = new ArrayList<X509Certificate>(packageInfo.signatures.length);
        for (Signature signature : packageInfo.signatures) {
            byte[] rawCert = signature.toByteArray();
            ByteArrayInputStream certStream = new ByteArrayInputStream(rawCert);
            try {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X509");
                X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(certStream);
                certificates.add(x509Certificate);
            }
            catch (CertificateException e) {
                throw new AuthenticationException(ADALError.BROKER_APP_VERIFICATION_FAILED);
            }
        }
        return certificates;
    }

    private void verifyCertificateChain(List<X509Certificate> certificates) throws GeneralSecurityException, AuthenticationException {
        X509Certificate issuerCert = this.getSelfSignedCert(certificates);
        TrustAnchor trustAnchor = new TrustAnchor(issuerCert, null);
        PKIXParameters pkixParameters = new PKIXParameters(Collections.singleton(trustAnchor));
        pkixParameters.setRevocationEnabled(false);
        CertPath certPath = CertificateFactory.getInstance("X.509").generateCertPath(certificates);
        CertPathValidator certPathValidator = CertPathValidator.getInstance("PKIX");
        certPathValidator.validate(certPath, pkixParameters);
    }

    private X509Certificate getSelfSignedCert(List<X509Certificate> certs) throws AuthenticationException {
        int count = 0;
        X509Certificate selfSignedCert = null;
        for (X509Certificate x509Certificate : certs) {
            if (!x509Certificate.getSubjectDN().equals(x509Certificate.getIssuerDN())) continue;
            selfSignedCert = x509Certificate;
            ++count;
        }
        if (count > 1 || selfSignedCert == null) {
            throw new AuthenticationException(ADALError.BROKER_APP_VERIFICATION_FAILED, "Multiple self signed certs found or no self signed cert existed.");
        }
        return selfSignedCert;
    }

    private boolean verifyAuthenticator(AccountManager am) {
        AuthenticatorDescription[] authenticators;
        for (AuthenticatorDescription authenticator : authenticators = am.getAuthenticatorTypes()) {
            if (!authenticator.type.equals("com.microsoft.workaccount") || !this.verifySignature(authenticator.packageName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public UserInfo[] getBrokerUsers() throws OperationCanceledException, AuthenticatorException, IOException {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new IllegalArgumentException("Calling getBrokerUsers on main thread");
        }
        if (this.isBrokerAccountServiceSupported()) {
            return BrokerAccountServiceHandler.getInstance().getBrokerUsers(this.mContext);
        }
        return this.getUserInfoFromAccountManager();
    }

    private UserInfo[] getUserInfoFromAccountManager() throws OperationCanceledException, AuthenticatorException, IOException {
        Account[] accountList = this.mAcctManager.getAccountsByType("com.microsoft.workaccount");
        Bundle bundle = new Bundle();
        bundle.putBoolean(DATA_USER_INFO, true);
        Logger.v(TAG, "Retrieve all the accounts from account manager with broker account type, and the account length is: " + accountList.length);
        UserInfo[] users = new UserInfo[accountList.length];
        for (int i = 0; i < accountList.length; ++i) {
            AccountManagerFuture result = this.mAcctManager.updateCredentials(accountList[i], "adal.authtoken.type", bundle, null, null, null);
            Logger.v(TAG, "Waiting for userinfo retrieval result from Broker.");
            Bundle userInfoBundle = (Bundle)result.getResult();
            users[i] = new UserInfo(userInfoBundle.getString("account.userinfo.userid"), userInfoBundle.getString("account.userinfo.given.name"), userInfoBundle.getString("account.userinfo.family.name"), userInfoBundle.getString("account.userinfo.identity.provider"), userInfoBundle.getString("account.userinfo.userid.displayable"));
        }
        return users;
    }

    static enum SwitchToBroker {
        CAN_SWITCH_TO_BROKER,
        CANNOT_SWITCH_TO_BROKER,
        NEED_PERMISSIONS_TO_SWITCH_TO_BROKER;

    }
}

