/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import com.microsoft.aad.adal.TokenCacheItem;
import com.microsoft.aad.adal.UserInfo;
import com.microsoft.aad.adal.Utility;
import java.io.Serializable;
import java.util.Date;

public class AuthenticationResult
implements Serializable {
    private static final long serialVersionUID = 2243372613182536368L;
    private String mCode;
    private String mAccessToken;
    private String mRefreshToken;
    private String mTokenType;
    private Date mExpiresOn;
    private String mErrorCode;
    private String mErrorDescription;
    private String mErrorCodes;
    private boolean mIsMultiResourceRefreshToken;
    private UserInfo mUserInfo;
    private String mTenantId;
    private String mIdToken;
    private AuthenticationStatus mStatus = AuthenticationStatus.Failed;
    private boolean mInitialRequest;
    private String mFamilyClientId;
    private boolean mIsExtendedLifeTimeToken = false;
    private Date mExtendedExpiresOn;

    AuthenticationResult() {
        this.mCode = null;
    }

    AuthenticationResult(String code) {
        this.mCode = code;
        this.mStatus = AuthenticationStatus.Succeeded;
        this.mAccessToken = null;
        this.mRefreshToken = null;
    }

    AuthenticationResult(String accessToken, String refreshToken, Date expires, boolean isBroad, UserInfo userInfo, String tenantId, String idToken, Date extendedExpires) {
        this.mCode = null;
        this.mAccessToken = accessToken;
        this.mRefreshToken = refreshToken;
        this.mExpiresOn = expires;
        this.mIsMultiResourceRefreshToken = isBroad;
        this.mStatus = AuthenticationStatus.Succeeded;
        this.mUserInfo = userInfo;
        this.mTenantId = tenantId;
        this.mIdToken = idToken;
        this.mExtendedExpiresOn = extendedExpires;
    }

    AuthenticationResult(String accessToken, String refreshToken, Date expires, boolean isBroad, Date extendedExpires) {
        this.mCode = null;
        this.mAccessToken = accessToken;
        this.mRefreshToken = refreshToken;
        this.mExpiresOn = expires;
        this.mIsMultiResourceRefreshToken = isBroad;
        this.mStatus = AuthenticationStatus.Succeeded;
        this.mExtendedExpiresOn = extendedExpires;
    }

    AuthenticationResult(String errorCode, String errDescription, String errorCodes) {
        this.mErrorCode = errorCode;
        this.mErrorDescription = errDescription;
        this.mErrorCodes = errorCodes;
        this.mStatus = AuthenticationStatus.Failed;
    }

    static AuthenticationResult createResult(TokenCacheItem cacheItem) {
        if (cacheItem == null) {
            AuthenticationResult result = new AuthenticationResult();
            result.mStatus = AuthenticationStatus.Failed;
            return result;
        }
        AuthenticationResult result = new AuthenticationResult(cacheItem.getAccessToken(), cacheItem.getRefreshToken(), cacheItem.getExpiresOn(), cacheItem.getIsMultiResourceRefreshToken(), cacheItem.getUserInfo(), cacheItem.getTenantId(), cacheItem.getRawIdToken(), cacheItem.getExtendedExpiresOn());
        return result;
    }

    static AuthenticationResult createResultForInitialRequest() {
        AuthenticationResult result = new AuthenticationResult();
        result.mInitialRequest = true;
        return result;
    }

    static AuthenticationResult createExtendedLifeTimeResult(TokenCacheItem accessTokenItem) {
        AuthenticationResult retryResult = AuthenticationResult.createResult(accessTokenItem);
        retryResult.setExpiresOn(retryResult.getExtendedExpiresOn());
        retryResult.setIsExtendedLifeTimeToken(true);
        return retryResult;
    }

    public String createAuthorizationHeader() {
        return "Bearer " + this.getAccessToken();
    }

    public String getAccessToken() {
        return this.mAccessToken;
    }

    public String getRefreshToken() {
        return this.mRefreshToken;
    }

    public String getAccessTokenType() {
        return this.mTokenType;
    }

    public Date getExpiresOn() {
        return Utility.getImmutableDateObject(this.mExpiresOn);
    }

    public boolean getIsMultiResourceRefreshToken() {
        return this.mIsMultiResourceRefreshToken;
    }

    public UserInfo getUserInfo() {
        return this.mUserInfo;
    }

    void setUserInfo(UserInfo userinfo) {
        this.mUserInfo = userinfo;
    }

    public String getTenantId() {
        return this.mTenantId;
    }

    public AuthenticationStatus getStatus() {
        return this.mStatus;
    }

    String getCode() {
        return this.mCode;
    }

    void setCode(String code) {
        this.mCode = code;
    }

    public String getErrorCode() {
        return this.mErrorCode;
    }

    public String getErrorDescription() {
        return this.mErrorDescription;
    }

    public String getErrorLogInfo() {
        return " ErrorCode:" + this.getErrorCode() + " ErrorDescription:" + this.getErrorDescription();
    }

    public boolean isExpired() {
        if (this.mIsExtendedLifeTimeToken) {
            return TokenCacheItem.isTokenExpired(this.getExtendedExpiresOn());
        }
        return TokenCacheItem.isTokenExpired(this.getExpiresOn());
    }

    String[] getErrorCodes() {
        return this.mErrorCodes != null ? this.mErrorCodes.replaceAll("[\\[\\]]", "").split("([^,]),") : null;
    }

    boolean isInitialRequest() {
        return this.mInitialRequest;
    }

    public String getIdToken() {
        return this.mIdToken;
    }

    public boolean isExtendedLifeTimeToken() {
        return this.mIsExtendedLifeTimeToken;
    }

    final void setIsExtendedLifeTimeToken(boolean isExtendedLifeTimeToken) {
        this.mIsExtendedLifeTimeToken = isExtendedLifeTimeToken;
    }

    final void setExtendedExpiresOn(Date extendedExpiresOn) {
        this.mExtendedExpiresOn = extendedExpiresOn;
    }

    final Date getExtendedExpiresOn() {
        return this.mExtendedExpiresOn;
    }

    final void setExpiresOn(Date expiresOn) {
        this.mExpiresOn = expiresOn;
    }

    void setIdToken(String idToken) {
        this.mIdToken = idToken;
    }

    void setTenantId(String tenantid) {
        this.mTenantId = tenantid;
    }

    void setRefreshToken(String refreshToken) {
        this.mRefreshToken = refreshToken;
    }

    final String getFamilyClientId() {
        return this.mFamilyClientId;
    }

    final void setFamilyClientId(String familyClientId) {
        this.mFamilyClientId = familyClientId;
    }

    public static enum AuthenticationStatus {
        Cancelled,
        Failed,
        Succeeded;

    }
}

