/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.content.Context;
import android.os.Handler;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.HttpWebResponse;
import com.microsoft.aad.adal.IWebRequestHandler;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.ResourceAuthenticationChallengeException;
import com.microsoft.aad.adal.StringExtensions;
import com.microsoft.aad.adal.WebRequestHandler;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AuthenticationParameters {
    public static final String AUTH_HEADER_MISSING_AUTHORITY = "WWW-Authenticate header is missing authorization_uri.";
    public static final String AUTH_HEADER_INVALID_FORMAT = "Invalid authentication header format";
    public static final String AUTH_HEADER_MISSING = "WWW-Authenticate header was expected in the response";
    public static final String AUTH_HEADER_WRONG_STATUS = "Unauthorized http response (status code 401) was expected";
    public static final String AUTHENTICATE_HEADER = "WWW-Authenticate";
    public static final String BEARER = "bearer";
    public static final String AUTHORITY_KEY = "authorization_uri";
    public static final String RESOURCE_KEY = "resource_id";
    private static final String TAG = "AuthenticationParameters";
    private static final String REGEX = "^Bearer\\s+([^,\\s=\"]+?)=\"([^\"]*?)\"\\s*(?:,\\s*([^,\\s=\"]+?)=\"([^\"]*?)\"\\s*)*$";
    private static final String REGEX_VALUES = "\\s*([^,\\s=\"]+?)=\"([^\"]*?)\"";
    private String mAuthority;
    private String mResource;
    private static IWebRequestHandler sWebRequest = new WebRequestHandler();
    private static ExecutorService sThreadExecutor = Executors.newSingleThreadExecutor();

    public String getAuthority() {
        return this.mAuthority;
    }

    public String getResource() {
        return this.mResource;
    }

    public AuthenticationParameters() {
    }

    AuthenticationParameters(String authority, String resource) {
        this.mAuthority = authority;
        this.mResource = resource;
    }

    public static void createFromResourceUrl(Context context, final URL resourceUrl, final AuthenticationParamCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback");
        }
        Logger.v(TAG, "createFromResourceUrl");
        final Handler handler = new Handler(context.getMainLooper());
        sThreadExecutor.submit(new Runnable(){

            @Override
            public void run() {
                HashMap<String, String> headers = new HashMap<String, String>();
                headers.put("Accept", "application/json");
                try {
                    HttpWebResponse webResponse = sWebRequest.sendGet(resourceUrl, headers);
                    try {
                        this.onCompleted(null, AuthenticationParameters.parseResponse(webResponse));
                    }
                    catch (ResourceAuthenticationChallengeException exc) {
                        this.onCompleted(exc, null);
                    }
                }
                catch (IOException e) {
                    this.onCompleted(e, null);
                }
            }

            void onCompleted(final Exception exception, final AuthenticationParameters param) {
                handler.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onCompleted(exception, param);
                    }
                });
            }
        });
    }

    public static AuthenticationParameters createFromResponseAuthenticateHeader(String authenticateHeader) throws ResourceAuthenticationChallengeException {
        String authority;
        HashMap<String, String> headerItems;
        if (StringExtensions.isNullOrBlank(authenticateHeader)) {
            throw new ResourceAuthenticationChallengeException(AUTH_HEADER_MISSING);
        }
        Pattern p = Pattern.compile(REGEX);
        Matcher m = p.matcher(authenticateHeader);
        if (m.matches()) {
            Pattern valuePattern = Pattern.compile(REGEX_VALUES);
            String headerSubFields = authenticateHeader.substring(BEARER.length());
            Logger.v(TAG, "Values in here:" + headerSubFields);
            Matcher values = valuePattern.matcher(headerSubFields);
            headerItems = new HashMap<String, String>();
            while (values.find()) {
                if (!StringExtensions.isNullOrBlank(values.group(1)) && !StringExtensions.isNullOrBlank(values.group(2))) {
                    String key = values.group(1);
                    String value = values.group(2);
                    try {
                        key = StringExtensions.urlFormDecode(key);
                        value = StringExtensions.urlFormDecode(value);
                    }
                    catch (UnsupportedEncodingException e) {
                        Logger.v(TAG, e.getMessage());
                    }
                    key = key.trim();
                    value = StringExtensions.removeQuoteInHeaderValue(value.trim());
                    if (headerItems.containsKey(key)) {
                        Logger.w(TAG, String.format("Key/value pair list contains redundant key '%s'.", key), "", ADALError.DEVELOPER_BEARER_HEADER_MULTIPLE_ITEMS);
                    }
                    headerItems.put(key, value);
                    continue;
                }
                throw new ResourceAuthenticationChallengeException(AUTH_HEADER_INVALID_FORMAT);
            }
            authority = (String)headerItems.get(AUTHORITY_KEY);
            if (StringExtensions.isNullOrBlank(authority)) {
                throw new ResourceAuthenticationChallengeException(AUTH_HEADER_MISSING_AUTHORITY);
            }
        } else {
            throw new ResourceAuthenticationChallengeException(AUTH_HEADER_INVALID_FORMAT);
        }
        AuthenticationParameters authParams = new AuthenticationParameters(StringExtensions.removeQuoteInHeaderValue(authority), StringExtensions.removeQuoteInHeaderValue((String)headerItems.get(RESOURCE_KEY)));
        return authParams;
    }

    private static AuthenticationParameters parseResponse(HttpWebResponse webResponse) throws ResourceAuthenticationChallengeException {
        if (webResponse.getStatusCode() == 401) {
            List<String> headers;
            Map<String, List<String>> responseHeaders = webResponse.getResponseHeaders();
            if (responseHeaders != null && responseHeaders.containsKey(AUTHENTICATE_HEADER) && (headers = responseHeaders.get(AUTHENTICATE_HEADER)) != null && headers.size() > 0) {
                return AuthenticationParameters.createFromResponseAuthenticateHeader(headers.get(0));
            }
            throw new ResourceAuthenticationChallengeException(AUTH_HEADER_MISSING);
        }
        throw new ResourceAuthenticationChallengeException(AUTH_HEADER_WRONG_STATUS);
    }

    public static interface AuthenticationParamCallback {
        public void onCompleted(Exception var1, AuthenticationParameters var2);
    }
}

