/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.accounts.AccountManagerFuture;
import android.accounts.AuthenticatorDescription;
import android.accounts.AuthenticatorException;
import android.accounts.OperationCanceledException;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.pm.Signature;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.util.Base64;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.AuthenticationRequest;
import com.microsoft.aad.adal.AuthenticationResult;
import com.microsoft.aad.adal.AuthenticationSettings;
import com.microsoft.aad.adal.IBrokerProxy;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.StringExtensions;
import com.microsoft.aad.adal.UserInfo;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.List;

@TargetApi(value=14)
class BrokerProxy
implements IBrokerProxy {
    private static final String TAG = "BrokerProxy";
    private Context mContext;
    private AccountManager mAcctManager;
    private Handler mHandler;
    private final String mBrokerTag;
    private static final String KEY_ACCOUNT_LIST_DELIM = "|";
    private static final String KEY_SHARED_PREF_ACCOUNT_LIST = "com.microsoft.aad.adal.account.list";
    private static final String KEY_APP_ACCOUNTS_FOR_TOKEN_REMOVAL = "AppAccountsForTokenRemoval";
    public static final String DATA_USER_INFO = "com.microsoft.workaccount.user.info";
    private static final int ACCOUNT_MANAGER_ERROR_CODE_BAD_AUTHENTICATION = 9;

    public BrokerProxy() {
        this.mBrokerTag = AuthenticationSettings.INSTANCE.getBrokerSignature();
    }

    public BrokerProxy(Context ctx) {
        this.mContext = ctx;
        this.mAcctManager = AccountManager.get((Context)this.mContext);
        this.mHandler = new Handler(this.mContext.getMainLooper());
        this.mBrokerTag = AuthenticationSettings.INSTANCE.getBrokerSignature();
    }

    @Override
    public boolean canSwitchToBroker() {
        String packageName = this.mContext.getPackageName();
        return !AuthenticationSettings.INSTANCE.getSkipBroker() && this.verifyManifestPermissions() && this.checkAccount(this.mAcctManager) && !packageName.equalsIgnoreCase(AuthenticationSettings.INSTANCE.getBrokerPackageName()) && !packageName.equalsIgnoreCase("com.azure.authenticator") && this.verifyAuthenticator(this.mAcctManager);
    }

    @Override
    public boolean canUseLocalCache() {
        boolean brokerSwitch = this.canSwitchToBroker();
        if (!brokerSwitch) {
            Logger.v(TAG, "It does not use broker");
            return true;
        }
        String packageName = this.mContext.getPackageName();
        if (this.verifySignature(packageName)) {
            Logger.v(TAG, "Broker installer can use local cache");
            return true;
        }
        return false;
    }

    private boolean verifyManifestPermissions() {
        boolean permission;
        PackageManager pm = this.mContext.getPackageManager();
        boolean bl = permission = 0 == pm.checkPermission("android.permission.GET_ACCOUNTS", this.mContext.getPackageName()) && 0 == pm.checkPermission("android.permission.MANAGE_ACCOUNTS", this.mContext.getPackageName()) && 0 == pm.checkPermission("android.permission.USE_CREDENTIALS", this.mContext.getPackageName());
        if (!permission) {
            Logger.w(TAG, "Broker related permissions are missing for GET_ACCOUNTS, MANAGE_ACCOUNTS, USE_CREDENTIALS", "", ADALError.DEVELOPER_BROKER_PERMISSIONS_MISSING);
        }
        return permission;
    }

    private void verifyNotOnMainThread() {
        Looper looper = Looper.myLooper();
        if (looper != null && looper == this.mContext.getMainLooper()) {
            IllegalStateException exception = new IllegalStateException("calling this from your main thread can lead to deadlock");
            Logger.e(TAG, "calling this from your main thread can lead to deadlock and/or ANRs", "", ADALError.DEVELOPER_CALLING_ON_MAIN_THREAD, exception);
            if (this.mContext.getApplicationInfo().targetSdkVersion >= 8) {
                throw exception;
            }
        }
    }

    private Account findAccount(String accountName, Account[] accountList) {
        if (accountList != null) {
            for (Account account : accountList) {
                if (account == null || account.name == null || !account.name.equalsIgnoreCase(accountName)) continue;
                return account;
            }
        }
        return null;
    }

    private UserInfo findUserInfo(String userid, UserInfo[] userList) {
        if (userList != null) {
            for (UserInfo user : userList) {
                if (user == null || TextUtils.isEmpty((CharSequence)user.getUserId()) || !user.getUserId().equalsIgnoreCase(userid)) continue;
                return user;
            }
        }
        return null;
    }

    @Override
    public AuthenticationResult getAuthTokenInBackground(AuthenticationRequest request) {
        AuthenticationResult authResult = null;
        this.verifyNotOnMainThread();
        Account targetAccount = null;
        Account[] accountList = this.mAcctManager.getAccountsByType("com.microsoft.workaccount");
        if (!TextUtils.isEmpty((CharSequence)request.getBrokerAccountName())) {
            targetAccount = this.findAccount(request.getBrokerAccountName(), accountList);
        } else {
            try {
                UserInfo[] users = this.getBrokerUsers();
                UserInfo matchingUser = this.findUserInfo(request.getUserId(), users);
                if (matchingUser != null) {
                    targetAccount = this.findAccount(matchingUser.getDisplayableId(), accountList);
                }
            }
            catch (Exception e) {
                Logger.e(TAG, e.getMessage(), "", ADALError.BROKER_AUTHENTICATOR_IO_EXCEPTION, e);
            }
        }
        if (targetAccount != null) {
            Bundle brokerOptions = this.getBrokerOptions(request);
            AccountManagerFuture result = null;
            try {
                result = this.mAcctManager.getAuthToken(targetAccount, "adal.authtoken.type", brokerOptions, false, null, this.mHandler);
                Logger.v(TAG, "Received result from Authenticator");
                Bundle bundleResult = (Bundle)result.getResult();
                authResult = this.getResultFromBrokerResponse(bundleResult);
            }
            catch (OperationCanceledException e) {
                Logger.e(TAG, "Authenticator cancels the request", "", ADALError.AUTH_FAILED_CANCELLED, e);
            }
            catch (AuthenticatorException e) {
                Logger.e(TAG, "Authenticator cancels the request", "", ADALError.BROKER_AUTHENTICATOR_NOT_RESPONDING);
            }
            catch (IOException e) {
                Logger.e(TAG, "Authenticator cancels the request", "", ADALError.BROKER_AUTHENTICATOR_IO_EXCEPTION);
            }
            Logger.v(TAG, "Returning result from Authenticator");
            return authResult;
        }
        Logger.v(TAG, "Target account is not found");
        return null;
    }

    private AuthenticationResult getResultFromBrokerResponse(Bundle bundleResult) {
        if (bundleResult == null) {
            throw new IllegalArgumentException("bundleResult");
        }
        int errCode = bundleResult.getInt("errorCode");
        String msg = bundleResult.getString("errorMessage");
        if (!StringExtensions.IsNullOrBlank(msg)) {
            ADALError adalErrorCode = ADALError.BROKER_AUTHENTICATOR_ERROR_GETAUTHTOKEN;
            switch (errCode) {
                case 7: {
                    adalErrorCode = ADALError.BROKER_AUTHENTICATOR_BAD_ARGUMENTS;
                    break;
                }
                case 9: {
                    adalErrorCode = ADALError.BROKER_AUTHENTICATOR_BAD_AUTHENTICATION;
                    break;
                }
                case 6: {
                    adalErrorCode = ADALError.BROKER_AUTHENTICATOR_UNSUPPORTED_OPERATION;
                }
            }
            throw new AuthenticationException(adalErrorCode, msg);
        }
        boolean initialRequest = bundleResult.getBoolean("account.initial.request");
        if (initialRequest) {
            return AuthenticationResult.createResultForInitialRequest();
        }
        UserInfo userinfo = UserInfo.getUserInfoFromBrokerResult(bundleResult);
        AuthenticationResult result = new AuthenticationResult(bundleResult.getString("authtoken"), "", null, false, userinfo, "", "");
        return result;
    }

    @Override
    public void saveAccount(String accountName) {
        if (accountName == null || accountName.isEmpty()) {
            return;
        }
        SharedPreferences prefs = this.mContext.getSharedPreferences(KEY_SHARED_PREF_ACCOUNT_LIST, 0);
        String accountList = prefs.getString(KEY_APP_ACCOUNTS_FOR_TOKEN_REMOVAL, "");
        if (!accountList.contains(KEY_ACCOUNT_LIST_DELIM + accountName)) {
            accountList = accountList + KEY_ACCOUNT_LIST_DELIM + accountName;
            SharedPreferences.Editor prefsEditor = prefs.edit();
            prefsEditor.putString(KEY_APP_ACCOUNTS_FOR_TOKEN_REMOVAL, accountList);
            prefsEditor.apply();
        }
    }

    @Override
    public void removeAccounts() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                Logger.v(BrokerProxy.TAG, "removeAccounts:");
                Account[] accountList = BrokerProxy.this.mAcctManager.getAccountsByType("com.microsoft.workaccount");
                if (accountList != null) {
                    for (Account targetAccount : accountList) {
                        Logger.v(BrokerProxy.TAG, "remove tokens for:" + targetAccount.name);
                        if (targetAccount == null) continue;
                        Bundle brokerOptions = new Bundle();
                        brokerOptions.putString("account.remove.tokens", "account.remove.tokens.value");
                        BrokerProxy.this.mAcctManager.getAuthToken(targetAccount, "adal.authtoken.type", brokerOptions, false, null, BrokerProxy.this.mHandler);
                    }
                }
            }
        }).start();
    }

    @Override
    public Intent getIntentForBrokerActivity(AuthenticationRequest request) {
        Intent intent = null;
        AccountManagerFuture result = null;
        try {
            Bundle addAccountOptions = this.getBrokerOptions(request);
            result = this.mAcctManager.addAccount("com.microsoft.workaccount", "adal.authtoken.type", null, addAccountOptions, null, null, this.mHandler);
            Bundle bundleResult = (Bundle)result.getResult();
            intent = (Intent)bundleResult.getParcelable("intent");
            if (intent != null) {
                intent.putExtra("com.microsoft.aadbroker.adal.broker.request", "com.microsoft.aadbroker.adal.broker.request");
            }
        }
        catch (OperationCanceledException e) {
            Logger.e(TAG, "Authenticator cancels the request", "", ADALError.AUTH_FAILED_CANCELLED, e);
        }
        catch (AuthenticatorException e) {
            Logger.e(TAG, "Authenticator cancels the request", "", ADALError.BROKER_AUTHENTICATOR_NOT_RESPONDING);
        }
        catch (IOException e) {
            Logger.e(TAG, "Authenticator cancels the request", "", ADALError.BROKER_AUTHENTICATOR_IO_EXCEPTION);
        }
        return intent;
    }

    private Bundle getBrokerOptions(AuthenticationRequest request) {
        String username;
        Bundle brokerOptions = new Bundle();
        brokerOptions.putInt("com.microsoft.aad.adal:RequestId", request.getRequestId());
        brokerOptions.putString("account.authority", request.getAuthority());
        brokerOptions.putString("account.resource", request.getResource());
        brokerOptions.putString("account.redirect", request.getRedirectUri());
        brokerOptions.putString("account.clientid.key", request.getClientId());
        brokerOptions.putString("adal.version.key", request.getVersion());
        brokerOptions.putString("account.extra.query.param", request.getExtraQueryParamsAuthentication());
        if (request.getCorrelationId() != null) {
            brokerOptions.putString("account.correlationid", request.getCorrelationId().toString());
        }
        if (StringExtensions.IsNullOrBlank(username = request.getBrokerAccountName())) {
            username = request.getLoginHint();
        }
        brokerOptions.putString("account.login.hint", username);
        brokerOptions.putString("account.name", username);
        if (request.getPrompt() != null) {
            brokerOptions.putString("account.prompt", request.getPrompt().name());
        }
        return brokerOptions;
    }

    @Override
    public String getCurrentUser() {
        Account[] accountList = this.mAcctManager.getAccountsByType("com.microsoft.workaccount");
        if (accountList != null && accountList.length > 0) {
            return accountList[0].name;
        }
        return null;
    }

    private boolean checkAccount(AccountManager am) {
        AuthenticatorDescription[] authenticators;
        for (AuthenticatorDescription authenticator : authenticators = am.getAuthenticatorTypes()) {
            if (!authenticator.type.equals("com.microsoft.workaccount")) continue;
            Account[] accountList = this.mAcctManager.getAccountsByType("com.microsoft.workaccount");
            if (authenticator.packageName.equalsIgnoreCase("com.microsoft.windowsintune.companyportal")) {
                return accountList != null && accountList.length > 0;
            }
            if (!authenticator.packageName.equalsIgnoreCase("com.azure.authenticator") && !authenticator.packageName.equalsIgnoreCase(AuthenticationSettings.INSTANCE.getBrokerPackageName())) continue;
            if (this.hasSupportToAddUserThroughBroker()) {
                Logger.v(TAG, "Broker supports to add user through app");
                return true;
            }
            return accountList != null && accountList.length > 0;
        }
        return false;
    }

    private boolean hasSupportToAddUserThroughBroker() {
        Intent intent = new Intent();
        intent.setPackage("com.azure.authenticator");
        intent.setClassName("com.azure.authenticator", "com.azure.authenticator.ui.AccountChooserActivity");
        PackageManager packageManager = this.mContext.getPackageManager();
        List infos = packageManager.queryIntentActivities(intent, 0);
        return infos.size() > 0;
    }

    private boolean verifySignature(String brokerPackageName) {
        try {
            PackageInfo info = this.mContext.getPackageManager().getPackageInfo(brokerPackageName, 64);
            if (info != null && info.signatures != null) {
                for (Signature signature : info.signatures) {
                    MessageDigest md = MessageDigest.getInstance("SHA");
                    md.update(signature.toByteArray());
                    String tag = Base64.encodeToString((byte[])md.digest(), (int)2);
                    if (!tag.equals(this.mBrokerTag) && !tag.equals("ho040S3ffZkmxqtQrSwpTVOn9r0=")) continue;
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException e) {
            Logger.e(TAG, "Broker related package does not exist", "", ADALError.BROKER_PACKAGE_NAME_NOT_FOUND);
        }
        catch (NoSuchAlgorithmException e) {
            Logger.e(TAG, "Digest SHA algorithm does not exists", "", ADALError.DEVICE_NO_SUCH_ALGORITHM);
        }
        catch (Exception e) {
            Logger.e(TAG, "Error in verifying signature", "", ADALError.BROKER_VERIFICATION_FAILED, e);
        }
        return false;
    }

    private boolean verifyAuthenticator(AccountManager am) {
        AuthenticatorDescription[] authenticators;
        for (AuthenticatorDescription authenticator : authenticators = am.getAuthenticatorTypes()) {
            if (!authenticator.type.equals("com.microsoft.workaccount") || !this.verifySignature(authenticator.packageName)) continue;
            return true;
        }
        return false;
    }

    @Override
    public UserInfo[] getBrokerUsers() throws OperationCanceledException, AuthenticatorException, IOException {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            throw new IllegalArgumentException("Calling getBrokerUsers on main thread");
        }
        Account[] accountList = this.mAcctManager.getAccountsByType("com.microsoft.workaccount");
        Bundle bundle = new Bundle();
        bundle.putBoolean(DATA_USER_INFO, true);
        if (accountList != null) {
            UserInfo[] users = new UserInfo[accountList.length];
            for (int i = 0; i < accountList.length; ++i) {
                AccountManagerFuture result = this.mAcctManager.updateCredentials(accountList[i], "adal.authtoken.type", bundle, null, null, null);
                Logger.v(TAG, "Waiting for the result");
                Bundle userInfoBundle = (Bundle)result.getResult();
                users[i] = new UserInfo(userInfoBundle.getString("account.userinfo.userid"), userInfoBundle.getString("account.userinfo.given.name"), userInfoBundle.getString("account.userinfo.family.name"), userInfoBundle.getString("account.userinfo.identity.provider"), userInfoBundle.getString("account.userinfo.userid.displayable"));
            }
            return users;
        }
        return null;
    }
}

