/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.net.Uri;
import android.os.Bundle;
import com.microsoft.aad.adal.IdToken;
import com.microsoft.aad.adal.StringExtensions;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class UserInfo
implements Serializable {
    private static final long serialVersionUID = 8790127561636702672L;
    private String mUniqueId;
    private String mDisplayableId;
    private String mGivenName;
    private String mFamilyName;
    private String mIdentityProvider;
    private transient Uri mPasswordChangeUrl;
    private transient Date mPasswordExpiresOn;

    public UserInfo() {
    }

    public UserInfo(String upn) {
        this.mDisplayableId = upn;
    }

    public UserInfo(String userid, String givenName, String familyName, String identityProvider, String displayableId) {
        this.mUniqueId = userid;
        this.mGivenName = givenName;
        this.mFamilyName = familyName;
        this.mIdentityProvider = identityProvider;
        this.mDisplayableId = displayableId;
    }

    public UserInfo(IdToken token) {
        this.mUniqueId = null;
        this.mDisplayableId = null;
        if (!StringExtensions.IsNullOrBlank(token.mObjectId)) {
            this.mUniqueId = token.mObjectId;
        } else if (!StringExtensions.IsNullOrBlank(token.mSubject)) {
            this.mUniqueId = token.mSubject;
        }
        if (!StringExtensions.IsNullOrBlank(token.mUpn)) {
            this.mDisplayableId = token.mUpn;
        } else if (!StringExtensions.IsNullOrBlank(token.mEmail)) {
            this.mDisplayableId = token.mEmail;
        }
        this.mGivenName = token.mGivenName;
        this.mFamilyName = token.mFamilyName;
        this.mIdentityProvider = token.mIdentityProvider;
        if (token.mPasswordExpiration > 0L) {
            GregorianCalendar expires = new GregorianCalendar();
            ((Calendar)expires).add(13, (int)token.mPasswordExpiration);
            this.mPasswordExpiresOn = expires.getTime();
        }
        this.mPasswordChangeUrl = null;
        if (!StringExtensions.IsNullOrBlank(token.mPasswordChangeUrl)) {
            this.mPasswordChangeUrl = Uri.parse((String)token.mPasswordChangeUrl);
        }
    }

    static UserInfo getUserInfoFromBrokerResult(Bundle bundle) {
        String userid = bundle.getString("account.userinfo.userid");
        String givenName = bundle.getString("account.userinfo.given.name");
        String familyName = bundle.getString("account.userinfo.family.name");
        String identityProvider = bundle.getString("account.userinfo.identity.provider");
        String displayableId = bundle.getString("account.userinfo.userid.displayable");
        return new UserInfo(userid, givenName, familyName, identityProvider, displayableId);
    }

    public String getUserId() {
        return this.mUniqueId;
    }

    void setUserId(String userid) {
        this.mUniqueId = userid;
    }

    public String getGivenName() {
        return this.mGivenName;
    }

    void setGivenName(String name) {
        this.mGivenName = name;
    }

    public String getFamilyName() {
        return this.mFamilyName;
    }

    void setFamilyName(String familyName) {
        this.mFamilyName = familyName;
    }

    public String getIdentityProvider() {
        return this.mIdentityProvider;
    }

    void setIdentityProvider(String provider) {
        this.mIdentityProvider = provider;
    }

    public String getDisplayableId() {
        return this.mDisplayableId;
    }

    void setDisplayableId(String displayId) {
        this.mDisplayableId = displayId;
    }

    public Uri getPasswordChangeUrl() {
        return this.mPasswordChangeUrl;
    }

    void setPasswordChangeUrl(Uri passwordChangeUrl) {
        this.mPasswordChangeUrl = passwordChangeUrl;
    }

    public Date getPasswordExpiresOn() {
        return this.mPasswordExpiresOn;
    }

    void setPasswordExpiresOn(Date passwordExpiresOn) {
        this.mPasswordExpiresOn = passwordExpiresOn;
    }
}

