/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.os.Build;
import android.os.Process;
import com.microsoft.aad.adal.AuthenticationContext;
import com.microsoft.aad.adal.HttpWebRequest;
import com.microsoft.aad.adal.HttpWebResponse;
import com.microsoft.aad.adal.IWebRequestHandler;
import com.microsoft.aad.adal.Logger;
import java.net.URL;
import java.util.HashMap;
import java.util.UUID;

public class WebRequestHandler
implements IWebRequestHandler {
    private static final String TAG = "WebRequestHandler";
    public static final String HEADER_ACCEPT = "Accept";
    public static final String HEADER_ACCEPT_JSON = "application/json";
    private UUID mRequestCorrelationId = null;

    @Override
    public HttpWebResponse sendGet(URL url, HashMap<String, String> headers) {
        Logger.v(TAG, "WebRequestHandler thread" + Process.myTid());
        HttpWebRequest request = new HttpWebRequest(url);
        request.setRequestMethod("GET");
        headers = this.updateHeaders(headers);
        this.addHeadersToRequest(headers, request);
        return request.send();
    }

    @Override
    public HttpWebResponse sendPost(URL url, HashMap<String, String> headers, byte[] content, String contentType) {
        Logger.v(TAG, "WebRequestHandler thread" + Process.myTid());
        HttpWebRequest request = new HttpWebRequest(url);
        request.setRequestMethod("POST");
        request.setRequestContentType(contentType);
        request.setRequestContent(content);
        headers = this.updateHeaders(headers);
        this.addHeadersToRequest(headers, request);
        return request.send();
    }

    private void addHeadersToRequest(HashMap<String, String> headers, HttpWebRequest request) {
        if (headers != null && !headers.isEmpty()) {
            request.getRequestHeaders().putAll(headers);
        }
    }

    private HashMap<String, String> updateHeaders(HashMap<String, String> headers) {
        if (headers == null) {
            headers = new HashMap();
        }
        if (this.mRequestCorrelationId != null) {
            headers.put("client-request-id", this.mRequestCorrelationId.toString());
        }
        headers.put("x-client-SKU", "Android");
        headers.put("x-client-Ver", AuthenticationContext.getVersionName());
        headers.put("x-client-OS", "" + Build.VERSION.SDK_INT);
        headers.put("x-client-DM", Build.MODEL);
        return headers;
    }

    @Override
    public void setRequestCorrelationId(UUID requestCorrelationId) {
        this.mRequestCorrelationId = requestCorrelationId;
    }
}

