/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.AuthenticationServerProtocolException;
import com.microsoft.aad.adal.AuthenticationSettings;
import com.microsoft.aad.adal.IDeviceCertificate;
import com.microsoft.aad.adal.IJWSBuilder;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.StringExtensions;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

class ChallengeResponseBuilder {
    private static final String TAG = "ChallengeResponseBuilder";
    private IJWSBuilder mJWSBuilder;

    ChallengeResponseBuilder(IJWSBuilder jwsBuilder) {
        this.mJWSBuilder = jwsBuilder;
    }

    public ChallengeResponse getChallengeResponseFromUri(String redirectUri) throws AuthenticationServerProtocolException, AuthenticationException {
        ChallengeRequest request = this.getChallengeRequest(redirectUri);
        return this.getDeviceCertResponse(request);
    }

    public ChallengeResponse getChallengeResponseFromHeader(String challengeHeaderValue, String endpoint) throws UnsupportedEncodingException, AuthenticationServerProtocolException, AuthenticationException {
        ChallengeRequest request = this.getChallengeRequestFromHeader(challengeHeaderValue);
        request.mSubmitUrl = endpoint;
        return this.getDeviceCertResponse(request);
    }

    private ChallengeResponse getDeviceCertResponse(ChallengeRequest request) throws AuthenticationException {
        IDeviceCertificate deviceCertProxy;
        ChallengeResponse response = this.getNoDeviceCertResponse(request);
        response.mSubmitUrl = request.mSubmitUrl;
        Class<IDeviceCertificate> certClazz = AuthenticationSettings.INSTANCE.getDeviceCertificateProxy();
        if (certClazz != null && ((deviceCertProxy = this.getWPJAPIInstance(certClazz)).isValidIssuer(request.mCertAuthorities) || deviceCertProxy.getThumbPrint() != null && deviceCertProxy.getThumbPrint().equalsIgnoreCase(request.mThumbprint))) {
            RSAPrivateKey privateKey = deviceCertProxy.getRSAPrivateKey();
            if (privateKey != null) {
                String jwt = this.mJWSBuilder.generateSignedJWT(request.mNonce, request.mSubmitUrl, privateKey, deviceCertProxy.getRSAPublicKey(), deviceCertProxy.getCertificate());
                response.mAuthorizationHeaderValue = String.format("%s AuthToken=\"%s\",Context=\"%s\",Version=\"%s\"", "PKeyAuth", jwt, request.mContext, request.mVersion);
                Logger.v(TAG, "Challenge response:" + response.mAuthorizationHeaderValue);
            } else {
                throw new AuthenticationException(ADALError.KEY_CHAIN_PRIVATE_KEY_EXCEPTION);
            }
        }
        return response;
    }

    private boolean isWorkplaceJoined() {
        Class<?> certClass = AuthenticationSettings.INSTANCE.getDeviceCertificateProxy();
        return certClass != null;
    }

    private IDeviceCertificate getWPJAPIInstance(Class<IDeviceCertificate> certClazz) throws AuthenticationException {
        IDeviceCertificate deviceCertProxy = null;
        try {
            Constructor<IDeviceCertificate> constructor = certClazz.getDeclaredConstructor(new Class[0]);
            deviceCertProxy = constructor.newInstance(null);
        }
        catch (NoSuchMethodException e) {
            throw new AuthenticationException(ADALError.DEVICE_CERTIFICATE_API_EXCEPTION, "WPJ Api constructor is not defined", e);
        }
        catch (InstantiationException e) {
            throw new AuthenticationException(ADALError.DEVICE_CERTIFICATE_API_EXCEPTION, "WPJ Api constructor is not defined", e);
        }
        catch (IllegalAccessException e) {
            throw new AuthenticationException(ADALError.DEVICE_CERTIFICATE_API_EXCEPTION, "WPJ Api constructor is not defined", e);
        }
        catch (IllegalArgumentException e) {
            throw new AuthenticationException(ADALError.DEVICE_CERTIFICATE_API_EXCEPTION, "WPJ Api constructor is not defined", e);
        }
        catch (InvocationTargetException e) {
            throw new AuthenticationException(ADALError.DEVICE_CERTIFICATE_API_EXCEPTION, "WPJ Api constructor is not defined", e);
        }
        return deviceCertProxy;
    }

    private ChallengeResponse getNoDeviceCertResponse(ChallengeRequest request) {
        ChallengeResponse response = new ChallengeResponse();
        response.mSubmitUrl = request.mSubmitUrl;
        response.mAuthorizationHeaderValue = String.format("%s Context=\"%s\",Version=\"%s\"", "PKeyAuth", request.mContext, request.mVersion);
        return response;
    }

    private ChallengeRequest getChallengeRequestFromHeader(String headerValue) throws UnsupportedEncodingException, AuthenticationException {
        String methodName = ":getChallengeRequestFromHeader";
        if (StringExtensions.IsNullOrBlank(headerValue)) {
            throw new AuthenticationServerProtocolException("headerValue");
        }
        if (!StringExtensions.hasPrefixInHeader(headerValue, "PKeyAuth")) {
            throw new AuthenticationException(ADALError.DEVICE_CERTIFICATE_REQUEST_INVALID, headerValue);
        }
        ChallengeRequest challenge = new ChallengeRequest();
        String authenticateHeader = headerValue.substring("PKeyAuth".length());
        ArrayList<String> queryPairs = StringExtensions.splitWithQuotes(authenticateHeader, ',');
        HashMap<String, String> headerItems = new HashMap<String, String>();
        for (String queryPair : queryPairs) {
            ArrayList<String> pair = StringExtensions.splitWithQuotes(queryPair, '=');
            if (pair.size() == 2 && !StringExtensions.IsNullOrBlank(pair.get(0)) && !StringExtensions.IsNullOrBlank(pair.get(1))) {
                String key = pair.get(0);
                String value = pair.get(1);
                key = StringExtensions.URLFormDecode(key);
                value = StringExtensions.URLFormDecode(value);
                key = key.trim();
                value = StringExtensions.removeQuoteInHeaderValue(value.trim());
                headerItems.put(key, value);
                continue;
            }
            throw new AuthenticationException(ADALError.DEVICE_CERTIFICATE_REQUEST_INVALID, authenticateHeader);
        }
        this.validateChallengeRequest(headerItems, false);
        challenge.mNonce = headerItems.get(RequestField.Nonce.name());
        if (StringExtensions.IsNullOrBlank(challenge.mNonce)) {
            challenge.mNonce = headerItems.get(RequestField.Nonce.name().toLowerCase(Locale.US));
        }
        if (!this.isWorkplaceJoined()) {
            Logger.v("ChallengeResponseBuilder:getChallengeRequestFromHeader", "Device is not workplace joined. ");
        } else if (!StringExtensions.IsNullOrBlank(headerItems.get(RequestField.CertThumbprint.name()))) {
            Logger.v("ChallengeResponseBuilder:getChallengeRequestFromHeader", "CertThumbprint exists in the device auth challenge.");
            challenge.mThumbprint = headerItems.get(RequestField.CertThumbprint.name());
        } else if (headerItems.containsKey(RequestField.CertAuthorities.name())) {
            Logger.v("ChallengeResponseBuilder:getChallengeRequestFromHeader", "CertAuthorities exists in the device auth challenge.");
            String authorities = headerItems.get(RequestField.CertAuthorities.name());
            challenge.mCertAuthorities = StringExtensions.getStringTokens(authorities, ";");
        } else {
            throw new AuthenticationException(ADALError.DEVICE_CERTIFICATE_REQUEST_INVALID, "Both certThumbprint and certauthorities are not present");
        }
        challenge.mVersion = headerItems.get(RequestField.Version.name());
        challenge.mContext = headerItems.get(RequestField.Context.name());
        return challenge;
    }

    private void validateChallengeRequest(HashMap<String, String> headerItems, boolean redirectFormat) throws AuthenticationException {
        if (!headerItems.containsKey(RequestField.Nonce.name()) && !headerItems.containsKey(RequestField.Nonce.name().toLowerCase(Locale.US))) {
            throw new AuthenticationException(ADALError.DEVICE_CERTIFICATE_REQUEST_INVALID, "Nonce");
        }
        if (!headerItems.containsKey(RequestField.Version.name())) {
            throw new AuthenticationException(ADALError.DEVICE_CERTIFICATE_REQUEST_INVALID, "Version");
        }
        if (redirectFormat && !headerItems.containsKey(RequestField.SubmitUrl.name())) {
            throw new AuthenticationException(ADALError.DEVICE_CERTIFICATE_REQUEST_INVALID, "SubmitUrl");
        }
        if (!headerItems.containsKey(RequestField.Context.name())) {
            throw new AuthenticationException(ADALError.DEVICE_CERTIFICATE_REQUEST_INVALID, "Context");
        }
        if (redirectFormat && !headerItems.containsKey(RequestField.CertAuthorities.name())) {
            throw new AuthenticationException(ADALError.DEVICE_CERTIFICATE_REQUEST_INVALID, "CertAuthorities");
        }
    }

    private ChallengeRequest getChallengeRequest(String redirectUri) throws AuthenticationException {
        if (StringExtensions.IsNullOrBlank(redirectUri)) {
            throw new AuthenticationServerProtocolException("redirectUri");
        }
        ChallengeRequest challenge = new ChallengeRequest();
        HashMap<String, String> parameters = StringExtensions.getUrlParameters(redirectUri);
        this.validateChallengeRequest(parameters, true);
        challenge.mNonce = parameters.get(RequestField.Nonce.name());
        if (StringExtensions.IsNullOrBlank(challenge.mNonce)) {
            challenge.mNonce = parameters.get(RequestField.Nonce.name().toLowerCase(Locale.US));
        }
        String authorities = parameters.get(RequestField.CertAuthorities.name());
        Logger.v(TAG, "Cert authorities:" + authorities);
        challenge.mCertAuthorities = StringExtensions.getStringTokens(authorities, ";");
        challenge.mVersion = parameters.get(RequestField.Version.name());
        challenge.mSubmitUrl = parameters.get(RequestField.SubmitUrl.name());
        challenge.mContext = parameters.get(RequestField.Context.name());
        return challenge;
    }

    class ChallengeRequest {
        String mNonce = "";
        String mContext = "";
        List<String> mCertAuthorities;
        String mThumbprint = "";
        String mVersion = null;
        String mSubmitUrl = "";

        ChallengeRequest() {
        }
    }

    static enum RequestField {
        Nonce,
        CertAuthorities,
        Version,
        SubmitUrl,
        Context,
        CertThumbprint;

    }

    class ChallengeResponse {
        String mSubmitUrl;
        String mAuthorizationHeaderValue;

        ChallengeResponse() {
        }

        public String getSubmitUrl() {
            return this.mSubmitUrl;
        }

        public String getAuthorizationHeaderValue() {
            return this.mAuthorizationHeaderValue;
        }
    }
}

