/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import com.microsoft.aad.adal.TokenCacheItem;
import com.microsoft.aad.adal.UserInfo;
import java.io.Serializable;
import java.util.Date;

public class AuthenticationResult
implements Serializable {
    private static final long serialVersionUID = 2243372613182536368L;
    private String mCode;
    private String mAccessToken;
    private String mRefreshToken;
    private String mTokenType;
    private Date mExpiresOn;
    private String mErrorCode;
    private String mErrorDescription;
    private boolean mIsMultiResourceRefreshToken;
    private UserInfo mUserInfo;
    private String mTenantId;
    private String mIdToken;
    private AuthenticationStatus mStatus = AuthenticationStatus.Failed;
    private boolean mInitialRequest;

    AuthenticationResult() {
        this.mCode = null;
    }

    AuthenticationResult(String code) {
        this.mCode = code;
        this.mStatus = AuthenticationStatus.Succeeded;
        this.mAccessToken = null;
        this.mRefreshToken = null;
    }

    AuthenticationResult(String accessToken, String refreshToken, Date expires, boolean isBroad, UserInfo userInfo, String tenantId, String idToken) {
        this.mCode = null;
        this.mAccessToken = accessToken;
        this.mRefreshToken = refreshToken;
        this.mExpiresOn = expires;
        this.mIsMultiResourceRefreshToken = isBroad;
        this.mStatus = AuthenticationStatus.Succeeded;
        this.mUserInfo = userInfo;
        this.mTenantId = tenantId;
        this.mIdToken = idToken;
    }

    AuthenticationResult(String accessToken, String refreshToken, Date expires, boolean isBroad) {
        this.mCode = null;
        this.mAccessToken = accessToken;
        this.mRefreshToken = refreshToken;
        this.mExpiresOn = expires;
        this.mIsMultiResourceRefreshToken = isBroad;
        this.mStatus = AuthenticationStatus.Succeeded;
    }

    AuthenticationResult(String errorCode, String errDescription) {
        this.mErrorCode = errorCode;
        this.mErrorDescription = errDescription;
        this.mStatus = AuthenticationStatus.Failed;
    }

    static AuthenticationResult createResult(TokenCacheItem cacheItem) {
        if (cacheItem == null) {
            AuthenticationResult result = new AuthenticationResult();
            result.mStatus = AuthenticationStatus.Failed;
            return result;
        }
        return new AuthenticationResult(cacheItem.getAccessToken(), cacheItem.getRefreshToken(), cacheItem.getExpiresOn(), cacheItem.getIsMultiResourceRefreshToken(), cacheItem.getUserInfo(), cacheItem.getTenantId(), cacheItem.getRawIdToken());
    }

    static AuthenticationResult createResultForInitialRequest() {
        AuthenticationResult result = new AuthenticationResult();
        result.mInitialRequest = true;
        return result;
    }

    public String createAuthorizationHeader() {
        return "Bearer " + this.getAccessToken();
    }

    public String getAccessToken() {
        return this.mAccessToken;
    }

    public String getRefreshToken() {
        return this.mRefreshToken;
    }

    public String getAccessTokenType() {
        return this.mTokenType;
    }

    public Date getExpiresOn() {
        return this.mExpiresOn;
    }

    public boolean getIsMultiResourceRefreshToken() {
        return this.mIsMultiResourceRefreshToken;
    }

    public UserInfo getUserInfo() {
        return this.mUserInfo;
    }

    void setUserInfo(UserInfo userinfo) {
        this.mUserInfo = userinfo;
    }

    public String getTenantId() {
        return this.mTenantId;
    }

    public AuthenticationStatus getStatus() {
        return this.mStatus;
    }

    String getCode() {
        return this.mCode;
    }

    void setCode(String code) {
        this.mCode = code;
    }

    public String getErrorCode() {
        return this.mErrorCode;
    }

    public String getErrorDescription() {
        return this.mErrorDescription;
    }

    public String getErrorLogInfo() {
        return " ErrorCode:" + this.getErrorCode() + " ErrorDescription:" + this.getErrorDescription();
    }

    public boolean isExpired() {
        return TokenCacheItem.isTokenExpired(this.getExpiresOn());
    }

    boolean isInitialRequest() {
        return this.mInitialRequest;
    }

    public String getIdToken() {
        return this.mIdToken;
    }

    void setIdToken(String idToken) {
        this.mIdToken = idToken;
    }

    void setTenantId(String tenantid) {
        this.mTenantId = tenantid;
    }

    void setRefreshToken(String refreshToken) {
        this.mRefreshToken = refreshToken;
    }

    public static enum AuthenticationStatus {
        Cancelled,
        Failed,
        Succeeded;

    }
}

