/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.util.Log;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationContext;
import com.microsoft.aad.adal.StringExtensions;

public class Logger {
    private LogLevel mLogLevel = LogLevel.Debug;
    private static final String CUSTOM_LOG_ERROR = "Custom log failed to log message:%s";
    private ILogger mExternalLogger = null;
    private boolean mAndroidLogEnabled = true;
    private static Logger sInstance = new Logger();

    public static Logger getInstance() {
        return sInstance;
    }

    Logger() {
    }

    public LogLevel getLogLevel() {
        return this.mLogLevel;
    }

    public void setLogLevel(LogLevel level) {
        this.mLogLevel = level;
    }

    public void setExternalLogger(ILogger customLogger) {
        this.mExternalLogger = customLogger;
    }

    private static String addVersion(String message) {
        if (message != null) {
            return message + " ver:" + AuthenticationContext.getVersionName();
        }
        return " ver:" + AuthenticationContext.getVersionName();
    }

    public void debug(String tag, String message) {
        if (this.mLogLevel.compareTo(LogLevel.Debug) < 0 || StringExtensions.IsNullOrBlank(message)) {
            return;
        }
        message = Logger.addVersion(message);
        if (this.mAndroidLogEnabled) {
            Log.d((String)tag, (String)message);
        }
        if (this.mExternalLogger != null) {
            try {
                this.mExternalLogger.Log(tag, message, null, LogLevel.Debug, null);
            }
            catch (Exception e) {
                Log.w((String)tag, (String)String.format(CUSTOM_LOG_ERROR, message));
            }
        }
    }

    public void verbose(String tag, String message, String additionalMessage, ADALError errorCode) {
        if (this.mLogLevel.compareTo(LogLevel.Verbose) < 0) {
            return;
        }
        if (this.mAndroidLogEnabled) {
            Log.v((String)tag, (String)Logger.getLogMessage(message, additionalMessage, errorCode));
        }
        message = Logger.addVersion(message);
        if (this.mExternalLogger != null) {
            try {
                this.mExternalLogger.Log(tag, message, additionalMessage, LogLevel.Verbose, errorCode);
            }
            catch (Exception e) {
                Log.w((String)tag, (String)String.format(CUSTOM_LOG_ERROR, message));
            }
        }
    }

    public void inform(String tag, String message, String additionalMessage, ADALError errorCode) {
        if (this.mLogLevel.compareTo(LogLevel.Info) < 0) {
            return;
        }
        if (this.mAndroidLogEnabled) {
            Log.i((String)tag, (String)Logger.getLogMessage(message, additionalMessage, errorCode));
        }
        message = Logger.addVersion(message);
        if (this.mExternalLogger != null) {
            try {
                this.mExternalLogger.Log(tag, message, additionalMessage, LogLevel.Info, errorCode);
            }
            catch (Exception e) {
                Log.w((String)tag, (String)String.format(CUSTOM_LOG_ERROR, message));
            }
        }
    }

    public void warn(String tag, String message, String additionalMessage, ADALError errorCode) {
        if (this.mLogLevel.compareTo(LogLevel.Warn) < 0) {
            return;
        }
        if (this.mAndroidLogEnabled) {
            Log.w((String)tag, (String)Logger.getLogMessage(message, additionalMessage, errorCode));
        }
        message = Logger.addVersion(message);
        if (this.mExternalLogger != null) {
            try {
                this.mExternalLogger.Log(tag, message, additionalMessage, LogLevel.Warn, errorCode);
            }
            catch (Exception e) {
                Log.w((String)tag, (String)String.format(CUSTOM_LOG_ERROR, message));
            }
        }
    }

    public void error(String tag, String message, String additionalMessage, ADALError errorCode) {
        if (this.mAndroidLogEnabled) {
            Log.e((String)tag, (String)Logger.getLogMessage(message, additionalMessage, errorCode));
        }
        message = Logger.addVersion(message);
        if (this.mExternalLogger != null) {
            try {
                this.mExternalLogger.Log(tag, message, additionalMessage, LogLevel.Error, errorCode);
            }
            catch (Exception e) {
                Log.w((String)tag, (String)String.format(CUSTOM_LOG_ERROR, message));
            }
        }
    }

    public void error(String tag, String message, String additionalMessage, ADALError errorCode, Throwable err) {
        if (this.mAndroidLogEnabled) {
            Log.e((String)tag, (String)Logger.getLogMessage(message, additionalMessage, errorCode), (Throwable)err);
        }
        message = Logger.addVersion(message);
        if (this.mExternalLogger != null) {
            try {
                this.mExternalLogger.Log(tag, message, additionalMessage, LogLevel.Error, errorCode);
            }
            catch (Exception e) {
                Log.w((String)tag, (String)String.format(CUSTOM_LOG_ERROR, message));
            }
        }
    }

    private static String getLogMessage(String message, String additionalMessage, ADALError errorCode) {
        StringBuilder msg = new StringBuilder();
        if (errorCode != null) {
            msg.append(Logger.getCodeName(errorCode)).append(":");
        }
        if (message != null) {
            message = Logger.addVersion(message);
            msg.append(message);
        }
        if (additionalMessage != null) {
            msg.append(" ").append(additionalMessage);
        }
        return msg.toString();
    }

    public static void d(String tag, String message) {
        Logger.getInstance().debug(tag, message);
    }

    public static void i(String tag, String message, String additionalMessage, ADALError errorCode) {
        Logger.getInstance().inform(tag, message, additionalMessage, errorCode);
    }

    public static void v(String tag, String message) {
        Logger.getInstance().verbose(tag, message, null, null);
    }

    public static void v(String tag, String message, String additionalMessage, ADALError errorCode) {
        Logger.getInstance().verbose(tag, message, additionalMessage, errorCode);
    }

    public static void w(String tag, String message, String additionalMessage, ADALError errorCode) {
        Logger.getInstance().warn(tag, message, additionalMessage, errorCode);
    }

    public static void e(String tag, String message, String additionalMessage, ADALError errorCode) {
        Logger.getInstance().error(tag, message, additionalMessage, errorCode);
    }

    public static void e(String tag, String message, String additionalMessage, ADALError errorCode, Throwable err) {
        Logger.getInstance().error(tag, message, additionalMessage, errorCode, err);
    }

    public boolean isAndroidLogEnabled() {
        return this.mAndroidLogEnabled;
    }

    public void setAndroidLogEnabled(boolean androidLogEnable) {
        this.mAndroidLogEnabled = androidLogEnable;
    }

    private static String getCodeName(ADALError code) {
        if (code != null) {
            return code.name();
        }
        return "";
    }

    public static interface ILogger {
        public void Log(String var1, String var2, String var3, LogLevel var4, ADALError var5);
    }

    public static enum LogLevel {
        Error(0),
        Warn(1),
        Info(2),
        Verbose(3),
        Debug(4);

        private int value;

        private LogLevel(int val) {
            this.value = val;
        }
    }
}

