/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal;

import android.accounts.Account;
import android.accounts.AccountAuthenticatorResponse;
import android.accounts.AccountManager;
import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.ProgressDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.v4.content.LocalBroadcastManager;
import android.util.Log;
import android.view.Menu;
import android.view.MotionEvent;
import android.view.View;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import android.webkit.SslErrorHandler;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.gson.Gson;
import com.microsoft.aad.adal.ADALError;
import com.microsoft.aad.adal.AuthenticationException;
import com.microsoft.aad.adal.AuthenticationRequest;
import com.microsoft.aad.adal.AuthenticationResult;
import com.microsoft.aad.adal.AuthenticationSettings;
import com.microsoft.aad.adal.CacheKey;
import com.microsoft.aad.adal.ChallangeResponseBuilder;
import com.microsoft.aad.adal.ExceptionExtensions;
import com.microsoft.aad.adal.IJWSBuilder;
import com.microsoft.aad.adal.IWebRequestHandler;
import com.microsoft.aad.adal.JWSBuilder;
import com.microsoft.aad.adal.Logger;
import com.microsoft.aad.adal.Oauth2;
import com.microsoft.aad.adal.PackageHelper;
import com.microsoft.aad.adal.PromptBehavior;
import com.microsoft.aad.adal.R;
import com.microsoft.aad.adal.StorageHelper;
import com.microsoft.aad.adal.StringExtensions;
import com.microsoft.aad.adal.TokenCacheItem;
import com.microsoft.aad.adal.UserInfo;
import com.microsoft.aad.adal.WebRequestHandler;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.DigestException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.UnrecoverableEntryException;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

@SuppressLint(value={"SetJavaScriptEnabled", "ClickableViewAccessibility"})
public class AuthenticationActivity
extends Activity {
    static final int BACK_PRESSED_CANCEL_DIALOG_STEPS = -2;
    private static final String TAG = "AuthenticationActivity";
    private boolean mRegisterReceiver = false;
    private WebView mWebView;
    private String mStartUrl;
    private ProgressDialog mSpinner;
    private String mRedirectUrl;
    private AuthenticationRequest mAuthRequest;
    private ActivityBroadcastReceiver mReceiver = null;
    private String mCallingPackage;
    private int mWaitingRequestId;
    private int mCallingUID;
    private AccountAuthenticatorResponse mAccountAuthenticatorResponse = null;
    private Bundle mAuthenticatorResultBundle = null;
    private IWebRequestHandler mWebRequestHandler = new WebRequestHandler();
    private IJWSBuilder mJWSBuilder = new JWSBuilder();
    private String mQueryParameters;

    @SuppressLint(value={"SetJavaScriptEnabled"})
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(this.getResources().getIdentifier("activity_authentication", "layout", this.getPackageName()));
        CookieSyncManager.createInstance((Context)this.getApplicationContext());
        CookieSyncManager.getInstance().sync();
        CookieManager cookieManager = CookieManager.getInstance();
        cookieManager.setAcceptCookie(true);
        this.mAuthRequest = this.getAuthenticationRequestFromIntent(this.getIntent());
        if (this.mAuthRequest == null) {
            Log.d((String)TAG, (String)"Request item is null, so it returns to caller");
            Intent resultIntent = new Intent();
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorCode", "Invalid request");
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorMessage", "Intent does not have request details");
            this.returnToCaller(2002, resultIntent);
            return;
        }
        if (this.mAuthRequest.getAuthority() == null || this.mAuthRequest.getAuthority().isEmpty()) {
            this.returnError(ADALError.ARGUMENT_EXCEPTION, "account.authority");
            return;
        }
        if (this.mAuthRequest.getResource() == null || this.mAuthRequest.getResource().isEmpty()) {
            this.returnError(ADALError.ARGUMENT_EXCEPTION, "account.resource");
            return;
        }
        if (this.mAuthRequest.getClientId() == null || this.mAuthRequest.getClientId().isEmpty()) {
            this.returnError(ADALError.ARGUMENT_EXCEPTION, "account.clientid.key");
            return;
        }
        if (this.mAuthRequest.getRedirectUri() == null || this.mAuthRequest.getRedirectUri().isEmpty()) {
            this.returnError(ADALError.ARGUMENT_EXCEPTION, "account.redirect");
            return;
        }
        this.mRedirectUrl = this.mAuthRequest.getRedirectUri();
        Log.d((String)TAG, (String)("OnCreate redirectUrl:" + this.mRedirectUrl));
        this.setupWebView();
        Logger.v(TAG, "User agent:" + this.mWebView.getSettings().getUserAgentString());
        this.mStartUrl = "about:blank";
        try {
            Oauth2 oauth = new Oauth2(this.mAuthRequest);
            this.mStartUrl = oauth.getCodeRequestUrl();
            this.mQueryParameters = oauth.getAuthorizationEndpointQueryParameters();
        }
        catch (UnsupportedEncodingException e) {
            Log.d((String)TAG, (String)e.getMessage());
            Intent resultIntent = new Intent();
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserRequestInfo", (Serializable)this.mAuthRequest);
            this.returnToCaller(2002, resultIntent);
            return;
        }
        Logger.v(TAG, "Init broadcastReceiver with requestId:" + this.mAuthRequest.getRequestId() + " " + this.mAuthRequest.getLogInfo());
        this.mReceiver = new ActivityBroadcastReceiver();
        this.mReceiver.mWaitingRequestId = this.mAuthRequest.getRequestId();
        LocalBroadcastManager.getInstance((Context)this).registerReceiver((BroadcastReceiver)this.mReceiver, new IntentFilter("com.microsoft.aad.adal:BrowserCancel"));
        if (this.isBrokerRequest(this.getIntent())) {
            Logger.v(TAG, "It is a broker request");
            this.mCallingPackage = this.getCallingPackage();
            if (this.mCallingPackage == null) {
                Log.d((String)TAG, (String)"startActivityForResult is not used to call this activity");
                Intent resultIntent = new Intent();
                resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorCode", "Invalid request");
                resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorMessage", "startActivityForResult is not used to call this activity");
                this.returnToCaller(2002, resultIntent);
                return;
            }
            String userAgent = this.mWebView.getSettings().getUserAgentString();
            this.mWebView.getSettings().setUserAgentString(userAgent + " PKeyAuth/1.0");
            userAgent = this.mWebView.getSettings().getUserAgentString();
            Logger.v(TAG, "UserAgent:" + userAgent);
            this.mAccountAuthenticatorResponse = (AccountAuthenticatorResponse)this.getIntent().getParcelableExtra("accountAuthenticatorResponse");
            if (this.mAccountAuthenticatorResponse != null) {
                this.mAccountAuthenticatorResponse.onRequestContinued();
            }
            PackageHelper info = new PackageHelper((Context)this);
            this.mCallingPackage = this.getCallingPackage();
            this.mCallingUID = info.getUIDForPackage(this.mCallingPackage);
            String signatureDigest = info.getCurrentSignatureForPackage(this.mCallingPackage);
            this.mStartUrl = this.getBrokerStartUrl(this.mStartUrl, this.mCallingPackage, signatureDigest);
            this.mRedirectUrl = PackageHelper.getBrokerRedirectUrl(this.mCallingPackage, signatureDigest);
            Logger.v(TAG, "OnCreate redirectUrl:" + this.mRedirectUrl + " startUrl:" + this.mStartUrl + " calling package:" + this.mCallingPackage + " signatureDigest:" + signatureDigest + " current Context Package: " + this.getPackageName() + " accountName:" + this.mAuthRequest.getBrokerAccountName() + " loginHint:" + this.mAuthRequest.getLoginHint());
        }
        this.mRegisterReceiver = false;
        final String postUrl = this.mStartUrl;
        Logger.v(TAG, "OnCreate startUrl:" + this.mStartUrl + " calling package:" + this.mCallingPackage + " loginHint:" + this.mAuthRequest.getLoginHint());
        if (savedInstanceState == null) {
            this.mWebView.post(new Runnable(){

                @Override
                public void run() {
                    AuthenticationActivity.this.mWebView.loadUrl("about:blank");
                    AuthenticationActivity.this.mWebView.loadUrl(postUrl);
                }
            });
        } else {
            Logger.d(TAG, "Reuse webview");
        }
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        this.mWebView.saveState(outState);
    }

    protected void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        this.mWebView.restoreState(savedInstanceState);
    }

    private void setupWebView() {
        this.mSpinner = new ProgressDialog((Context)this);
        this.mSpinner.requestWindowFeature(1);
        this.mSpinner.setMessage(this.getText(this.getResources().getIdentifier("app_loading", "string", this.getPackageName())));
        this.mWebView = (WebView)this.findViewById(this.getResources().getIdentifier("webView1", "id", this.getPackageName()));
        this.mWebView.getSettings().setJavaScriptEnabled(true);
        this.mWebView.requestFocus(130);
        this.mWebView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View view, MotionEvent event) {
                int action = event.getAction();
                if (!(action != 0 && action != 1 || view.hasFocus())) {
                    view.requestFocus();
                }
                return false;
            }
        });
        this.mWebView.getSettings().setLoadWithOverviewMode(true);
        this.mWebView.getSettings().setDomStorageEnabled(true);
        this.mWebView.getSettings().setUseWideViewPort(true);
        this.mWebView.getSettings().setBuiltInZoomControls(true);
        this.mWebView.setWebViewClient((WebViewClient)new CustomWebViewClient());
        this.mWebView.setVisibility(4);
    }

    private AuthenticationRequest getAuthenticationRequestFromIntent(Intent callingIntent) {
        AuthenticationRequest authRequest = null;
        if (this.isBrokerRequest(callingIntent)) {
            Logger.v(TAG, "It is a broker request. Get request info from bundle extras.");
            String authority = callingIntent.getStringExtra("account.authority");
            String resource = callingIntent.getStringExtra("account.resource");
            String redirect = callingIntent.getStringExtra("account.redirect");
            String loginhint = callingIntent.getStringExtra("account.login.hint");
            String accountName = callingIntent.getStringExtra("account.name");
            String clientidKey = callingIntent.getStringExtra("account.clientid.key");
            String correlationId = callingIntent.getStringExtra("account.correlationid");
            String prompt = callingIntent.getStringExtra("account.prompt");
            PromptBehavior promptBehavior = PromptBehavior.Auto;
            if (!StringExtensions.IsNullOrBlank(prompt)) {
                promptBehavior = PromptBehavior.valueOf(prompt);
            }
            this.mWaitingRequestId = callingIntent.getIntExtra("com.microsoft.aad.adal:RequestId", 0);
            UUID correlationIdParsed = null;
            if (!StringExtensions.IsNullOrBlank(correlationId)) {
                try {
                    correlationIdParsed = UUID.fromString(correlationId);
                }
                catch (IllegalArgumentException ex) {
                    correlationIdParsed = null;
                    Logger.e(TAG, "CorrelationId is malformed: " + correlationId, "", ADALError.CORRELATION_ID_FORMAT);
                }
            }
            authRequest = new AuthenticationRequest(authority, resource, clientidKey, redirect, loginhint, correlationIdParsed);
            authRequest.setBrokerAccountName(accountName);
            authRequest.setPrompt(promptBehavior);
        } else {
            Serializable request = callingIntent.getSerializableExtra("com.microsoft.aad.adal:BrowserRequestMessage");
            if (request instanceof AuthenticationRequest) {
                authRequest = (AuthenticationRequest)request;
            }
        }
        return authRequest;
    }

    private void returnError(ADALError errorCode, String argument) {
        Log.w((String)TAG, (String)("Argument error:" + argument));
        Intent resultIntent = new Intent();
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorCode", errorCode.name());
        resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorMessage", argument);
        if (this.mAuthRequest != null) {
            resultIntent.putExtra("com.microsoft.aad.adal:RequestId", this.mWaitingRequestId);
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserRequestInfo", (Serializable)this.mAuthRequest);
        }
        this.setResult(2002, resultIntent);
        this.finish();
    }

    private void returnAuthenticationException(AuthenticationException e) {
        Intent resultIntent = new Intent();
        resultIntent.putExtra("com.microsoft.aad.adal:AuthenticationException", (Serializable)e);
        if (this.mAuthRequest != null) {
            resultIntent.putExtra("com.microsoft.aad.adal:RequestId", this.mWaitingRequestId);
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserRequestInfo", (Serializable)this.mAuthRequest);
        }
        this.setResult(2005, resultIntent);
        this.finish();
    }

    private String getBrokerStartUrl(String loadUrl, String packageName, String signatureDigest) {
        if (!StringExtensions.IsNullOrBlank(packageName) && !StringExtensions.IsNullOrBlank(signatureDigest)) {
            try {
                return loadUrl + "&package_name=" + URLEncoder.encode(packageName, "UTF_8") + "&signature=" + URLEncoder.encode(signatureDigest, "UTF_8");
            }
            catch (UnsupportedEncodingException e) {
                Log.e((String)TAG, (String)"Encoding", (Throwable)e);
            }
        }
        return loadUrl;
    }

    private boolean isBrokerRequest(Intent callingIntent) {
        Logger.v(TAG, "Packagename:" + this.getPackageName() + " Broker packagename:" + AuthenticationSettings.INSTANCE.getBrokerPackageName() + " Calling packagename:" + this.getCallingPackage());
        return callingIntent != null && !StringExtensions.IsNullOrBlank(callingIntent.getStringExtra("com.microsoft.aadbroker.adal.broker.request")) && this.getPackageName().equals(AuthenticationSettings.INSTANCE.getBrokerPackageName());
    }

    private void returnToCaller(int resultCode, Intent data) {
        Logger.d(TAG, "Return To Caller:" + resultCode);
        this.displaySpinner(false);
        if (data == null) {
            data = new Intent();
        }
        if (this.mAuthRequest != null) {
            Logger.d(TAG, "Return To Caller REQUEST_ID:" + this.mAuthRequest.getRequestId());
            data.putExtra("com.microsoft.aad.adal:RequestId", this.mAuthRequest.getRequestId());
        } else {
            Logger.w(TAG, "Request object is null", "", ADALError.ACTIVITY_REQUEST_INTENT_DATA_IS_NULL);
        }
        this.setResult(resultCode, data);
        this.finish();
    }

    protected void onPause() {
        Logger.d(TAG, "AuthenticationActivity onPause unregister receiver");
        super.onPause();
        if (this.mReceiver != null) {
            LocalBroadcastManager.getInstance((Context)this).unregisterReceiver((BroadcastReceiver)this.mReceiver);
        }
        this.mRegisterReceiver = true;
    }

    protected void onResume() {
        super.onResume();
        if (this.mRegisterReceiver) {
            Logger.v(TAG, "Webview onResume will register receiver:" + this.mStartUrl);
            if (this.mReceiver != null) {
                Logger.v(TAG, "Webview onResume register broadcast receiver for requestId" + this.mReceiver.mWaitingRequestId);
                LocalBroadcastManager.getInstance((Context)this).registerReceiver((BroadcastReceiver)this.mReceiver, new IntentFilter("com.microsoft.aad.adal:BrowserCancel"));
            }
        }
        this.mRegisterReceiver = false;
    }

    protected void onRestart() {
        Logger.d(TAG, "AuthenticationActivity onRestart");
        super.onRestart();
        this.mRegisterReceiver = true;
    }

    public void onBackPressed() {
        Logger.d(TAG, "Back button is pressed");
        if (!this.mWebView.canGoBackOrForward(-2)) {
            this.cancelRequest();
        } else {
            this.mWebView.goBack();
        }
    }

    public boolean onCreateOptionsMenu(Menu menu2) {
        this.getMenuInflater().inflate(R.menu.login, menu2);
        return true;
    }

    private void cancelRequest() {
        Logger.v(TAG, "Sending intent to cancel authentication activity");
        Intent resultIntent = new Intent();
        this.returnToCaller(2001, resultIntent);
    }

    private void displaySpinner(boolean show) {
        if (!this.isFinishing() && this.mSpinner != null) {
            if (show && !this.mSpinner.isShowing()) {
                this.mSpinner.show();
            }
            if (!show && this.mSpinner.isShowing()) {
                this.mSpinner.dismiss();
            }
        }
    }

    private void displaySpinnerWithMessage(CharSequence charSequence) {
        if (!this.isFinishing() && this.mSpinner != null) {
            this.mSpinner.show();
            this.mSpinner.setMessage(charSequence);
        }
    }

    private void returnResult(int resultcode, Intent intent) {
        this.setAccountAuthenticatorResult(intent.getExtras());
        this.setResult(resultcode, intent);
        this.finish();
    }

    public void finish() {
        if (this.isBrokerRequest(this.getIntent()) && this.mAccountAuthenticatorResponse != null) {
            Logger.v(TAG, "It is a broker request");
            if (this.mAuthenticatorResultBundle != null) {
                this.mAccountAuthenticatorResponse.onResult(this.mAuthenticatorResultBundle);
            } else {
                this.mAccountAuthenticatorResponse.onError(4, "canceled");
            }
            this.mAccountAuthenticatorResponse = null;
        }
        super.finish();
    }

    private final void setAccountAuthenticatorResult(Bundle result) {
        this.mAuthenticatorResultBundle = result;
    }

    class TokenTaskResult {
        AuthenticationResult taskResult;
        Exception taskException;
        String accountName;

        TokenTaskResult() {
        }
    }

    class TokenTask
    extends AsyncTask<String, String, TokenTaskResult> {
        String mPackageName;
        int mAppCallingUID;
        AuthenticationRequest mRequest;
        AccountManager mAccountManager;
        IWebRequestHandler mRequestHandler;

        public TokenTask() {
        }

        public TokenTask(IWebRequestHandler webHandler, AuthenticationRequest request, String packagename, int callingUID) {
            this.mRequestHandler = webHandler;
            this.mRequest = request;
            this.mPackageName = packagename;
            this.mAppCallingUID = callingUID;
            this.mAccountManager = AccountManager.get((Context)AuthenticationActivity.this);
        }

        protected TokenTaskResult doInBackground(String ... urlItems) {
            Oauth2 oauthRequest = new Oauth2(this.mRequest, this.mRequestHandler, AuthenticationActivity.this.mJWSBuilder);
            TokenTaskResult result = new TokenTaskResult();
            try {
                result.taskResult = oauthRequest.getToken(urlItems[0]);
                Logger.v(AuthenticationActivity.TAG, "TokenTask processed the result. " + this.mRequest.getLogInfo());
            }
            catch (Exception exc) {
                Logger.e(AuthenticationActivity.TAG, "Error in processing code to get a token. " + this.mRequest.getLogInfo(), "Request url:" + urlItems[0], ADALError.AUTHORIZATION_CODE_NOT_EXCHANGED_FOR_TOKEN, exc);
                result.taskException = exc;
            }
            if (result != null && result.taskResult != null && result.taskResult.getAccessToken() != null) {
                Logger.v(AuthenticationActivity.TAG, "Setting account:" + this.mRequest.getLogInfo());
                try {
                    this.setAccount(result);
                }
                catch (Exception exc) {
                    Logger.e(AuthenticationActivity.TAG, "Error in setting the account" + this.mRequest.getLogInfo(), "", ADALError.BROKER_ACCOUNT_SAVE_FAILED, exc);
                    result.taskException = exc;
                }
            }
            return result;
        }

        private String getBrokerAppCacheKey(StorageHelper cryptoHelper, String cacheKey) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, NoSuchPaddingException, IOException {
            String digestKey = StringExtensions.createHash("calling.uid.key" + this.mAppCallingUID + cacheKey);
            Logger.d(AuthenticationActivity.TAG, "Cache key original:" + cacheKey + " digestKey:" + digestKey + " calling app UID:" + this.mAppCallingUID);
            return digestKey;
        }

        private void appendAppUIDToAccount(StorageHelper cryptoHelper, Account account) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, NoSuchPaddingException, IOException, KeyStoreException, CertificateException, NoSuchProviderException, UnrecoverableEntryException, DigestException {
            String appIdList = this.mAccountManager.getUserData(account, "account.uid.caches");
            appIdList = appIdList == null ? "" : cryptoHelper.decrypt(appIdList);
            Logger.v(AuthenticationActivity.TAG, "Add calling UID:" + this.mAppCallingUID);
            if (!appIdList.contains("calling.uid.key" + this.mAppCallingUID)) {
                Logger.v(AuthenticationActivity.TAG, "Account has new calling UID:" + this.mAppCallingUID);
                this.mAccountManager.setUserData(account, "account.uid.caches", cryptoHelper.encrypt(appIdList + "calling.uid.key" + this.mAppCallingUID));
            }
        }

        private void setAccount(TokenTaskResult result) throws InvalidKeyException, InvalidKeySpecException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, IOException {
            try {
                String name = this.mRequest.getBrokerAccountName();
                Account[] accountList = this.mAccountManager.getAccountsByType("com.microsoft.workaccount");
                if (accountList == null || accountList.length != 1) {
                    result.taskResult = null;
                    result.taskException = new AuthenticationException(ADALError.BROKER_SINGLE_USER_EXPECTED);
                    return;
                }
                if (result.taskResult.getUserInfo() == null || StringExtensions.IsNullOrBlank(result.taskResult.getUserInfo().getUserId())) {
                    Logger.v(AuthenticationActivity.TAG, "Set userinfo from account");
                    result.taskResult.setUserInfo(new UserInfo(name, name, "", "", name));
                    this.mRequest.setLoginHint(name);
                }
                result.accountName = name;
                Logger.v(AuthenticationActivity.TAG, "Setting account. Account name: " + name + " package:" + AuthenticationActivity.this.mCallingPackage + " calling app UID:" + this.mAppCallingUID);
                Account newaccount = accountList[0];
                Gson gson = new Gson();
                Logger.v(AuthenticationActivity.TAG, "app context:" + AuthenticationActivity.this.getApplicationContext().getPackageName() + " context:" + AuthenticationActivity.this.getPackageName() + " calling packagename:" + AuthenticationActivity.this.getCallingPackage());
                StorageHelper cryptoHelper = new StorageHelper(AuthenticationActivity.this.getApplicationContext());
                TokenCacheItem item = new TokenCacheItem(this.mRequest, result.taskResult, false);
                String json = gson.toJson((Object)item);
                String encrypted = cryptoHelper.encrypt(json);
                String key = CacheKey.createCacheKey(this.mRequest, null);
                this.saveCacheKey(key, newaccount, this.mAppCallingUID);
                this.mAccountManager.setUserData(newaccount, this.getBrokerAppCacheKey(cryptoHelper, key), encrypted);
                if (result.taskResult.getIsMultiResourceRefreshToken()) {
                    TokenCacheItem itemMRRT = new TokenCacheItem(this.mRequest, result.taskResult, true);
                    json = gson.toJson((Object)itemMRRT);
                    encrypted = cryptoHelper.encrypt(json);
                    key = CacheKey.createMultiResourceRefreshTokenKey(this.mRequest, null);
                    this.saveCacheKey(key, newaccount, this.mAppCallingUID);
                    this.mAccountManager.setUserData(newaccount, this.getBrokerAppCacheKey(cryptoHelper, key), encrypted);
                }
                Logger.v(AuthenticationActivity.TAG, "Set calling uid:" + this.mAppCallingUID);
                this.appendAppUIDToAccount(cryptoHelper, newaccount);
            }
            catch (NoSuchAlgorithmException e) {
                Logger.e(AuthenticationActivity.TAG, "Algorithm does not exist in the device", "", ADALError.DEVICE_CACHE_IS_NOT_WORKING, e);
                result.taskException = e;
            }
            catch (NoSuchPaddingException e) {
                Logger.e(AuthenticationActivity.TAG, "Padding type does not exist in the device", "", ADALError.DEVICE_CACHE_IS_NOT_WORKING, e);
                result.taskException = e;
            }
            catch (KeyStoreException e) {
                Logger.e(AuthenticationActivity.TAG, "Key store type is not supported", "", ADALError.DEVICE_CACHE_IS_NOT_WORKING, e);
                result.taskException = e;
            }
            catch (CertificateException e) {
                Logger.e(AuthenticationActivity.TAG, "Certificate exception", "", ADALError.DEVICE_CACHE_IS_NOT_WORKING, e);
                result.taskException = e;
            }
            catch (NoSuchProviderException e) {
                Logger.e(AuthenticationActivity.TAG, "Requested security provider does not exists in the device", "", ADALError.DEVICE_CACHE_IS_NOT_WORKING, e);
                result.taskException = e;
            }
            catch (UnrecoverableEntryException e) {
                Logger.e(AuthenticationActivity.TAG, "Key entry is not recoverable", "", ADALError.DEVICE_CACHE_IS_NOT_WORKING, e);
                result.taskException = e;
            }
            catch (DigestException e) {
                Logger.e(AuthenticationActivity.TAG, "Digest is not valid", "", ADALError.DEVICE_CACHE_IS_NOT_WORKING, e);
                result.taskException = e;
            }
        }

        private void saveCacheKey(String key, Account cacheAccount, int callingUID) {
            Logger.d(AuthenticationActivity.TAG, "Get CacheKeys for account");
            String keylist = this.mAccountManager.getUserData(cacheAccount, "userdata.caller.cachekeys" + callingUID);
            if (keylist == null) {
                keylist = "";
            }
            if (!keylist.contains("|" + key)) {
                Logger.v(AuthenticationActivity.TAG, "Account does not have this cache key:" + key + " It will save it to accoun for the callerUID:" + callingUID);
                keylist = keylist + "|" + key;
                this.mAccountManager.setUserData(cacheAccount, "userdata.caller.cachekeys" + callingUID, keylist);
                Logger.v(AuthenticationActivity.TAG, "keylist:" + keylist);
            }
        }

        protected void onPostExecute(TokenTaskResult result) {
            Logger.v(AuthenticationActivity.TAG, "Token task returns the result");
            AuthenticationActivity.this.displaySpinner(false);
            Intent intent = new Intent();
            if (result.taskResult != null) {
                intent.putExtra("com.microsoft.aad.adal:RequestId", AuthenticationActivity.this.mWaitingRequestId);
                intent.putExtra("account.access.token", result.taskResult.getAccessToken());
                intent.putExtra("account.name", result.accountName);
                intent.putExtra("account.expiredate", result.taskResult.getExpiresOn().getTime());
                if (result.taskResult.getUserInfo() != null) {
                    intent.putExtra("account.userinfo.userid", result.taskResult.getUserInfo().getUserId());
                    intent.putExtra("account.userinfo.given.name", result.taskResult.getUserInfo().getGivenName());
                    intent.putExtra("account.userinfo.family.name", result.taskResult.getUserInfo().getFamilyName());
                    intent.putExtra("account.userinfo.identity.provider", result.taskResult.getUserInfo().getIdentityProvider());
                    intent.putExtra("account.userinfo.userid.displayable", result.taskResult.getUserInfo().getDisplayableId());
                }
                AuthenticationActivity.this.returnResult(2004, intent);
            } else {
                AuthenticationActivity.this.returnError(ADALError.AUTHORIZATION_CODE_NOT_EXCHANGED_FOR_TOKEN, result.taskException.getMessage());
            }
        }
    }

    class CustomWebViewClient
    extends WebViewClient {
        private static final String BLANK_PAGE = "about:blank";

        CustomWebViewClient() {
        }

        public boolean shouldOverrideUrlLoading(WebView view, String url) {
            Logger.d(AuthenticationActivity.TAG, "shouldOverrideUrlLoading:url=" + url);
            AuthenticationActivity.this.displaySpinner(true);
            if (url.startsWith("urn:http-auth:PKeyAuth")) {
                Logger.v(AuthenticationActivity.TAG, "Webview detected request for client certificate");
                view.stopLoading();
                final String challangeUrl = url;
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ChallangeResponseBuilder certHandler = new ChallangeResponseBuilder(AuthenticationActivity.this.mJWSBuilder);
                            final ChallangeResponseBuilder.ChallangeResponse challangeResponse = certHandler.getChallangeResponseFromUri(challangeUrl);
                            final HashMap<String, String> headers = new HashMap<String, String>();
                            headers.put("Authorization", challangeResponse.mAuthorizationHeaderValue);
                            AuthenticationActivity.this.mWebView.post(new Runnable(){

                                @Override
                                public void run() {
                                    String loadUrl = challangeResponse.mSubmitUrl;
                                    HashMap<String, String> parameters = StringExtensions.getUrlParameters(challangeResponse.mSubmitUrl);
                                    Logger.v(AuthenticationActivity.TAG, "SubmitUrl:" + challangeResponse.mSubmitUrl);
                                    if (!parameters.containsKey("client_id")) {
                                        loadUrl = loadUrl + "?" + AuthenticationActivity.this.mQueryParameters;
                                    }
                                    Logger.v(AuthenticationActivity.TAG, "Loadurl:" + loadUrl);
                                    AuthenticationActivity.this.mWebView.loadUrl(loadUrl, (Map)headers);
                                }
                            });
                        }
                        catch (IllegalArgumentException e) {
                            Logger.e(AuthenticationActivity.TAG, "Argument exception", e.getMessage(), ADALError.ARGUMENT_EXCEPTION, e);
                            AuthenticationActivity.this.returnAuthenticationException(new AuthenticationException(ADALError.ARGUMENT_EXCEPTION, e.getMessage(), e));
                        }
                        catch (AuthenticationException e) {
                            Logger.e(AuthenticationActivity.TAG, "It is failed to create device certificate response", e.getMessage(), ADALError.DEVICE_CERTIFICATE_RESPONSE_FAILED, e);
                            AuthenticationActivity.this.returnAuthenticationException(e);
                        }
                    }
                }).start();
                return true;
            }
            if (url.startsWith(AuthenticationActivity.this.mRedirectUrl)) {
                Logger.v(AuthenticationActivity.TAG, "Webview reached redirecturl");
                if (!AuthenticationActivity.this.isBrokerRequest(AuthenticationActivity.this.getIntent())) {
                    Logger.v(AuthenticationActivity.TAG, "It is not a broker request");
                    Intent resultIntent = new Intent();
                    resultIntent.putExtra("com.microsoft.aad.adal:BrowserFinalUrl", url);
                    resultIntent.putExtra("com.microsoft.aad.adal:BrowserRequestInfo", (Serializable)AuthenticationActivity.this.mAuthRequest);
                    AuthenticationActivity.this.returnToCaller(2003, resultIntent);
                    view.stopLoading();
                    return true;
                }
                Logger.v(AuthenticationActivity.TAG, "It is a broker request");
                AuthenticationActivity.this.displaySpinnerWithMessage(AuthenticationActivity.this.getText(AuthenticationActivity.this.getResources().getIdentifier("broker_processing", "string", AuthenticationActivity.this.getPackageName())));
                view.stopLoading();
                new TokenTask(AuthenticationActivity.this.mWebRequestHandler, AuthenticationActivity.this.mAuthRequest, AuthenticationActivity.this.mCallingPackage, AuthenticationActivity.this.mCallingUID).execute(new String[]{url});
                return true;
            }
            if (url.startsWith("browser://")) {
                Logger.v(AuthenticationActivity.TAG, "It is an external website request");
                this.openLinkInBrowser(url);
                view.stopLoading();
                return true;
            }
            if (AuthenticationActivity.this.isBrokerRequest(AuthenticationActivity.this.getIntent()) && url.startsWith("msauth")) {
                AuthenticationActivity.this.returnError(ADALError.DEVELOPER_REDIRECTURI_INVALID, String.format("The RedirectUri is not as expected. Received %s and expected %s", url, AuthenticationActivity.this.mRedirectUrl));
                view.stopLoading();
                return true;
            }
            return false;
        }

        public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
            super.onReceivedError(view, errorCode, description, failingUrl);
            AuthenticationActivity.this.displaySpinner(false);
            Logger.e(AuthenticationActivity.TAG, "Webview received an error. Errorcode:" + errorCode + " " + description, "", ADALError.ERROR_WEBVIEW);
            Intent resultIntent = new Intent();
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorCode", "Error Code:" + errorCode);
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorMessage", description);
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserRequestInfo", (Serializable)AuthenticationActivity.this.mAuthRequest);
            AuthenticationActivity.this.returnToCaller(2002, resultIntent);
        }

        public void onReceivedSslError(WebView view, SslErrorHandler handler, SslError error) {
            super.onReceivedSslError(view, handler, error);
            AuthenticationActivity.this.displaySpinner(false);
            handler.cancel();
            Logger.e(AuthenticationActivity.TAG, "Received ssl error", "", ADALError.ERROR_FAILED_SSL_HANDSHAKE);
            Intent resultIntent = new Intent();
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorCode", "Code:-11");
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserErrorMessage", error.toString());
            resultIntent.putExtra("com.microsoft.aad.adal:BrowserRequestInfo", (Serializable)AuthenticationActivity.this.mAuthRequest);
            AuthenticationActivity.this.returnToCaller(2002, resultIntent);
        }

        public void onPageFinished(WebView view, String url) {
            super.onPageFinished(view, url);
            Logger.v(AuthenticationActivity.TAG, "Page finished:" + url);
            AuthenticationActivity.this.mWebView.setVisibility(0);
            if (!url.startsWith(BLANK_PAGE)) {
                AuthenticationActivity.this.displaySpinner(false);
            }
        }

        public void onPageStarted(WebView view, String url, Bitmap favicon) {
            super.onPageStarted(view, url, favicon);
            AuthenticationActivity.this.displaySpinner(true);
        }

        private void openLinkInBrowser(String url) {
            String link = url.replace("browser://", "https://");
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)link));
            AuthenticationActivity.this.startActivity(intent);
        }
    }

    private class ActivityBroadcastReceiver
    extends BroadcastReceiver {
        private int mWaitingRequestId = -1;

        private ActivityBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            Logger.v(AuthenticationActivity.TAG, "ActivityBroadcastReceiver onReceive");
            if (intent.getAction().equalsIgnoreCase("com.microsoft.aad.adal:BrowserCancel")) {
                try {
                    Logger.v(AuthenticationActivity.TAG, "ActivityBroadcastReceiver onReceive action is for cancelling Authentication Activity");
                    int cancelRequestId = intent.getIntExtra("com.microsoft.aad.adal:RequestId", 0);
                    if (cancelRequestId == this.mWaitingRequestId) {
                        Logger.v(AuthenticationActivity.TAG, "Waiting requestId is same and cancelling this activity");
                        AuthenticationActivity.this.finish();
                    }
                }
                catch (Exception ex) {
                    Logger.e(AuthenticationActivity.TAG, "ActivityBroadcastReceiver onReceive exception", ExceptionExtensions.getExceptionMessage(ex), ADALError.BROADCAST_RECEIVER_ERROR);
                }
            }
        }
    }
}

