/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.adm.nga.sdk.network;

import com.hpe.adm.nga.sdk.query.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class OctaneUrl {
    private static final String LIMIT_PARAM_NAME = "limit";
    private static final String OFFSET_PARAM_NAME = "offset";
    private static final String FIELDS_PARAM_NAME = "fields";
    private static final String ORDER_BY_PARAM_NAME = "order_by";
    private static final String QUERY_PARAM_NAME = "query";
    private static final String PATH_SEPARATOR = "/";
    private String baseUrl;
    private Map<String, String> queryParams = new HashMap<String, String>();
    private List<String> paths = new ArrayList<String>();

    OctaneUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    void addPaths(String paths) {
        String[] subPaths = paths.split(PATH_SEPARATOR);
        this.paths.addAll(Arrays.asList(subPaths));
    }

    public List<String> getPaths() {
        return this.paths;
    }

    public boolean hasParam(String paramName) {
        return this.queryParams.containsKey(paramName);
    }

    public void setParam(String paramName, String paramValue) {
        this.queryParams.put(paramName, paramValue);
    }

    public String getParam(String paramName) {
        return this.queryParams.get(paramName);
    }

    public void addFieldsParam(String ... fields) {
        String fieldsString = Arrays.stream(fields).collect(Collectors.joining(","));
        if (this.hasParam(FIELDS_PARAM_NAME)) {
            this.getParam("fields," + fieldsString);
        } else {
            this.setParam(FIELDS_PARAM_NAME, fieldsString);
        }
    }

    public void setLimitParam(int limit) {
        this.setParam(LIMIT_PARAM_NAME, String.valueOf(limit));
    }

    public void setOffsetParam(int offset) {
        this.setParam(OFFSET_PARAM_NAME, String.valueOf(offset));
    }

    public void setOrderByParam(String orderBy, boolean asc) {
        String ascString = asc ? "" : "-";
        String orderByString = ascString + orderBy;
        this.setParam(ORDER_BY_PARAM_NAME, orderByString);
    }

    public void setDqlQueryParam(Query query) {
        this.setParam(QUERY_PARAM_NAME, '\"' + query.getQueryString() + '\"');
    }

    private String createQueryString() {
        return this.queryParams.keySet().stream().map(key -> key + "=" + this.queryParams.get(key)).collect(Collectors.joining("&"));
    }

    public String toString() {
        String url = this.baseUrl;
        if (this.getPaths().size() > 0) {
            if (!url.endsWith(PATH_SEPARATOR)) {
                url = url + PATH_SEPARATOR;
            }
            url = url + this.getPaths().stream().collect(Collectors.joining(PATH_SEPARATOR));
        }
        url = this.queryParams.size() > 0 ? url + "?" + this.createQueryString() : url;
        return url;
    }
}

