/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.adm.nga.sdk.entities.update;

import com.hpe.adm.nga.sdk.APIMode;
import com.hpe.adm.nga.sdk.entities.OctaneCollection;
import com.hpe.adm.nga.sdk.entities.TypedEntityList;
import com.hpe.adm.nga.sdk.entities.update.UpdateHelper;
import com.hpe.adm.nga.sdk.model.EntityModel;
import com.hpe.adm.nga.sdk.model.OctaneCollectionSupplier;
import com.hpe.adm.nga.sdk.model.TypedEntityModel;
import com.hpe.adm.nga.sdk.network.OctaneHttpClient;
import com.hpe.adm.nga.sdk.network.OctaneRequest;
import com.hpe.adm.nga.sdk.query.Query;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public abstract class UpdateTypedEntities<T extends TypedEntityModel, E extends UpdateTypedEntities>
extends TypedEntityList.TypedEntityRequest<T> {
    private Collection<T> entityModels = null;
    private final OctaneRequest octaneRequest;

    protected UpdateTypedEntities(Class<T> typedEntityModelClass, OctaneHttpClient octaneHttpClient, String urlDomain) {
        super(typedEntityModelClass);
        this.octaneRequest = new OctaneRequest(octaneHttpClient, urlDomain);
    }

    public final OctaneCollection<T> execute() {
        List<EntityModel> convertedEntityModels = this.entityModels.stream().map(TypedEntityModel::getWrappedEntityModel).collect(Collectors.toList());
        OctaneCollection<EntityModel> updatedEntities = UpdateHelper.getInstance().updateEntityModels(convertedEntityModels, this.octaneRequest);
        return (OctaneCollection)updatedEntities.stream().map(this::getEntityInstance).collect(Collectors.toCollection(new OctaneCollectionSupplier(updatedEntities)));
    }

    public final OctaneCollection<T> execute(APIMode header) {
        this.octaneRequest.addHeader(header);
        OctaneCollection<T> result = this.execute();
        this.octaneRequest.removeHeader(header);
        return result;
    }

    public final E entities(Collection<T> entities) {
        this.entityModels = entities;
        return (E)this;
    }

    public final E query(Query query) {
        this.octaneRequest.getOctaneUrl().setDqlQueryParam(query);
        return (E)this;
    }
}

