/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.adm.nga.sdk.entities.get;

import com.hpe.adm.nga.sdk.APIMode;
import com.hpe.adm.nga.sdk.entities.OctaneCollection;
import com.hpe.adm.nga.sdk.entities.TypedEntityList;
import com.hpe.adm.nga.sdk.entities.get.GetHelper;
import com.hpe.adm.nga.sdk.entities.get.GetTypedHelper;
import com.hpe.adm.nga.sdk.model.EntityModel;
import com.hpe.adm.nga.sdk.model.OctaneCollectionSupplier;
import com.hpe.adm.nga.sdk.model.TypedEntityModel;
import com.hpe.adm.nga.sdk.network.OctaneHttpClient;
import com.hpe.adm.nga.sdk.network.OctaneRequest;
import com.hpe.adm.nga.sdk.query.Query;
import java.util.stream.Collectors;

public abstract class GetTypedEntities<T extends TypedEntityModel, E extends GetTypedEntities, F extends TypedEntityList.AvailableFields, G extends TypedEntityList.SortableFields>
extends TypedEntityList.TypedEntityRequest<T> {
    private final OctaneRequest octaneRequest;

    protected GetTypedEntities(Class<T> typedEntityModelClass, OctaneHttpClient octaneHttpClient, String baseDomain) {
        super(typedEntityModelClass);
        this.octaneRequest = new OctaneRequest(octaneHttpClient, baseDomain);
    }

    public final OctaneCollection<T> execute() {
        OctaneCollection<EntityModel> entityModels = GetHelper.getInstance().getEntityModels(this.octaneRequest);
        return (OctaneCollection)entityModels.stream().map(this::getEntityInstance).collect(Collectors.toCollection(new OctaneCollectionSupplier(entityModels)));
    }

    public final OctaneCollection<T> execute(APIMode header) {
        this.octaneRequest.addHeader(header);
        OctaneCollection<T> result = this.execute();
        this.octaneRequest.removeHeader(header);
        return result;
    }

    public final E addFields(F ... fields) {
        GetTypedHelper.addFields((OctaneRequest)this.octaneRequest, fields);
        return (E)this;
    }

    public final E limit(int limit) {
        this.octaneRequest.getOctaneUrl().setLimitParam(limit);
        return (E)this;
    }

    public final E offset(int offset) {
        this.octaneRequest.getOctaneUrl().setOffsetParam(offset);
        return (E)this;
    }

    public final E addOrderBy(G sortableField, boolean asc) {
        this.octaneRequest.getOctaneUrl().setOrderByParam(sortableField.getFieldName(), asc);
        return (E)this;
    }

    public final E query(Query query) {
        this.octaneRequest.getOctaneUrl().setDqlQueryParam(query);
        return (E)this;
    }
}

