/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.adm.nga.sdk.entities.create;

import com.hpe.adm.nga.sdk.APIMode;
import com.hpe.adm.nga.sdk.entities.OctaneCollection;
import com.hpe.adm.nga.sdk.entities.TypedEntityList;
import com.hpe.adm.nga.sdk.entities.create.CreateHelper;
import com.hpe.adm.nga.sdk.model.EntityModel;
import com.hpe.adm.nga.sdk.model.OctaneCollectionSupplier;
import com.hpe.adm.nga.sdk.model.TypedEntityModel;
import com.hpe.adm.nga.sdk.network.OctaneHttpClient;
import com.hpe.adm.nga.sdk.network.OctaneRequest;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public abstract class CreateTypedEntities<T extends TypedEntityModel, E extends CreateTypedEntities>
extends TypedEntityList.TypedEntityRequest<T> {
    private Collection<T> entityModels = null;
    private final OctaneRequest octaneRequest;

    protected CreateTypedEntities(Class<T> typedEntityModelClass, OctaneHttpClient octaneHttpClient, String urlDomain) {
        super(typedEntityModelClass);
        this.octaneRequest = new OctaneRequest(octaneHttpClient, urlDomain);
    }

    public final OctaneCollection<T> execute() {
        List<EntityModel> convertedEntityModels = this.entityModels.stream().map(TypedEntityModel::getWrappedEntityModel).collect(Collectors.toList());
        OctaneCollection<EntityModel> createdEntities = CreateHelper.getInstance().createEntities(convertedEntityModels, this.octaneRequest);
        return (OctaneCollection)createdEntities.stream().map(this::getEntityInstance).collect(Collectors.toCollection(new OctaneCollectionSupplier(createdEntities)));
    }

    public final OctaneCollection<T> execute(APIMode header) {
        this.octaneRequest.addHeader(header);
        OctaneCollection<T> result = this.execute();
        this.octaneRequest.removeHeader(header);
        return result;
    }

    public final E entities(Collection<T> entities) {
        this.entityModels = entities;
        return (E)this;
    }
}

