/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.adm.nga.sdk;

import com.hpe.adm.nga.sdk.Octane;
import com.hpe.adm.nga.sdk.authentication.Authentication;
import com.hpe.adm.nga.sdk.network.OctaneHttpClient;
import com.hpe.adm.nga.sdk.network.google.GoogleHttpClient;
import com.hpe.adm.nga.sdk.siteadmin.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SiteAdmin {
    private static final String SITE_ADMIN_DOMAIN_FORMAT = "/admin/";
    private final String urlDomain;
    private final OctaneHttpClient octaneHttpClient;

    private SiteAdmin(OctaneHttpClient octaneHttpClient, String domain) {
        this.octaneHttpClient = octaneHttpClient;
        this.urlDomain = domain + SITE_ADMIN_DOMAIN_FORMAT;
    }

    public Server getServer() {
        return new Server(this.octaneHttpClient, this.urlDomain);
    }

    public static class Builder {
        private final Logger logger = LoggerFactory.getLogger((String)Octane.class.getName());
        protected String urlDomain = "";
        protected OctaneHttpClient octaneHttpClient;
        private final Authentication authentication;

        public Builder(Authentication authentication) {
            assert (authentication != null);
            this.authentication = authentication;
        }

        public Builder(Authentication authentication, OctaneHttpClient octaneHttpClient) {
            assert (authentication != null);
            assert (octaneHttpClient != null);
            this.authentication = authentication;
            this.octaneHttpClient = octaneHttpClient;
        }

        public Builder Server(String domain, int port) {
            this.urlDomain = domain + ":" + port;
            return this;
        }

        public Builder Server(String domain) {
            this.urlDomain = domain;
            return this;
        }

        public SiteAdmin build() {
            SiteAdmin objOctane = null;
            this.logger.info("Building SiteAdmin Octane context using {}", (Object)this);
            OctaneHttpClient octaneHttpClient = this.octaneHttpClient = this.octaneHttpClient == null ? new GoogleHttpClient(this.urlDomain, this.authentication) : this.octaneHttpClient;
            if (this.octaneHttpClient.authenticate()) {
                objOctane = this.getSiteAdmin();
            }
            return objOctane;
        }

        protected SiteAdmin getSiteAdmin() {
            return new SiteAdmin(this.octaneHttpClient, this.urlDomain);
        }

        public String toString() {
            return String.format("Server: %s Admin", this.urlDomain);
        }
    }
}

