/*
 * Decompiled with CFR 0.152.
 */
package com.hpe.adm.nga.sdk;

import com.hpe.adm.nga.sdk.attachments.AttachmentList;
import com.hpe.adm.nga.sdk.authentication.Authentication;
import com.hpe.adm.nga.sdk.classfactory.OctaneClassFactory;
import com.hpe.adm.nga.sdk.entities.EntityList;
import com.hpe.adm.nga.sdk.entities.TypedEntityList;
import com.hpe.adm.nga.sdk.metadata.Metadata;
import com.hpe.adm.nga.sdk.network.OctaneHttpClient;
import com.hpe.adm.nga.sdk.network.google.GoogleHttpClient;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Octane {
    private static final String SHARED_SPACES_DOMAIN_FORMAT = "%s/api/shared_spaces";
    private static final String ID_FORMAT = "%s/%s";
    private static final String WORKSPACES_DOMAIN_FORMAT = "%s/workspaces";
    private static final Logger logger = LoggerFactory.getLogger((String)Octane.class.getName());
    public static final long NO_WORKSPACE_ID = Long.MIN_VALUE;
    public static final String NO_ENTITY = "";
    private static final long ONLY_SHAREDSPACE_WORKSPACE_ID = 0L;
    private final String urlDomain;
    private final String idsharedSpaceId;
    private final long workSpaceId;
    private final OctaneInternalConfiguration octaneInternalConfiguration;
    private static final OctaneCustomSettings defaultOctaneSettings = new OctaneCustomSettings();

    private Octane(OctaneInternalConfiguration octaneInternalConfiguration, String domain, String sharedSpaceId, long workId) {
        this.octaneInternalConfiguration = octaneInternalConfiguration;
        this.urlDomain = domain;
        this.idsharedSpaceId = sharedSpaceId;
        this.workSpaceId = workId;
        logger.info("Setting context to: domain=" + this.urlDomain + "; spaceid=" + this.idsharedSpaceId + "; workspaceid=" + this.workSpaceId);
    }

    private Octane(OctaneInternalConfiguration octaneInternalConfiguration, String domain, String sharedSpaceId) {
        this(octaneInternalConfiguration, domain, sharedSpaceId, 0L);
    }

    private Octane(OctaneInternalConfiguration octaneInternalConfiguration, String domain) {
        this(octaneInternalConfiguration, domain, (String)null);
    }

    public EntityList entityList(String entityName) {
        return OctaneClassFactory.getImplementation(this.octaneInternalConfiguration.octaneClassFactoryClassName).getEntityList(this.octaneInternalConfiguration.octaneHttpClient, this.getBaseDomainFormat(), entityName);
    }

    public <T extends TypedEntityList> T entityList(Class<T> entityListClass) {
        return OctaneClassFactory.getImplementation(this.octaneInternalConfiguration.octaneClassFactoryClassName).getEntityList(this.octaneInternalConfiguration.octaneHttpClient, this.getBaseDomainFormat(), entityListClass);
    }

    public Metadata metadata() {
        return new Metadata(this.octaneInternalConfiguration.octaneHttpClient, this.getBaseDomainFormat());
    }

    public AttachmentList attachmentList() {
        return new AttachmentList(this.octaneInternalConfiguration, this.getBaseDomainFormat());
    }

    private String getBaseDomainFormat() {
        String baseDomain = String.format(SHARED_SPACES_DOMAIN_FORMAT, this.urlDomain);
        if (this.idsharedSpaceId != null && !this.idsharedSpaceId.isEmpty()) {
            baseDomain = String.format(ID_FORMAT, baseDomain, this.idsharedSpaceId);
            if (this.workSpaceId == Long.MIN_VALUE) {
                baseDomain = String.format(WORKSPACES_DOMAIN_FORMAT, baseDomain);
            } else if (this.workSpaceId != 0L) {
                baseDomain = String.format(ID_FORMAT, String.format(WORKSPACES_DOMAIN_FORMAT, baseDomain), this.workSpaceId);
            }
            baseDomain = baseDomain.concat("/");
        }
        return baseDomain;
    }

    public void signOut() {
        this.octaneInternalConfiguration.octaneHttpClient.signOut();
    }

    public static class OctaneCustomSettings {
        private final Map<Setting, Object> settings = new HashMap<Setting, Object>();

        public OctaneCustomSettings() {
            this.settings.put(Setting.READ_TIMEOUT, 60000);
            this.settings.put(Setting.CONNECTION_TIMEOUT, 10000);
            this.settings.put(Setting.TRUST_ALL_CERTS, false);
            this.settings.put(Setting.SHARED_HTTP_TRANSPORT, null);
        }

        public void set(Setting setting, Object value) {
            this.settings.put(setting, value);
        }

        public Object get(Setting setting) {
            return this.settings.get((Object)setting);
        }

        public static enum Setting {
            READ_TIMEOUT,
            CONNECTION_TIMEOUT,
            TRUST_ALL_CERTS,
            SHARED_HTTP_TRANSPORT;

        }
    }

    public static final class OctaneInternalConfiguration {
        private OctaneHttpClient octaneHttpClient;
        private String octaneClassFactoryClassName;

        public OctaneHttpClient getOctaneHttpClient() {
            return this.octaneHttpClient;
        }

        public String getOctaneClassFactoryClassName() {
            return this.octaneClassFactoryClassName;
        }
    }

    public static class Builder {
        private final Logger logger = LoggerFactory.getLogger((String)Octane.class.getName());
        private String urlDomain = "";
        private String idsharedSpaceId = null;
        private long workSpaceId = 0L;
        private OctaneHttpClient octaneHttpClient;
        private final Authentication authentication;
        private String octaneClassFactoryClassName;
        private OctaneCustomSettings customSettings;

        public Builder(Authentication authentication) {
            assert (authentication != null);
            this.authentication = authentication;
        }

        public Builder(Authentication authentication, OctaneHttpClient octaneHttpClient) {
            assert (authentication != null);
            assert (octaneHttpClient != null);
            this.authentication = authentication;
            this.octaneHttpClient = octaneHttpClient;
        }

        public Builder sharedSpace(UUID ssID) {
            this.idsharedSpaceId = ssID.toString();
            return this;
        }

        public Builder sharedSpace(long ssID) {
            this.idsharedSpaceId = String.valueOf(ssID);
            return this;
        }

        public Builder workSpace(long lId) {
            this.workSpaceId = lId;
            return this;
        }

        public Builder Server(String domain, int port) {
            this.urlDomain = domain + ":" + port;
            return this;
        }

        public Builder Server(String domain) {
            this.urlDomain = domain;
            return this;
        }

        public Builder OctaneClassFactoryClassName(String octaneClassFactoryClassName) {
            this.octaneClassFactoryClassName = octaneClassFactoryClassName;
            return this;
        }

        public Builder OctaneHttpClient(OctaneHttpClient octaneHttpClient) {
            this.octaneHttpClient = octaneHttpClient;
            return this;
        }

        public Builder settings(OctaneCustomSettings settings) {
            this.customSettings = settings;
            return this;
        }

        public Octane build() {
            Octane objOctane = null;
            this.logger.info("Building Octane context using {}", (Object)this);
            OctaneInternalConfiguration octaneInternalConfiguration = new OctaneInternalConfiguration();
            OctaneCustomSettings settings = this.customSettings != null ? this.customSettings : defaultOctaneSettings;
            octaneInternalConfiguration.octaneHttpClient = this.octaneHttpClient == null ? new GoogleHttpClient(this.urlDomain, this.authentication, settings) : this.octaneHttpClient;
            octaneInternalConfiguration.octaneClassFactoryClassName = this.octaneClassFactoryClassName;
            if (octaneInternalConfiguration.octaneHttpClient.authenticate()) {
                objOctane = this.idsharedSpaceId == null ? new Octane(octaneInternalConfiguration, this.urlDomain) : new Octane(octaneInternalConfiguration, this.urlDomain, this.idsharedSpaceId, this.workSpaceId);
            }
            return objOctane;
        }

        public String toString() {
            return String.format("Server: %s SharedSpace: %s Workspace: %s", this.urlDomain, this.idsharedSpaceId, this.workSpaceId);
        }
    }
}

