/*
 * © Copyright 2016-2021 Micro Focus or one of its affiliates.
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.hpe.adm.nga.sdk.model;

/**
 *
 * This class hold the StringFieldModel objects and serve as a string type FieldModel data holder 
 *
 *
 */
public class StringFieldModel implements FieldModel<String> {
	
	//Private 
	private String name="";
	private String value="";
	
	/**
	 * Creates a new StringFieldModel object
	 * 
	 * @param newName - Field name
	 * @param newValue - Field Value
	 */
	public StringFieldModel(String newName,String newValue){
		
		setValue(newName,newValue);
	}
	
	/**
	 * get value
	 */
	public String getValue()	{
		return value;
	}

    /**
	 * get name
	 */
	public String getName(){
		return name;
	}
	
	/**
	 * set value - name/value
	 */
	public void setValue(String newName,String newValue){
		
		name = newName;
		value = newValue;
	}
}
