/*
 * Decompiled with CFR 0.152.
 */
package com.michaelvescovo.android.utils.network;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.design.R;
import android.support.design.widget.Snackbar;
import android.view.View;
import android.widget.TextView;

public class NetworkReceiver
extends BroadcastReceiver {
    private Activity mActivity;
    private String mSnackbarMessage;
    private int mSnackbarBgColour;
    private int mSnackbarTextColour;
    public boolean networkConnected;
    private Snackbar mSnackbar;

    public NetworkReceiver(Activity activity, String snackbarMessage, int snackbarBgColour, int snackbarTextColour) {
        this.mActivity = activity;
        this.mSnackbarMessage = snackbarMessage;
        this.mSnackbarBgColour = snackbarBgColour;
        this.mSnackbarTextColour = snackbarTextColour;
        IntentFilter filter = new IntentFilter("android.net.conn.CONNECTIVITY_CHANGE");
        activity.registerReceiver((BroadcastReceiver)this, filter);
        this.checkConnected();
    }

    private void checkConnected() {
        ConnectivityManager cm = (ConnectivityManager)this.mActivity.getSystemService("connectivity");
        NetworkInfo activeNetwork = cm.getActiveNetworkInfo();
        this.networkConnected = activeNetwork != null && activeNetwork.isConnectedOrConnecting();
        this.mSnackbar = this.networkSnackbar(this.networkConnected, this.mSnackbar, this.mActivity.findViewById(0x1020002));
    }

    public void onReceive(Context context, Intent intent) {
        this.checkConnected();
    }

    public void resume() {
        this.checkConnected();
    }

    public void destroy() {
        this.mActivity.unregisterReceiver((BroadcastReceiver)this);
    }

    private Snackbar networkSnackbar(boolean isConnected, Snackbar snackbar, View view) {
        if (isConnected) {
            if (snackbar != null) {
                snackbar.dismiss();
            }
        } else {
            snackbar = Snackbar.make((View)view, (CharSequence)this.mSnackbarMessage, (int)-2);
            snackbar.getView().setBackgroundColor(this.mSnackbarBgColour);
            TextView textView = (TextView)snackbar.getView().findViewById(R.id.snackbar_text);
            textView.setTextColor(this.mSnackbarTextColour);
            snackbar.show();
        }
        return snackbar;
    }
}

