/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.net;

import org.apache.http.HeaderElement;
import org.apache.http.HttpResponse;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.message.BasicHeaderElementIterator;
import org.apache.http.protocol.HttpContext;

public class KeepAliveStrategy
implements ConnectionKeepAliveStrategy {
    private static final int DEFAULT_KEEP_ALIVE_TIMEOUT_MS = 10000;
    private static final String KEEP_ALIVE_TIMEOUT_PARAM_NAME = "timeout";

    public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
        BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
        while (it.hasNext()) {
            HeaderElement he = it.nextElement();
            String param = he.getName();
            String value = he.getValue();
            if (value == null || !param.equalsIgnoreCase(KEEP_ALIVE_TIMEOUT_PARAM_NAME)) continue;
            return Long.parseLong(value) * 1000L;
        }
        return 10000L;
    }
}

