/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.core;

import java.util.Map;

public class MPRequestOptions {
    private String accessToken;
    private int connectionTimeout;
    private int connectionRequestTimeout;
    private int socketTimeout;
    private Map<String, String> customHeaders;

    public static MPRequestOptions createDefault() {
        return MPRequestOptions.builder().build();
    }

    MPRequestOptions(String accessToken, int connectionTimeout, int connectionRequestTimeout, int socketTimeout, Map<String, String> customHeaders) {
        this.accessToken = accessToken;
        this.connectionTimeout = connectionTimeout;
        this.connectionRequestTimeout = connectionRequestTimeout;
        this.socketTimeout = socketTimeout;
        this.customHeaders = customHeaders;
    }

    public static MPRequestOptionsBuilder builder() {
        return new MPRequestOptionsBuilder();
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public int getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public int getConnectionRequestTimeout() {
        return this.connectionRequestTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public Map<String, String> getCustomHeaders() {
        return this.customHeaders;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setConnectionTimeout(int connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public void setConnectionRequestTimeout(int connectionRequestTimeout) {
        this.connectionRequestTimeout = connectionRequestTimeout;
    }

    public void setSocketTimeout(int socketTimeout) {
        this.socketTimeout = socketTimeout;
    }

    public void setCustomHeaders(Map<String, String> customHeaders) {
        this.customHeaders = customHeaders;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MPRequestOptions)) {
            return false;
        }
        MPRequestOptions other = (MPRequestOptions)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getConnectionTimeout() != other.getConnectionTimeout()) {
            return false;
        }
        if (this.getConnectionRequestTimeout() != other.getConnectionRequestTimeout()) {
            return false;
        }
        if (this.getSocketTimeout() != other.getSocketTimeout()) {
            return false;
        }
        String this$accessToken = this.getAccessToken();
        String other$accessToken = other.getAccessToken();
        if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
            return false;
        }
        Map<String, String> this$customHeaders = this.getCustomHeaders();
        Map<String, String> other$customHeaders = other.getCustomHeaders();
        return !(this$customHeaders == null ? other$customHeaders != null : !((Object)this$customHeaders).equals(other$customHeaders));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MPRequestOptions;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getConnectionTimeout();
        result = result * 59 + this.getConnectionRequestTimeout();
        result = result * 59 + this.getSocketTimeout();
        String $accessToken = this.getAccessToken();
        result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
        Map<String, String> $customHeaders = this.getCustomHeaders();
        result = result * 59 + ($customHeaders == null ? 43 : ((Object)$customHeaders).hashCode());
        return result;
    }

    public String toString() {
        return "MPRequestOptions(accessToken=" + this.getAccessToken() + ", connectionTimeout=" + this.getConnectionTimeout() + ", connectionRequestTimeout=" + this.getConnectionRequestTimeout() + ", socketTimeout=" + this.getSocketTimeout() + ", customHeaders=" + this.getCustomHeaders() + ")";
    }

    public static class MPRequestOptionsBuilder {
        private String accessToken;
        private int connectionTimeout;
        private int connectionRequestTimeout;
        private int socketTimeout;
        private Map<String, String> customHeaders;

        MPRequestOptionsBuilder() {
        }

        public MPRequestOptionsBuilder accessToken(String accessToken) {
            this.accessToken = accessToken;
            return this;
        }

        public MPRequestOptionsBuilder connectionTimeout(int connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public MPRequestOptionsBuilder connectionRequestTimeout(int connectionRequestTimeout) {
            this.connectionRequestTimeout = connectionRequestTimeout;
            return this;
        }

        public MPRequestOptionsBuilder socketTimeout(int socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public MPRequestOptionsBuilder customHeaders(Map<String, String> customHeaders) {
            this.customHeaders = customHeaders;
            return this;
        }

        public MPRequestOptions build() {
            return new MPRequestOptions(this.accessToken, this.connectionTimeout, this.connectionRequestTimeout, this.socketTimeout, this.customHeaders);
        }

        public String toString() {
            return "MPRequestOptions.MPRequestOptionsBuilder(accessToken=" + this.accessToken + ", connectionTimeout=" + this.connectionTimeout + ", connectionRequestTimeout=" + this.connectionRequestTimeout + ", socketTimeout=" + this.socketTimeout + ", customHeaders=" + this.customHeaders + ")";
        }
    }
}

