/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.preference;

import com.mercadopago.client.common.IdentificationRequest;

public class PreferencePassengerRequest {
    private final String firstName;
    private final String lastName;
    private final IdentificationRequest identification;

    PreferencePassengerRequest(String firstName, String lastName, IdentificationRequest identification) {
        this.firstName = firstName;
        this.lastName = lastName;
        this.identification = identification;
    }

    public static PreferencePassengerRequestBuilder builder() {
        return new PreferencePassengerRequestBuilder();
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getLastName() {
        return this.lastName;
    }

    public IdentificationRequest getIdentification() {
        return this.identification;
    }

    public static class PreferencePassengerRequestBuilder {
        private String firstName;
        private String lastName;
        private IdentificationRequest identification;

        PreferencePassengerRequestBuilder() {
        }

        public PreferencePassengerRequestBuilder firstName(String firstName) {
            this.firstName = firstName;
            return this;
        }

        public PreferencePassengerRequestBuilder lastName(String lastName) {
            this.lastName = lastName;
            return this;
        }

        public PreferencePassengerRequestBuilder identification(IdentificationRequest identification) {
            this.identification = identification;
            return this;
        }

        public PreferencePassengerRequest build() {
            return new PreferencePassengerRequest(this.firstName, this.lastName, this.identification);
        }

        public String toString() {
            return "PreferencePassengerRequest.PreferencePassengerRequestBuilder(firstName=" + this.firstName + ", lastName=" + this.lastName + ", identification=" + this.identification + ")";
        }
    }
}

