/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.point;

import com.mercadopago.MercadoPagoConfig;
import com.mercadopago.client.MercadoPagoClient;
import com.mercadopago.client.point.PointDeviceOperatingModeRequest;
import com.mercadopago.client.point.PointPaymentIntentListRequest;
import com.mercadopago.client.point.PointPaymentIntentRequest;
import com.mercadopago.core.MPRequestOptions;
import com.mercadopago.exceptions.MPApiException;
import com.mercadopago.exceptions.MPException;
import com.mercadopago.net.HttpMethod;
import com.mercadopago.net.MPHttpClient;
import com.mercadopago.net.MPRequest;
import com.mercadopago.net.MPResponse;
import com.mercadopago.net.MPSearchRequest;
import com.mercadopago.resources.point.PointCancelPaymentIntent;
import com.mercadopago.resources.point.PointDeviceOperatingMode;
import com.mercadopago.resources.point.PointDevices;
import com.mercadopago.resources.point.PointPaymentIntent;
import com.mercadopago.resources.point.PointPaymentIntentList;
import com.mercadopago.resources.point.PointSearchPaymentIntent;
import com.mercadopago.resources.point.PointStatusPaymentIntent;
import com.mercadopago.serialization.Serializer;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public class PointClient
extends MercadoPagoClient {
    private static final Logger LOGGER = Logger.getLogger(PointClient.class.getName());
    private static final String PAYMENT_INTENT_URL = "/point/integration-api/devices/%s/payment-intents";
    private static final String PAYMENT_INTENT_LIST_URL = "/point/integration-api/payment-intents/events";
    private static final String PAYMENT_INTENT_DELETE_URL = "point/integration-api/devices/%s/payment-intents/%s";
    private static final String PAYMENT_INTENT_SEARCH_URL = "point/integration-api/payment-intents/%s";
    private static final String PAYMENT_INTENT_STATUS_URL = "point/integration-api/payment-intents/%s/events";
    private static final String DEVICES_URL = "point/integration-api/devices";
    private static final String DEVICE_WITH_ID_URL = "point/integration-api/devices/%s";

    public PointClient() {
        this(MercadoPagoConfig.getHttpClient());
    }

    public PointClient(MPHttpClient httpClient) {
        super(httpClient);
        StreamHandler streamHandler = MercadoPagoConfig.getStreamHandler();
        streamHandler.setLevel(MercadoPagoConfig.getLoggingLevel());
        LOGGER.addHandler(streamHandler);
        LOGGER.setLevel(MercadoPagoConfig.getLoggingLevel());
    }

    public PointPaymentIntent createPaymentIntent(String deviceId, PointPaymentIntentRequest request) throws MPException, MPApiException {
        return this.createPaymentIntent(deviceId, request, null);
    }

    public PointPaymentIntent createPaymentIntent(String deviceId, PointPaymentIntentRequest request, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending create point payment intent request");
        MPRequest mpRequest = MPRequest.builder().uri(String.format(PAYMENT_INTENT_URL, deviceId)).method(HttpMethod.POST).payload(Serializer.serializeToJson(request)).build();
        MPResponse response = this.send(mpRequest, requestOptions);
        PointPaymentIntent result = Serializer.deserializeFromJson(PointPaymentIntent.class, response.getContent());
        result.setResponse(response);
        return result;
    }

    public PointPaymentIntentList getPaymentIntentList(PointPaymentIntentListRequest request) throws MPException, MPApiException {
        return this.getPaymentIntentList(request, null);
    }

    public PointPaymentIntentList getPaymentIntentList(PointPaymentIntentListRequest request, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending get point payment intent list request");
        MPRequest mpRequest = MPRequest.builder().uri(PAYMENT_INTENT_LIST_URL).method(HttpMethod.GET).queryParams(request.getParams()).build();
        MPResponse response = this.send(mpRequest, requestOptions);
        PointPaymentIntentList result = Serializer.deserializeFromJson(PointPaymentIntentList.class, response.getContent());
        result.setResponse(response);
        return result;
    }

    public PointCancelPaymentIntent cancelPaymentIntent(String deviceId, String paymentIntentId) throws MPException, MPApiException {
        return this.cancelPaymentIntent(deviceId, paymentIntentId, null);
    }

    public PointCancelPaymentIntent cancelPaymentIntent(String deviceId, String paymentIntentId, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending cancel point payment intent request");
        MPRequest mpRequest = MPRequest.builder().uri(String.format(PAYMENT_INTENT_DELETE_URL, deviceId, paymentIntentId)).method(HttpMethod.DELETE).build();
        MPResponse response = this.send(mpRequest, requestOptions);
        PointCancelPaymentIntent result = Serializer.deserializeFromJson(PointCancelPaymentIntent.class, response.getContent());
        result.setResponse(response);
        return result;
    }

    public PointSearchPaymentIntent searchPaymentIntent(String paymentIntentId) throws MPException, MPApiException {
        return this.searchPaymentIntent(paymentIntentId, null);
    }

    public PointSearchPaymentIntent searchPaymentIntent(String paymentIntentId, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending search point payment intent request");
        MPRequest mpRequest = MPRequest.builder().uri(String.format(PAYMENT_INTENT_SEARCH_URL, paymentIntentId)).method(HttpMethod.GET).build();
        MPResponse response = this.send(mpRequest, requestOptions);
        PointSearchPaymentIntent result = Serializer.deserializeFromJson(PointSearchPaymentIntent.class, response.getContent());
        result.setResponse(response);
        return result;
    }

    public PointStatusPaymentIntent getPaymentIntentStatus(String paymentIntentId) throws MPException, MPApiException {
        return this.getPaymentIntentStatus(paymentIntentId, null);
    }

    public PointStatusPaymentIntent getPaymentIntentStatus(String paymentIntentId, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending get point payment intent status request");
        MPRequest mpRequest = MPRequest.builder().uri(String.format(PAYMENT_INTENT_STATUS_URL, paymentIntentId)).method(HttpMethod.GET).build();
        MPResponse response = this.send(mpRequest, requestOptions);
        PointStatusPaymentIntent result = Serializer.deserializeFromJson(PointStatusPaymentIntent.class, response.getContent());
        result.setResponse(response);
        return result;
    }

    public PointDevices getDevices(MPSearchRequest request) throws MPException, MPApiException {
        return this.getDevices(request, null);
    }

    public PointDevices getDevices(MPSearchRequest request, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending get point devices request");
        MPRequest mpRequest = MPRequest.builder().uri(DEVICES_URL).method(HttpMethod.GET).queryParams(request.getParameters()).build();
        MPResponse response = this.send(mpRequest, requestOptions);
        PointDevices result = Serializer.deserializeFromJson(PointDevices.class, response.getContent());
        result.setResponse(response);
        return result;
    }

    public PointDeviceOperatingMode changeDeviceOperatingMode(String deviceId, PointDeviceOperatingModeRequest request) throws MPException, MPApiException {
        return this.changeDeviceOperatingMode(deviceId, request, null);
    }

    public PointDeviceOperatingMode changeDeviceOperatingMode(String deviceId, PointDeviceOperatingModeRequest request, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending change point device operating mode request");
        MPRequest mpRequest = MPRequest.builder().uri(String.format(DEVICE_WITH_ID_URL, deviceId)).method(HttpMethod.PATCH).payload(Serializer.serializeToJson(request)).build();
        MPResponse response = this.send(mpRequest, requestOptions);
        PointDeviceOperatingMode result = Serializer.deserializeFromJson(PointDeviceOperatingMode.class, response.getContent());
        result.setResponse(response);
        return result;
    }
}

