/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.paymentmethod;

import com.mercadopago.MercadoPagoConfig;
import com.mercadopago.client.MercadoPagoClient;
import com.mercadopago.core.MPRequestOptions;
import com.mercadopago.exceptions.MPApiException;
import com.mercadopago.exceptions.MPException;
import com.mercadopago.net.HttpMethod;
import com.mercadopago.net.MPHttpClient;
import com.mercadopago.net.MPResourceList;
import com.mercadopago.net.MPResponse;
import com.mercadopago.resources.paymentmethod.PaymentMethod;
import com.mercadopago.serialization.Serializer;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public class PaymentMethodClient
extends MercadoPagoClient {
    private static final Logger LOGGER = Logger.getLogger(PaymentMethodClient.class.getName());

    public PaymentMethodClient() {
        this(MercadoPagoConfig.getHttpClient());
    }

    public PaymentMethodClient(MPHttpClient httpClient) {
        super(httpClient);
        StreamHandler streamHandler = MercadoPagoConfig.getStreamHandler();
        streamHandler.setLevel(MercadoPagoConfig.getLoggingLevel());
        LOGGER.addHandler(streamHandler);
        LOGGER.setLevel(MercadoPagoConfig.getLoggingLevel());
    }

    public MPResourceList<PaymentMethod> list() throws MPException, MPApiException {
        return this.list(null);
    }

    public MPResourceList<PaymentMethod> list(MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending list payment method");
        MPResponse response = this.list("/v1/payment_methods", HttpMethod.GET, null, null, requestOptions);
        MPResourceList<PaymentMethod> paymentMethods = Serializer.deserializeListFromJson(PaymentMethod.class, response.getContent());
        paymentMethods.setResponse(response);
        return paymentMethods;
    }
}

