/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.payment;

import java.math.BigDecimal;

public class PaymentTaxRequest {
    private final String type;
    private final BigDecimal value;
    private final Boolean percentage;

    PaymentTaxRequest(String type, BigDecimal value, Boolean percentage) {
        this.type = type;
        this.value = value;
        this.percentage = percentage;
    }

    public static PaymentTaxRequestBuilder builder() {
        return new PaymentTaxRequestBuilder();
    }

    public String getType() {
        return this.type;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public Boolean getPercentage() {
        return this.percentage;
    }

    public static class PaymentTaxRequestBuilder {
        private String type;
        private BigDecimal value;
        private Boolean percentage;

        PaymentTaxRequestBuilder() {
        }

        public PaymentTaxRequestBuilder type(String type) {
            this.type = type;
            return this;
        }

        public PaymentTaxRequestBuilder value(BigDecimal value) {
            this.value = value;
            return this;
        }

        public PaymentTaxRequestBuilder percentage(Boolean percentage) {
            this.percentage = percentage;
            return this;
        }

        public PaymentTaxRequest build() {
            return new PaymentTaxRequest(this.type, this.value, this.percentage);
        }

        public String toString() {
            return "PaymentTaxRequest.PaymentTaxRequestBuilder(type=" + this.type + ", value=" + this.value + ", percentage=" + this.percentage + ")";
        }
    }
}

