/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.payment;

import java.time.OffsetDateTime;

public class PaymentRouteRequest {
    private final String departure;
    private final String destination;
    private final OffsetDateTime departureDateTime;
    private final OffsetDateTime arrivalDateTime;
    private final String company;

    PaymentRouteRequest(String departure, String destination, OffsetDateTime departureDateTime, OffsetDateTime arrivalDateTime, String company) {
        this.departure = departure;
        this.destination = destination;
        this.departureDateTime = departureDateTime;
        this.arrivalDateTime = arrivalDateTime;
        this.company = company;
    }

    public static PaymentRouteRequestBuilder builder() {
        return new PaymentRouteRequestBuilder();
    }

    public String getDeparture() {
        return this.departure;
    }

    public String getDestination() {
        return this.destination;
    }

    public OffsetDateTime getDepartureDateTime() {
        return this.departureDateTime;
    }

    public OffsetDateTime getArrivalDateTime() {
        return this.arrivalDateTime;
    }

    public String getCompany() {
        return this.company;
    }

    public static class PaymentRouteRequestBuilder {
        private String departure;
        private String destination;
        private OffsetDateTime departureDateTime;
        private OffsetDateTime arrivalDateTime;
        private String company;

        PaymentRouteRequestBuilder() {
        }

        public PaymentRouteRequestBuilder departure(String departure) {
            this.departure = departure;
            return this;
        }

        public PaymentRouteRequestBuilder destination(String destination) {
            this.destination = destination;
            return this;
        }

        public PaymentRouteRequestBuilder departureDateTime(OffsetDateTime departureDateTime) {
            this.departureDateTime = departureDateTime;
            return this;
        }

        public PaymentRouteRequestBuilder arrivalDateTime(OffsetDateTime arrivalDateTime) {
            this.arrivalDateTime = arrivalDateTime;
            return this;
        }

        public PaymentRouteRequestBuilder company(String company) {
            this.company = company;
            return this;
        }

        public PaymentRouteRequest build() {
            return new PaymentRouteRequest(this.departure, this.destination, this.departureDateTime, this.arrivalDateTime, this.company);
        }

        public String toString() {
            return "PaymentRouteRequest.PaymentRouteRequestBuilder(departure=" + this.departure + ", destination=" + this.destination + ", departureDateTime=" + this.departureDateTime + ", arrivalDateTime=" + this.arrivalDateTime + ", company=" + this.company + ")";
        }
    }
}

