/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.payment;

import java.math.BigDecimal;
import java.time.LocalDate;

public class PaymentDiscountRequest {
    private String type;
    private BigDecimal value;
    private LocalDate limitDate;

    PaymentDiscountRequest(String type, BigDecimal value, LocalDate limitDate) {
        this.type = type;
        this.value = value;
        this.limitDate = limitDate;
    }

    public static PaymentDiscountRequestBuilder builder() {
        return new PaymentDiscountRequestBuilder();
    }

    public String getType() {
        return this.type;
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public LocalDate getLimitDate() {
        return this.limitDate;
    }

    public static class PaymentDiscountRequestBuilder {
        private String type;
        private BigDecimal value;
        private LocalDate limitDate;

        PaymentDiscountRequestBuilder() {
        }

        public PaymentDiscountRequestBuilder type(String type) {
            this.type = type;
            return this;
        }

        public PaymentDiscountRequestBuilder value(BigDecimal value) {
            this.value = value;
            return this;
        }

        public PaymentDiscountRequestBuilder limitDate(LocalDate limitDate) {
            this.limitDate = limitDate;
            return this;
        }

        public PaymentDiscountRequest build() {
            return new PaymentDiscountRequest(this.type, this.value, this.limitDate);
        }

        public String toString() {
            return "PaymentDiscountRequest.PaymentDiscountRequestBuilder(type=" + this.type + ", value=" + this.value + ", limitDate=" + this.limitDate + ")";
        }
    }
}

