/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.merchantorder;

import com.google.gson.reflect.TypeToken;
import com.mercadopago.MercadoPagoConfig;
import com.mercadopago.client.MercadoPagoClient;
import com.mercadopago.client.merchantorder.MerchantOrderCreateRequest;
import com.mercadopago.client.merchantorder.MerchantOrderUpdateRequest;
import com.mercadopago.core.MPRequestOptions;
import com.mercadopago.exceptions.MPApiException;
import com.mercadopago.exceptions.MPException;
import com.mercadopago.net.HttpMethod;
import com.mercadopago.net.MPElementsResourcesPage;
import com.mercadopago.net.MPHttpClient;
import com.mercadopago.net.MPRequest;
import com.mercadopago.net.MPResponse;
import com.mercadopago.net.MPSearchRequest;
import com.mercadopago.resources.merchantorder.MerchantOrder;
import com.mercadopago.serialization.Serializer;
import java.lang.reflect.Type;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public class MerchantOrderClient
extends MercadoPagoClient {
    private static final Logger LOGGER = Logger.getLogger(MerchantOrderClient.class.getName());
    private static final String URL_WITH_ID = "/merchant_orders/%s";

    public MerchantOrderClient() {
        this(MercadoPagoConfig.getHttpClient());
    }

    public MerchantOrderClient(MPHttpClient httpClient) {
        super(httpClient);
        StreamHandler streamHandler = MercadoPagoConfig.getStreamHandler();
        streamHandler.setLevel(MercadoPagoConfig.getLoggingLevel());
        LOGGER.addHandler(streamHandler);
        LOGGER.setLevel(MercadoPagoConfig.getLoggingLevel());
    }

    public MerchantOrder get(Long id) throws MPException, MPApiException {
        return this.get(id, null);
    }

    public MerchantOrder get(Long id, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending get merchant order request");
        MPRequest mpRequest = MPRequest.builder().uri(String.format(URL_WITH_ID, id.toString())).method(HttpMethod.GET).build();
        MPResponse response = this.send(mpRequest, requestOptions);
        MerchantOrder result = Serializer.deserializeFromJson(MerchantOrder.class, response.getContent());
        result.setResponse(response);
        return result;
    }

    public MerchantOrder create(MerchantOrderCreateRequest request) throws MPException, MPApiException {
        return this.create(request, null);
    }

    public MerchantOrder create(MerchantOrderCreateRequest request, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending create merchant order request");
        MPRequest mpRequest = MPRequest.builder().uri("/merchant_orders").method(HttpMethod.POST).payload(Serializer.serializeToJson(request)).build();
        MPResponse response = this.send(mpRequest, requestOptions);
        MerchantOrder result = Serializer.deserializeFromJson(MerchantOrder.class, response.getContent());
        result.setResponse(response);
        return result;
    }

    public MerchantOrder update(Long id, MerchantOrderUpdateRequest request) throws MPException, MPApiException {
        return this.update(id, request, null);
    }

    public MerchantOrder update(Long id, MerchantOrderUpdateRequest request, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending update merchant order request");
        MPRequest mpRequest = MPRequest.builder().uri(String.format(URL_WITH_ID, id.toString())).method(HttpMethod.PUT).payload(Serializer.serializeToJson(request)).build();
        MPResponse response = this.send(mpRequest, requestOptions);
        MerchantOrder result = Serializer.deserializeFromJson(MerchantOrder.class, response.getContent());
        result.setResponse(response);
        return result;
    }

    public MPElementsResourcesPage<MerchantOrder> search(MPSearchRequest request) throws MPException, MPApiException {
        return this.search(request, null);
    }

    public MPElementsResourcesPage<MerchantOrder> search(MPSearchRequest request, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending search merchant order request");
        MPResponse response = this.search("/merchant_orders/search", request, requestOptions);
        Type responseType = new TypeToken<MPElementsResourcesPage<MerchantOrder>>(){}.getType();
        MPElementsResourcesPage<MerchantOrder> result = Serializer.deserializeElementsResourcesPageFromJson(responseType, response.getContent());
        result.setResponse(response);
        return result;
    }
}

