/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.cardtoken;

import com.mercadopago.MercadoPagoConfig;
import com.mercadopago.client.MercadoPagoClient;
import com.mercadopago.client.cardtoken.CardTokenRequest;
import com.mercadopago.core.MPRequestOptions;
import com.mercadopago.exceptions.MPApiException;
import com.mercadopago.exceptions.MPException;
import com.mercadopago.net.HttpMethod;
import com.mercadopago.net.MPHttpClient;
import com.mercadopago.net.MPResponse;
import com.mercadopago.resources.CardToken;
import com.mercadopago.serialization.Serializer;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public class CardTokenClient
extends MercadoPagoClient {
    private static final Logger LOGGER = Logger.getLogger(CardTokenClient.class.getName());

    public CardTokenClient() {
        this(MercadoPagoConfig.getHttpClient());
    }

    public CardTokenClient(MPHttpClient httpClient) {
        super(httpClient);
        StreamHandler streamHandler = MercadoPagoConfig.getStreamHandler();
        streamHandler.setLevel(MercadoPagoConfig.getLoggingLevel());
        LOGGER.addHandler(streamHandler);
        LOGGER.setLevel(MercadoPagoConfig.getLoggingLevel());
    }

    public CardToken get(String id) throws MPException, MPApiException {
        return this.get(id, null);
    }

    public CardToken get(String id, MPRequestOptions requestOptions) throws MPException, MPApiException {
        MPResponse response = this.send(String.format("/v1/card_tokens/%s", id), HttpMethod.GET, null, null, requestOptions);
        CardToken cardToken = Serializer.deserializeFromJson(CardToken.class, response.getContent());
        cardToken.setResponse(response);
        return cardToken;
    }

    public CardToken create(CardTokenRequest request) throws MPException, MPApiException {
        return this.create(request, null);
    }

    public CardToken create(CardTokenRequest request, MPRequestOptions requestOptions) throws MPException, MPApiException {
        MPResponse response = this.send("/v1/card_tokens", HttpMethod.POST, Serializer.serializeToJson(request), null, requestOptions);
        CardToken cardToken = Serializer.deserializeFromJson(CardToken.class, response.getContent());
        cardToken.setResponse(response);
        return cardToken;
    }
}

