/*
 * Decompiled with CFR 0.152.
 */
package com.mercadopago.client.payment;

import com.mercadopago.MercadoPagoConfig;
import com.mercadopago.client.MercadoPagoClient;
import com.mercadopago.client.payment.PaymentRefundCreateRequest;
import com.mercadopago.core.MPRequestOptions;
import com.mercadopago.exceptions.MPApiException;
import com.mercadopago.exceptions.MPException;
import com.mercadopago.net.HttpMethod;
import com.mercadopago.net.MPHttpClient;
import com.mercadopago.net.MPResourceList;
import com.mercadopago.net.MPResponse;
import com.mercadopago.resources.payment.PaymentRefund;
import com.mercadopago.serialization.Serializer;
import java.math.BigDecimal;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public class PaymentRefundClient
extends MercadoPagoClient {
    private static final Logger LOGGER = Logger.getLogger(PaymentRefundClient.class.getName());
    private static final String URL_WITH_PAYMENT_ID = "/v1/payments/%s/refunds";

    public PaymentRefundClient() {
        this(MercadoPagoConfig.getHttpClient());
    }

    public PaymentRefundClient(MPHttpClient httpClient) {
        super(httpClient);
        StreamHandler streamHandler = MercadoPagoConfig.getStreamHandler();
        streamHandler.setLevel(MercadoPagoConfig.getLoggingLevel());
        LOGGER.addHandler(streamHandler);
        LOGGER.setLevel(MercadoPagoConfig.getLoggingLevel());
    }

    public PaymentRefund refund(Long paymentId) throws MPException, MPApiException {
        return this.refund(paymentId, null, null);
    }

    public PaymentRefund refund(Long paymentId, MPRequestOptions requestOptions) throws MPException, MPApiException {
        return this.refund(paymentId, null, requestOptions);
    }

    public PaymentRefund refund(Long paymentId, BigDecimal amount) throws MPException, MPApiException {
        return this.refund(paymentId, amount, null);
    }

    public PaymentRefund refund(Long paymentId, BigDecimal amount, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending refund payment request");
        PaymentRefundCreateRequest request = PaymentRefundCreateRequest.builder().amount(amount).build();
        MPResponse response = this.send(String.format(URL_WITH_PAYMENT_ID, paymentId), HttpMethod.POST, Serializer.serializeToJson(request), null, requestOptions);
        PaymentRefund result = Serializer.deserializeFromJson(PaymentRefund.class, response.getContent());
        result.setResponse(response);
        return result;
    }

    public PaymentRefund get(Long paymentId, Long refundId) throws MPException, MPApiException {
        return this.get(paymentId, refundId, null);
    }

    public PaymentRefund get(Long paymentId, Long refundId, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending get refund payment request");
        MPResponse response = this.send(String.format("/v1/payments/%s/refunds/%s", paymentId, refundId), HttpMethod.GET, null, null, requestOptions);
        PaymentRefund result = Serializer.deserializeFromJson(PaymentRefund.class, response.getContent());
        result.setResponse(response);
        return result;
    }

    public MPResourceList<PaymentRefund> list(Long paymentId) throws MPException, MPApiException {
        return this.list(paymentId, null);
    }

    public MPResourceList<PaymentRefund> list(Long paymentId, MPRequestOptions requestOptions) throws MPException, MPApiException {
        LOGGER.info("Sending list refund payment request");
        MPResponse response = this.send(String.format(URL_WITH_PAYMENT_ID, paymentId), HttpMethod.GET, null, null, requestOptions);
        MPResourceList<PaymentRefund> result = Serializer.deserializeListFromJson(PaymentRefund.class, response.getContent());
        result.setResponse(response);
        return result;
    }
}

