/*
 * Decompiled with CFR 0.152.
 */
package com.android.volley.toolbox;

import android.content.Context;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.ImageView;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.ImageLoader;

public class NetworkImageView
extends ImageView {
    private String mUrl;
    private int mDefaultImageId;
    private int mErrorImageId;
    private ImageLoader mImageLoader;
    private ImageLoader.ImageContainer mImageContainer;

    public NetworkImageView(Context context) {
        this(context, null);
    }

    public NetworkImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public NetworkImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public void setImageUrl(String url, ImageLoader imageLoader) {
        this.mUrl = url;
        this.mImageLoader = imageLoader;
        this.loadImageIfNecessary(false);
    }

    public void setDefaultImageResId(int defaultImage) {
        this.mDefaultImageId = defaultImage;
    }

    public void setErrorImageResId(int errorImage) {
        this.mErrorImageId = errorImage;
    }

    private void loadImageIfNecessary(final boolean isInLayoutPass) {
        ImageLoader.ImageContainer newContainer;
        boolean isFullyWrapContent;
        int width = this.getWidth();
        int height = this.getHeight();
        boolean bl = isFullyWrapContent = this.getLayoutParams() != null && this.getLayoutParams().height == -2 && this.getLayoutParams().width == -2;
        if (width == 0 && height == 0 && !isFullyWrapContent) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)this.mUrl)) {
            if (this.mImageContainer != null) {
                this.mImageContainer.cancelRequest();
                this.mImageContainer = null;
            }
            this.setDefaultImageOrNull();
            return;
        }
        if (this.mImageContainer != null && this.mImageContainer.getRequestUrl() != null) {
            if (this.mImageContainer.getRequestUrl().equals(this.mUrl)) {
                return;
            }
            this.mImageContainer.cancelRequest();
            this.setDefaultImageOrNull();
        }
        this.mImageContainer = newContainer = this.mImageLoader.get(this.mUrl, new ImageLoader.ImageListener(){

            @Override
            public void onErrorResponse(VolleyError error) {
                if (NetworkImageView.this.mErrorImageId != 0) {
                    NetworkImageView.this.setImageResource(NetworkImageView.this.mErrorImageId);
                }
            }

            @Override
            public void onResponse(final ImageLoader.ImageContainer response, boolean isImmediate) {
                if (isImmediate && isInLayoutPass) {
                    NetworkImageView.this.post(new Runnable(){

                        @Override
                        public void run() {
                            this.onResponse(response, false);
                        }
                    });
                    return;
                }
                if (response.getBitmap() != null) {
                    NetworkImageView.this.setImageBitmap(response.getBitmap());
                } else if (NetworkImageView.this.mDefaultImageId != 0) {
                    NetworkImageView.this.setImageResource(NetworkImageView.this.mDefaultImageId);
                }
            }
        });
    }

    private void setDefaultImageOrNull() {
        if (this.mDefaultImageId != 0) {
            this.setImageResource(this.mDefaultImageId);
        } else {
            this.setImageBitmap(null);
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.loadImageIfNecessary(true);
    }

    protected void onDetachedFromWindow() {
        if (this.mImageContainer != null) {
            this.mImageContainer.cancelRequest();
            this.setImageBitmap(null);
            this.mImageContainer = null;
        }
        super.onDetachedFromWindow();
    }

    protected void drawableStateChanged() {
        super.drawableStateChanged();
        this.invalidate();
    }
}

