/*
 * Decompiled with CFR 0.152.
 */
package com.mcxiaoke.packer.support.walle;

import com.mcxiaoke.packer.support.walle.ApkUtil;
import com.mcxiaoke.packer.support.walle.V2Utils;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Map;

final class PayloadReader {
    private PayloadReader() {
    }

    public static byte[] readBytes(File apkFile, int id) throws IOException {
        ByteBuffer buf = PayloadReader.readBlock(apkFile, id);
        return buf == null ? null : V2Utils.getBytes(buf);
    }

    public static ByteBuffer readBlock(File apkFile, int id) throws IOException {
        Map<Integer, ByteBuffer> blocks = PayloadReader.readAllBlocks(apkFile);
        if (blocks == null) {
            return null;
        }
        return blocks.get(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Integer, ByteBuffer> readAllBlocks(File apkFile) throws IOException {
        Map<Integer, ByteBuffer> blocks = null;
        RandomAccessFile raf = null;
        FileChannel fc = null;
        try {
            raf = new RandomAccessFile(apkFile, "r");
            fc = raf.getChannel();
            ByteBuffer apkSigningBlock = ApkUtil.findApkSigningBlock(fc).getFirst();
            blocks = ApkUtil.findIdValues(apkSigningBlock);
        }
        catch (Throwable throwable) {
            V2Utils.close(fc);
            V2Utils.close(raf);
            throw throwable;
        }
        V2Utils.close(fc);
        V2Utils.close(raf);
        return blocks;
    }
}

