/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.resourcepool;

import com.mchange.v2.async.AsynchronousRunner;
import com.mchange.v2.async.RunnableQueue;
import com.mchange.v2.cfg.MConfig;
import com.mchange.v2.lang.ThreadUtils;
import com.mchange.v2.log.MLevel;
import com.mchange.v2.log.MLog;
import com.mchange.v2.log.MLogger;
import com.mchange.v2.resourcepool.BasicResourcePoolFactory;
import com.mchange.v2.resourcepool.CannotAcquireResourceException;
import com.mchange.v2.resourcepool.NoGoodResourcesException;
import com.mchange.v2.resourcepool.ResourcePool;
import com.mchange.v2.resourcepool.ResourcePoolEventSupport;
import com.mchange.v2.resourcepool.ResourcePoolException;
import com.mchange.v2.resourcepool.ResourcePoolListener;
import com.mchange.v2.resourcepool.ResourcePoolUtils;
import com.mchange.v2.resourcepool.TimeoutException;
import com.mchange.v2.util.ResourceClosedException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.WeakHashMap;

class BasicResourcePool
implements ResourcePool {
    private static final MLogger logger = MLog.getLogger(BasicResourcePool.class);
    static final int AUTO_CULL_FREQUENCY_DIVISOR = 4;
    static final int AUTO_MAX_CULL_FREQUENCY = 900000;
    static final int AUTO_MIN_CULL_FREQUENCY = 1000;
    static final String USE_SCATTERED_ACQUIRE_TASK_KEY = "com.mchange.v2.resourcepool.experimental.useScatteredAcquireTask";
    static final boolean USE_SCATTERED_ACQUIRE_TASK;
    final ResourcePool.Manager mgr;
    final int start;
    final int min;
    final int max;
    final int inc;
    final int num_acq_attempts;
    final int acq_attempt_delay;
    final long check_idle_resources_delay;
    final long max_resource_age;
    final long max_idle_time;
    final long excess_max_idle_time;
    final long destroy_unreturned_resc_time;
    final long expiration_enforcement_delay;
    final boolean break_on_acquisition_failure;
    final boolean debug_store_checkout_exceptions;
    final boolean force_synchronous_checkins;
    final long pool_start_time = System.currentTimeMillis();
    final BasicResourcePoolFactory factory;
    final AsynchronousRunner taskRunner;
    final RunnableQueue asyncEventQueue;
    final ResourcePoolEventSupport rpes;
    Timer cullAndIdleRefurbishTimer;
    TimerTask cullTask;
    TimerTask idleRefurbishTask;
    HashSet acquireWaiters = new HashSet();
    HashSet otherWaiters = new HashSet();
    int pending_acquires;
    int pending_removes;
    int target_pool_size;
    HashMap managed = new HashMap();
    LinkedList unused = new LinkedList();
    HashSet excluded = new HashSet();
    Map formerResources = new WeakHashMap();
    Set idleCheckResources = new HashSet();
    boolean force_kill_acquires = false;
    boolean broken = false;
    long failed_checkins = 0L;
    long failed_checkouts = 0L;
    long failed_idle_tests = 0L;
    Throwable lastCheckinFailure = null;
    Throwable lastCheckoutFailure = null;
    Throwable lastIdleTestFailure = null;
    Throwable lastResourceTestFailure = null;
    Throwable lastAcquisitionFailiure = null;
    Object exampleResource;
    private static final int NO_DECREMENT = 0;
    private static final int DECREMENT_ON_SUCCESS = 1;
    private static final int DECREMENT_WITH_CERTAINTY = 2;

    @Override
    public long getStartTime() {
        return this.pool_start_time;
    }

    @Override
    public long getUpTime() {
        return System.currentTimeMillis() - this.pool_start_time;
    }

    @Override
    public synchronized long getNumFailedCheckins() {
        return this.failed_checkins;
    }

    @Override
    public synchronized long getNumFailedCheckouts() {
        return this.failed_checkouts;
    }

    @Override
    public synchronized long getNumFailedIdleTests() {
        return this.failed_idle_tests;
    }

    @Override
    public synchronized Throwable getLastCheckinFailure() {
        return this.lastCheckinFailure;
    }

    private void setLastCheckinFailure(Throwable throwable) {
        assert (Thread.holdsLock(this));
        this.lastCheckinFailure = throwable;
        this.lastResourceTestFailure = throwable;
    }

    @Override
    public synchronized Throwable getLastCheckoutFailure() {
        return this.lastCheckoutFailure;
    }

    private void setLastCheckoutFailure(Throwable throwable) {
        assert (Thread.holdsLock(this));
        this.lastCheckoutFailure = throwable;
        this.lastResourceTestFailure = throwable;
    }

    @Override
    public synchronized Throwable getLastIdleCheckFailure() {
        return this.lastIdleTestFailure;
    }

    private void setLastIdleCheckFailure(Throwable throwable) {
        assert (Thread.holdsLock(this));
        this.lastIdleTestFailure = throwable;
        this.lastResourceTestFailure = throwable;
    }

    @Override
    public synchronized Throwable getLastResourceTestFailure() {
        return this.lastResourceTestFailure;
    }

    @Override
    public synchronized Throwable getLastAcquisitionFailure() {
        return this.lastAcquisitionFailiure;
    }

    private synchronized void setLastAcquisitionFailure(Throwable throwable) {
        this.lastAcquisitionFailiure = throwable;
    }

    @Override
    public synchronized int getNumCheckoutWaiters() {
        return this.acquireWaiters.size();
    }

    public synchronized int getNumPendingAcquireTasks() {
        return this.pending_acquires;
    }

    public synchronized int getNumPendingRemoveTasks() {
        return this.pending_removes;
    }

    public synchronized int getNumThreadsWaitingForResources() {
        return this.acquireWaiters.size();
    }

    public synchronized String[] getThreadNamesWaitingForResources() {
        int n = this.acquireWaiters.size();
        Object[] objectArray = new String[n];
        int n2 = 0;
        Iterator iterator = this.acquireWaiters.iterator();
        while (iterator.hasNext()) {
            objectArray[n2++] = ((Thread)iterator.next()).getName();
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    public synchronized int getNumThreadsWaitingForAdministrativeTasks() {
        return this.otherWaiters.size();
    }

    public synchronized String[] getThreadNamesWaitingForAdministrativeTasks() {
        int n = this.otherWaiters.size();
        Object[] objectArray = new String[n];
        int n2 = 0;
        Iterator iterator = this.otherWaiters.iterator();
        while (iterator.hasNext()) {
            objectArray[n2++] = ((Thread)iterator.next()).getName();
        }
        Arrays.sort(objectArray);
        return objectArray;
    }

    private void addToFormerResources(Object object) {
        this.formerResources.put(object, null);
    }

    private boolean isFormerResource(Object object) {
        return this.formerResources.keySet().contains(object);
    }

    public BasicResourcePool(ResourcePool.Manager manager, int n, int n2, int n3, int n4, int n5, int n6, long l, long l2, long l3, long l4, long l5, long l6, boolean bl, boolean bl2, boolean bl3, AsynchronousRunner asynchronousRunner, RunnableQueue runnableQueue, Timer timer, BasicResourcePoolFactory basicResourcePoolFactory) throws ResourcePoolException {
        try {
            if (n2 > n3) {
                if (logger.isLoggable(MLevel.WARNING)) {
                    logger.log(MLevel.WARNING, "Bad pool size config, min " + n2 + " > max " + n3 + ". Using " + n3 + " as min.");
                }
                n2 = n3;
            }
            if (n < n2) {
                if (logger.isLoggable(MLevel.WARNING)) {
                    logger.log(MLevel.WARNING, "Bad pool size config, start " + n + " < min " + n2 + ". Using " + n2 + " as start.");
                }
                n = n2;
            }
            if (n > n3) {
                if (logger.isLoggable(MLevel.WARNING)) {
                    logger.log(MLevel.WARNING, "Bad pool size config, start " + n + " > max " + n3 + ". Using " + n3 + " as start.");
                }
                n = n3;
            }
            this.mgr = manager;
            this.start = n;
            this.min = n2;
            this.max = n3;
            this.inc = n4;
            this.num_acq_attempts = n5;
            this.acq_attempt_delay = n6;
            this.check_idle_resources_delay = l;
            this.max_resource_age = l2;
            this.max_idle_time = l3;
            this.excess_max_idle_time = l4;
            this.destroy_unreturned_resc_time = l5;
            this.break_on_acquisition_failure = bl;
            this.debug_store_checkout_exceptions = bl2 && l5 > 0L;
            this.force_synchronous_checkins = bl3;
            this.taskRunner = asynchronousRunner;
            this.asyncEventQueue = runnableQueue;
            this.cullAndIdleRefurbishTimer = timer;
            this.factory = basicResourcePoolFactory;
            this.pending_acquires = 0;
            this.pending_removes = 0;
            this.target_pool_size = this.start;
            this.rpes = runnableQueue != null ? new ResourcePoolEventSupport(this) : null;
            this.ensureStartResources();
            if (this.mustEnforceExpiration()) {
                this.expiration_enforcement_delay = l6 <= 0L ? this.automaticExpirationEnforcementDelay() : l6;
                this.cullTask = new CullTask();
                timer.schedule(this.cullTask, this.minExpirationTime(), this.expiration_enforcement_delay);
            } else {
                this.expiration_enforcement_delay = l6;
            }
            if (l > 0L) {
                this.idleRefurbishTask = new CheckIdleResourcesTask();
                timer.schedule(this.idleRefurbishTask, l, l);
            }
            if (logger.isLoggable(MLevel.FINER)) {
                logger.finer(this + " config: [start -> " + this.start + "; min -> " + this.min + "; max -> " + this.max + "; inc -> " + this.inc + "; num_acq_attempts -> " + this.num_acq_attempts + "; acq_attempt_delay -> " + this.acq_attempt_delay + "; check_idle_resources_delay -> " + this.check_idle_resources_delay + "; max_resource_age -> " + this.max_resource_age + "; max_idle_time -> " + this.max_idle_time + "; excess_max_idle_time -> " + this.excess_max_idle_time + "; destroy_unreturned_resc_time -> " + this.destroy_unreturned_resc_time + "; expiration_enforcement_delay -> " + this.expiration_enforcement_delay + "; break_on_acquisition_failure -> " + this.break_on_acquisition_failure + "; debug_store_checkout_exceptions -> " + this.debug_store_checkout_exceptions + "; force_synchronous_checkins -> " + this.force_synchronous_checkins + "]");
            }
        }
        catch (Exception exception) {
            throw ResourcePoolUtils.convertThrowable(exception);
        }
    }

    private boolean mustTestIdleResources() {
        return this.check_idle_resources_delay > 0L;
    }

    private boolean mustEnforceExpiration() {
        return this.max_resource_age > 0L || this.max_idle_time > 0L || this.excess_max_idle_time > 0L || this.destroy_unreturned_resc_time > 0L;
    }

    private long minExpirationTime() {
        long l = Long.MAX_VALUE;
        if (this.max_resource_age > 0L) {
            l = Math.min(l, this.max_resource_age);
        }
        if (this.max_idle_time > 0L) {
            l = Math.min(l, this.max_idle_time);
        }
        if (this.excess_max_idle_time > 0L) {
            l = Math.min(l, this.excess_max_idle_time);
        }
        if (this.destroy_unreturned_resc_time > 0L) {
            l = Math.min(l, this.destroy_unreturned_resc_time);
        }
        return l;
    }

    private long automaticExpirationEnforcementDelay() {
        long l = this.minExpirationTime();
        l /= 4L;
        l = Math.min(l, 900000L);
        l = Math.max(l, 1000L);
        return l;
    }

    @Override
    public long getEffectiveExpirationEnforcementDelay() {
        return this.expiration_enforcement_delay;
    }

    private synchronized boolean isBroken() {
        return this.broken;
    }

    private boolean supportsEvents() {
        return this.asyncEventQueue != null;
    }

    @Override
    public Object checkoutResource() throws ResourcePoolException, InterruptedException {
        try {
            return this.checkoutResource(0L);
        }
        catch (TimeoutException timeoutException) {
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "Huh??? TimeoutException with no timeout set!!!", (Throwable)((Object)timeoutException));
            }
            throw new ResourcePoolException("Huh??? TimeoutException with no timeout set!!!", (Throwable)((Object)timeoutException));
        }
    }

    private void _recheckResizePool() {
        assert (Thread.holdsLock(this));
        if (!this.broken) {
            int n = this.managed.size();
            int n2 = n - this.pending_removes - this.target_pool_size;
            if (n2 > 0) {
                this.shrinkPool(n2);
            } else {
                int n3 = this.target_pool_size - (n + this.pending_acquires);
                if (n3 > 0) {
                    this.expandPool(n3);
                }
            }
        }
    }

    private synchronized void incrementPendingAcquires() {
        ++this.pending_acquires;
        if (logger.isLoggable(MLevel.FINEST)) {
            logger.finest("incremented pending_acquires: " + this.pending_acquires);
        }
    }

    private synchronized void incrementPendingRemoves() {
        ++this.pending_removes;
        if (logger.isLoggable(MLevel.FINEST)) {
            logger.finest("incremented pending_removes: " + this.pending_removes);
        }
    }

    private synchronized void decrementPendingAcquires() {
        this._decrementPendingAcquires();
    }

    private void _decrementPendingAcquires() {
        --this.pending_acquires;
        if (logger.isLoggable(MLevel.FINEST)) {
            logger.finest("decremented pending_acquires: " + this.pending_acquires);
        }
    }

    private synchronized void decrementPendingRemoves() {
        --this.pending_removes;
        if (logger.isLoggable(MLevel.FINEST)) {
            logger.finest("decremented pending_removes: " + this.pending_removes);
        }
    }

    private synchronized void recheckResizePool() {
        this._recheckResizePool();
    }

    private void expandPool(int n) {
        assert (Thread.holdsLock(this));
        if (USE_SCATTERED_ACQUIRE_TASK) {
            for (int i = 0; i < n; ++i) {
                this.taskRunner.postRunnable((Runnable)new ScatteredAcquireTask());
            }
        } else {
            for (int i = 0; i < n; ++i) {
                this.taskRunner.postRunnable((Runnable)new AcquireTask());
            }
        }
    }

    private void shrinkPool(int n) {
        assert (Thread.holdsLock(this));
        for (int i = 0; i < n; ++i) {
            this.taskRunner.postRunnable((Runnable)new RemoveTask());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object checkoutResource(long l) throws TimeoutException, ResourcePoolException, InterruptedException {
        try {
            Object object = this.prelimCheckoutResource(l);
            boolean bl = this.attemptRefurbishResourceOnCheckout(object);
            BasicResourcePool basicResourcePool = this;
            synchronized (basicResourcePool) {
                if (!bl) {
                    if (logger.isLoggable(MLevel.FINER)) {
                        logger.log(MLevel.FINER, "Resource [" + object + "] could not be refurbished in preparation for checkout. Will try to find a better resource.");
                    }
                    this.removeResource(object);
                    this.ensureMinResources();
                    object = null;
                } else {
                    this.asyncFireResourceCheckedOut(object, this.managed.size(), this.unused.size(), this.excluded.size());
                    PunchCard punchCard = (PunchCard)this.managed.get(object);
                    if (punchCard == null) {
                        if (logger.isLoggable(MLevel.FINER)) {
                            logger.finer("Resource " + object + " was removed from the pool while it was being checked out  or refurbished for checkout. Will try to find a replacement resource.");
                        }
                        object = null;
                    } else {
                        punchCard.checkout_time = System.currentTimeMillis();
                        if (this.debug_store_checkout_exceptions) {
                            punchCard.checkoutStackTraceException = new Exception("DEBUG STACK TRACE: Overdue resource check-out stack trace.");
                        }
                    }
                }
            }
            if (object == null) {
                return this.checkoutResource(l);
            }
            return object;
        }
        catch (StackOverflowError stackOverflowError) {
            throw new NoGoodResourcesException("After checking so many resources we blew the stack, no resources tested acceptable for checkout. See logger com.mchange.v2.resourcepool.BasicResourcePool output at FINER/DEBUG for information on individual failures.", stackOverflowError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized Object prelimCheckoutResource(long l) throws TimeoutException, ResourcePoolException, InterruptedException {
        try {
            Object e;
            this.ensureNotBroken();
            int n = this.unused.size();
            if (n == 0) {
                int n2 = this.managed.size();
                if (n2 < this.max) {
                    int n3 = n2 + this.acquireWaiters.size() + 1;
                    if (logger.isLoggable(MLevel.FINER)) {
                        logger.log(MLevel.FINER, "acquire test -- pool size: " + n2 + "; target_pool_size: " + this.target_pool_size + "; desired target? " + n3);
                    }
                    if (n3 >= this.target_pool_size) {
                        n3 = Math.max(n3, this.target_pool_size + this.inc);
                        this.target_pool_size = Math.max(Math.min(this.max, n3), this.min);
                        this._recheckResizePool();
                    }
                } else if (logger.isLoggable(MLevel.FINER)) {
                    logger.log(MLevel.FINER, "acquire test -- pool is already maxed out. [managed: " + n2 + "; max: " + this.max + "]");
                }
                this.awaitAvailable(l);
            }
            if (this.idleCheckResources.contains(e = this.unused.get(0))) {
                if (logger.isLoggable(MLevel.FINER)) {
                    logger.log(MLevel.FINER, "Resource we want to check out is in idleCheck! (waiting until idle-check completes.) [" + this + "]");
                }
                Thread thread = Thread.currentThread();
                try {
                    this.otherWaiters.add(thread);
                    this.wait(l);
                    this.ensureNotBroken();
                }
                finally {
                    this.otherWaiters.remove(thread);
                }
                return this.prelimCheckoutResource(l);
            }
            if (this.shouldExpire(e)) {
                if (logger.isLoggable(MLevel.FINER)) {
                    logger.log(MLevel.FINER, "Resource we want to check out has expired already. Trying again.");
                }
                this.removeResource(e);
                this.ensureMinResources();
                return this.prelimCheckoutResource(l);
            }
            this.unused.remove(0);
            return e;
        }
        catch (ResourceClosedException resourceClosedException) {
            if (logger.isLoggable(MLevel.SEVERE)) {
                logger.log(MLevel.SEVERE, this + " -- the pool was found to be closed or broken during an attempt to check out a resource.", (Throwable)resourceClosedException);
            }
            this.unexpectedBreak();
            throw resourceClosedException;
        }
        catch (InterruptedException interruptedException) {
            if (this.broken) {
                if (logger.isLoggable(MLevel.FINER)) {
                    logger.log(MLevel.FINER, this + " -- an attempt to checkout a resource was interrupted, because the pool is now closed. [Thread: " + Thread.currentThread().getName() + ']', (Throwable)interruptedException);
                } else if (logger.isLoggable(MLevel.INFO)) {
                    logger.log(MLevel.INFO, this + " -- an attempt to checkout a resource was interrupted, because the pool is now closed. [Thread: " + Thread.currentThread().getName() + ']');
                }
            } else if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, this + " -- an attempt to checkout a resource was interrupted, and the pool is still live: some other thread must have interrupted the Thread attempting checkout!", (Throwable)interruptedException);
            }
            throw interruptedException;
        }
        catch (StackOverflowError stackOverflowError) {
            throw new NoGoodResourcesException("After checking so many resources we blew the stack, no resources tested acceptable for checkout. See logger com.mchange.v2.resourcepool.BasicResourcePool output at FINER/DEBUG for information on individual failures.", stackOverflowError);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkinResource(Object object) throws ResourcePoolException {
        try {
            boolean bl = false;
            BasicResourcePool basicResourcePool = this;
            synchronized (basicResourcePool) {
                if (this.managed.keySet().contains(object)) {
                    bl = true;
                } else if (this.excluded.contains(object)) {
                    this.doCheckinExcluded(object);
                } else if (this.isFormerResource(object)) {
                    if (logger.isLoggable(MLevel.FINER)) {
                        logger.finer("Resource " + object + " checked-in after having been checked-in already, or checked-in after  having being destroyed for being checked-out too long.");
                    }
                } else {
                    throw new ResourcePoolException("ResourcePool" + (this.broken ? " [BROKEN!]" : "") + ": Tried to check-in a foreign resource!");
                }
            }
            if (bl) {
                this.doCheckinManaged(object);
            }
        }
        catch (ResourceClosedException resourceClosedException) {
            if (logger.isLoggable(MLevel.SEVERE)) {
                logger.log(MLevel.SEVERE, this + " - checkinResource( ... ) -- even broken pools should allow checkins without exception. probable resource pool bug.", (Throwable)resourceClosedException);
            }
            this.unexpectedBreak();
            throw resourceClosedException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkinAll() throws ResourcePoolException {
        try {
            HashSet hashSet = null;
            Object object = this;
            synchronized (object) {
                hashSet = new HashSet(this.managed.keySet());
                hashSet.removeAll(this.unused);
                Iterator iterator = this.excluded.iterator();
                while (iterator.hasNext()) {
                    this.doCheckinExcluded(iterator.next());
                }
            }
            object = hashSet.iterator();
            while (object.hasNext()) {
                this.doCheckinManaged(object.next());
            }
        }
        catch (ResourceClosedException resourceClosedException) {
            if (logger.isLoggable(MLevel.SEVERE)) {
                logger.log(MLevel.SEVERE, this + " - checkinAll() -- even broken pools should allow checkins without exception. probable resource pool bug.", (Throwable)resourceClosedException);
            }
            this.unexpectedBreak();
            throw resourceClosedException;
        }
    }

    @Override
    public synchronized int statusInPool(Object object) throws ResourcePoolException {
        try {
            if (this.unused.contains(object)) {
                return 0;
            }
            if (this.managed.keySet().contains(object) || this.excluded.contains(object)) {
                return 1;
            }
            return -1;
        }
        catch (ResourceClosedException resourceClosedException) {
            if (logger.isLoggable(MLevel.SEVERE)) {
                logger.log(MLevel.SEVERE, "Apparent pool break.", (Throwable)resourceClosedException);
            }
            this.unexpectedBreak();
            throw resourceClosedException;
        }
    }

    @Override
    public synchronized void markBroken(Object object) {
        try {
            this._markBroken(object);
            this.ensureMinResources();
        }
        catch (ResourceClosedException resourceClosedException) {
            if (logger.isLoggable(MLevel.SEVERE)) {
                logger.log(MLevel.SEVERE, "Apparent pool break.", (Throwable)resourceClosedException);
            }
            this.unexpectedBreak();
        }
    }

    @Override
    public int getMinPoolSize() {
        return this.min;
    }

    @Override
    public int getMaxPoolSize() {
        return this.max;
    }

    @Override
    public synchronized int getPoolSize() throws ResourcePoolException {
        return this.managed.size();
    }

    @Override
    public synchronized int getAvailableCount() {
        return this.unused.size();
    }

    @Override
    public synchronized int getExcludedCount() {
        return this.excluded.size();
    }

    @Override
    public synchronized int getAwaitingCheckinCount() {
        return this.managed.size() - this.unused.size() + this.excluded.size();
    }

    @Override
    public synchronized int getAwaitingCheckinNotExcludedCount() {
        return this.managed.size() - this.unused.size();
    }

    @Override
    public synchronized void resetPool() {
        try {
            Iterator iterator = this.cloneOfManaged().keySet().iterator();
            while (iterator.hasNext()) {
                this.markBrokenNoEnsureMinResources(iterator.next());
            }
            this.ensureMinResources();
        }
        catch (ResourceClosedException resourceClosedException) {
            if (logger.isLoggable(MLevel.SEVERE)) {
                logger.log(MLevel.SEVERE, "Apparent pool break.", (Throwable)resourceClosedException);
            }
            this.unexpectedBreak();
        }
    }

    @Override
    public synchronized void close() throws ResourcePoolException {
        this.close(true);
    }

    public void finalize() throws Throwable {
        if (!this.broken) {
            this.close();
        }
    }

    public void addResourcePoolListener(ResourcePoolListener resourcePoolListener) {
        if (!this.supportsEvents()) {
            throw new RuntimeException(this + " does not support ResourcePoolEvents. Probably it was constructed by a BasicResourceFactory configured not to support such events.");
        }
        this.rpes.addResourcePoolListener(resourcePoolListener);
    }

    public void removeResourcePoolListener(ResourcePoolListener resourcePoolListener) {
        if (!this.supportsEvents()) {
            throw new RuntimeException(this + " does not support ResourcePoolEvents. Probably it was constructed by a BasicResourceFactory configured not to support such events.");
        }
        this.rpes.removeResourcePoolListener(resourcePoolListener);
    }

    private synchronized boolean isForceKillAcquiresPending() {
        return this.force_kill_acquires;
    }

    private synchronized void forceKillAcquires() throws InterruptedException {
        if (logger.isLoggable(MLevel.WARNING)) {
            logger.log(MLevel.WARNING, "Having failed to acquire a resource, " + this + " is interrupting all Threads waiting on a resource to check out. Will try again in response to new client requests.");
        }
        Thread thread = Thread.currentThread();
        try {
            this.force_kill_acquires = true;
            this.notifyAll();
            while (this.acquireWaiters.size() > 0) {
                this.otherWaiters.add(thread);
                this.wait();
            }
            this.force_kill_acquires = false;
        }
        catch (InterruptedException interruptedException) {
            Iterator iterator = this.acquireWaiters.iterator();
            while (iterator.hasNext()) {
                ((Thread)iterator.next()).interrupt();
            }
            if (logger.isLoggable(MLevel.WARNING)) {
                logger.log(MLevel.WARNING, "An interrupt left an attempt to gently clear threads waiting on resource acquisition potentially incomplete! We have made a best attempt to finish that by interrupt()ing the waiting Threads.");
            }
            this.force_kill_acquires = false;
            interruptedException.fillInStackTrace();
            throw interruptedException;
        }
        catch (Throwable throwable) {
            Iterator iterator = this.acquireWaiters.iterator();
            while (iterator.hasNext()) {
                ((Thread)iterator.next()).interrupt();
            }
            if (logger.isLoggable(MLevel.SEVERE)) {
                logger.log(MLevel.SEVERE, "An unexpected problem caused our attempt to gently clear threads waiting on resource acquisition to fail! We have made a best attempt to finish that by interrupt()ing the waiting Threads.", throwable);
            }
            this.force_kill_acquires = false;
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            throw new RuntimeException("Wrapped unexpected Throwable.", throwable);
        }
        finally {
            this.otherWaiters.remove(thread);
        }
    }

    private synchronized void unexpectedBreak() {
        if (logger.isLoggable(MLevel.SEVERE)) {
            logger.log(MLevel.SEVERE, this + " -- Unexpectedly broken!!!", (Throwable)((Object)new ResourcePoolException("Unexpected Break Stack Trace!")));
        }
        this.close(false);
    }

    private boolean canFireEvents() {
        return this.asyncEventQueue != null && !this.isBroken();
    }

    private void asyncFireResourceAcquired(final Object object, final int n, final int n2, final int n3) {
        if (this.canFireEvents()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    BasicResourcePool.this.rpes.fireResourceAcquired(object, n, n2, n3);
                }
            };
            this.asyncEventQueue.postRunnable(runnable);
        }
    }

    private void asyncFireResourceCheckedIn(final Object object, final int n, final int n2, final int n3) {
        if (this.canFireEvents()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    BasicResourcePool.this.rpes.fireResourceCheckedIn(object, n, n2, n3);
                }
            };
            this.asyncEventQueue.postRunnable(runnable);
        }
    }

    private void asyncFireResourceCheckedOut(final Object object, final int n, final int n2, final int n3) {
        if (this.canFireEvents()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    BasicResourcePool.this.rpes.fireResourceCheckedOut(object, n, n2, n3);
                }
            };
            this.asyncEventQueue.postRunnable(runnable);
        }
    }

    private void asyncFireResourceRemoved(final Object object, final boolean bl, final int n, final int n2, final int n3) {
        if (this.canFireEvents()) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    BasicResourcePool.this.rpes.fireResourceRemoved(object, bl, n, n2, n3);
                }
            };
            this.asyncEventQueue.postRunnable(runnable);
        }
    }

    private void destroyResource(Object object) {
        this.destroyResource(object, false);
    }

    private void destroyResource(Object object, boolean bl) {
        this.destroyResource(object, bl, false);
    }

    private void destroyResource(final Object object, boolean bl, final boolean bl2) {
        class DestroyResourceTask
        implements Runnable {
            DestroyResourceTask() {
            }

            @Override
            public void run() {
                block2: {
                    try {
                        BasicResourcePool.this.mgr.destroyResource(object, bl2);
                    }
                    catch (Exception exception) {
                        if (!logger.isLoggable(MLevel.WARNING)) break block2;
                        logger.log(MLevel.WARNING, "Failed to destroy resource: " + object, (Throwable)exception);
                    }
                }
            }
        }
        DestroyResourceTask destroyResourceTask = new DestroyResourceTask();
        if (bl || this.broken) {
            if (logger.isLoggable(MLevel.FINEST) && !this.broken && Boolean.TRUE.equals(ThreadUtils.reflectiveHoldsLock((Object)this))) {
                logger.log(MLevel.FINEST, this + ": Destroyiong a resource on an active pool, synchronousy while holding pool's lock! (not a bug, but a potential bottleneck... is there a good reason for this?)", (Throwable)new Exception("DEBUG STACK TRACE: resource destruction while holding lock."));
            }
            destroyResourceTask.run();
        } else {
            try {
                this.taskRunner.postRunnable((Runnable)destroyResourceTask);
            }
            catch (Exception exception) {
                if (logger.isLoggable(MLevel.FINER)) {
                    logger.log(MLevel.FINER, "AsynchronousRunner refused to accept task to destroy resource. It is probably shared, and has probably been closed underneath us. Reverting to synchronous destruction. This is not usually a problem.", (Throwable)exception);
                }
                this.destroyResource(object, true);
            }
        }
    }

    private void doAcquire() throws Exception {
        this.doAcquire(0);
    }

    private void doAcquireAndDecrementPendingAcquiresWithinLockOnSuccess() throws Exception {
        this.doAcquire(1);
    }

    private void doAcquireAndDecrementPendingAcquiresWithinLockAlways() throws Exception {
        this.doAcquire(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAcquire(int n) throws Exception {
        block16: {
            assert (!Thread.holdsLock(this));
            Object object = this.mgr.acquireResource();
            boolean bl = false;
            BasicResourcePool basicResourcePool = this;
            synchronized (basicResourcePool) {
                try {
                    int n2 = this.managed.size();
                    if (!this.broken && n2 < this.target_pool_size) {
                        this.assimilateResource(object);
                    } else {
                        bl = true;
                    }
                    if (n == 1) {
                        this._decrementPendingAcquires();
                    }
                }
                finally {
                    if (n == 2) {
                        this._decrementPendingAcquires();
                    }
                }
            }
            if (bl) {
                try {
                    this.mgr.destroyResource(object, false);
                    if (logger.isLoggable(MLevel.FINER)) {
                        logger.log(MLevel.FINER, "destroying overacquired resource: " + object);
                    }
                }
                catch (Exception exception) {
                    if (!logger.isLoggable(MLevel.FINE)) break block16;
                    logger.log(MLevel.FINE, "An exception occurred while trying to destroy an overacquired resource: " + object, (Throwable)exception);
                }
            }
        }
    }

    @Override
    public synchronized void setPoolSize(int n) throws ResourcePoolException {
        try {
            this.setTargetPoolSize(n);
            while (this.managed.size() != n) {
                this.wait();
            }
        }
        catch (Exception exception) {
            String string = "An exception occurred while trying to set the pool size!";
            if (logger.isLoggable(MLevel.FINER)) {
                logger.log(MLevel.FINER, string, (Throwable)exception);
            }
            throw ResourcePoolUtils.convertThrowable(string, exception);
        }
    }

    public synchronized void setTargetPoolSize(int n) {
        if (n > this.max) {
            throw new IllegalArgumentException("Requested size [" + n + "] is greater than max [" + this.max + "].");
        }
        if (n < this.min) {
            throw new IllegalArgumentException("Requested size [" + n + "] is less than min [" + this.min + "].");
        }
        this.target_pool_size = n;
        this._recheckResizePool();
    }

    private void markBrokenNoEnsureMinResources(Object object) {
        assert (Thread.holdsLock(this));
        try {
            this._markBroken(object);
        }
        catch (ResourceClosedException resourceClosedException) {
            if (logger.isLoggable(MLevel.SEVERE)) {
                logger.log(MLevel.SEVERE, "Apparent pool break.", (Throwable)resourceClosedException);
            }
            this.unexpectedBreak();
        }
    }

    private void _markBroken(Object object) {
        assert (Thread.holdsLock(this));
        if (this.unused.contains(object)) {
            this.removeResource(object);
        } else {
            this.excludeResource(object);
        }
    }

    @Override
    public synchronized void close(boolean bl) {
        if (!this.broken) {
            Collection<Object> collection;
            this.broken = true;
            Collection<Object> collection2 = collection = bl ? this.cloneOfManaged().keySet() : this.cloneOfUnused();
            if (this.cullTask != null) {
                this.cullTask.cancel();
            }
            if (this.idleRefurbishTask != null) {
                this.idleRefurbishTask.cancel();
            }
            Object object = collection.iterator();
            while (object.hasNext()) {
                this.addToFormerResources(object.next());
            }
            this.managed.keySet().removeAll(collection);
            this.unused.removeAll(collection);
            object = new Thread("Resource Destroyer in BasicResourcePool.close()"){

                @Override
                public void run() {
                    Iterator iterator = collection.iterator();
                    while (iterator.hasNext()) {
                        try {
                            Object e = iterator.next();
                            BasicResourcePool.this.destroyResource(e, true);
                        }
                        catch (Exception exception) {
                            if (!logger.isLoggable(MLevel.FINE)) continue;
                            logger.log(MLevel.FINE, "BasicResourcePool -- A resource couldn't be cleaned up on close()", (Throwable)exception);
                        }
                    }
                }
            };
            ((Thread)object).start();
            Iterator iterator = this.acquireWaiters.iterator();
            while (iterator.hasNext()) {
                ((Thread)iterator.next()).interrupt();
            }
            iterator = this.otherWaiters.iterator();
            while (iterator.hasNext()) {
                ((Thread)iterator.next()).interrupt();
            }
            if (this.factory != null) {
                this.factory.markBroken(this);
            }
        } else if (logger.isLoggable(MLevel.WARNING)) {
            logger.warning(this + " -- close() called multiple times.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCheckinManaged(final Object object) throws ResourcePoolException {
        assert (!Thread.holdsLock(this));
        if (this.statusInPool(object) == 0) {
            throw new ResourcePoolException("Tried to check-in an already checked-in resource: " + object);
        }
        Object object2 = this;
        synchronized (object2) {
            if (this.broken) {
                this.removeResource(object, true);
                return;
            }
        }
        class RefurbishCheckinResourceTask
        implements Runnable {
            RefurbishCheckinResourceTask() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean bl = BasicResourcePool.this.attemptRefurbishResourceOnCheckin(object);
                BasicResourcePool basicResourcePool = BasicResourcePool.this;
                synchronized (basicResourcePool) {
                    PunchCard punchCard = (PunchCard)BasicResourcePool.this.managed.get(object);
                    if (bl && punchCard != null) {
                        BasicResourcePool.this.unused.add(0, object);
                        punchCard.last_checkin_time = System.currentTimeMillis();
                        punchCard.checkout_time = -1L;
                    } else {
                        if (punchCard != null) {
                            punchCard.checkout_time = -1L;
                        }
                        BasicResourcePool.this.removeResource(object);
                        BasicResourcePool.this.ensureMinResources();
                        if (punchCard == null && logger.isLoggable(MLevel.FINE)) {
                            logger.fine("Resource " + object + " was removed from the pool during its refurbishment for checkin.");
                        }
                    }
                    BasicResourcePool.this.asyncFireResourceCheckedIn(object, BasicResourcePool.this.managed.size(), BasicResourcePool.this.unused.size(), BasicResourcePool.this.excluded.size());
                    BasicResourcePool.this.notifyAll();
                }
            }
        }
        object2 = new RefurbishCheckinResourceTask();
        if (this.force_synchronous_checkins) {
            object2.run();
        } else {
            this.taskRunner.postRunnable((Runnable)object2);
        }
    }

    private void doCheckinExcluded(Object object) {
        assert (Thread.holdsLock(this));
        this.excluded.remove(object);
        this.destroyResource(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void awaitAvailable(long l) throws InterruptedException, TimeoutException, ResourcePoolException {
        assert (Thread.holdsLock(this));
        if (this.force_kill_acquires) {
            throw new ResourcePoolException("A ResourcePool cannot acquire a new resource -- the factory or source appears to be down.");
        }
        Thread thread = Thread.currentThread();
        try {
            int n;
            this.acquireWaiters.add(thread);
            long l2 = l > 0L ? System.currentTimeMillis() : -1L;
            long l3 = l;
            while ((n = this.unused.size()) == 0) {
                if (this.pending_acquires == 0 && this.managed.size() < this.max) {
                    this._recheckResizePool();
                }
                this.wait(l3);
                l3 = Math.max(0L, l - (System.currentTimeMillis() - l2));
                if (l > 0L && l3 == 0L) {
                    throw new TimeoutException("A client timed out while waiting to acquire a resource from " + this + " -- timeout at awaitAvailable()");
                }
                if (this.force_kill_acquires) {
                    throw new CannotAcquireResourceException("A ResourcePool could not acquire a resource from its primary factory or source.", this.getLastAcquisitionFailure());
                }
                this.ensureNotBroken();
            }
        }
        finally {
            this.acquireWaiters.remove(thread);
            if (this.acquireWaiters.size() == 0) {
                this.notifyAll();
            }
        }
    }

    private void assimilateResource(Object object) throws Exception {
        assert (Thread.holdsLock(this));
        this.managed.put(object, new PunchCard());
        this.unused.add(0, object);
        this.asyncFireResourceAcquired(object, this.managed.size(), this.unused.size(), this.excluded.size());
        this.notifyAll();
        if (this.exampleResource == null) {
            this.exampleResource = object;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronousRemoveArbitraryResource() {
        assert (!Thread.holdsLock(this));
        Object var1_1 = null;
        BasicResourcePool basicResourcePool = this;
        synchronized (basicResourcePool) {
            if (this.unused.size() > 0) {
                var1_1 = this.unused.get(0);
                this.managed.remove(var1_1);
                this.unused.remove(var1_1);
            } else {
                Set set = this.cloneOfManaged().keySet();
                if (set.isEmpty()) {
                    this.unexpectedBreak();
                    logger.severe("A pool from which a resource is requested to be removed appears to have no managed resources?!");
                } else {
                    this.excludeResource(set.iterator().next());
                }
            }
        }
        if (var1_1 != null) {
            this.destroyResource(var1_1, true);
        }
    }

    private void removeResource(Object object) {
        this.removeResource(object, false);
    }

    private void removeResource(Object object, boolean bl) {
        assert (Thread.holdsLock(this));
        PunchCard punchCard = (PunchCard)this.managed.remove(object);
        boolean bl2 = false;
        if (punchCard != null) {
            boolean bl3 = bl2 = punchCard.checkout_time > 0L;
            if (bl2 && !this.broken && logger.isLoggable(MLevel.INFO)) {
                logger.info("A checked-out resource is overdue, and will be destroyed: " + object);
                if (punchCard.checkoutStackTraceException != null) {
                    logger.log(MLevel.INFO, "Logging the stack trace by which the overdue resource was checked-out.", (Throwable)punchCard.checkoutStackTraceException);
                }
            }
        } else if (logger.isLoggable(MLevel.FINE)) {
            logger.fine("Resource " + object + " was removed twice. (Lotsa reasons a resource can be removed, sometimes simultaneously. It's okay)");
        }
        this.unused.remove(object);
        this.destroyResource(object, bl, bl2);
        this.addToFormerResources(object);
        this.asyncFireResourceRemoved(object, false, this.managed.size(), this.unused.size(), this.excluded.size());
    }

    private void excludeResource(Object object) {
        assert (Thread.holdsLock(this));
        this.managed.remove(object);
        this.excluded.add(object);
        if (this.unused.contains(object)) {
            throw new InternalError("We should only \"exclude\" checked-out resources!");
        }
        if (logger.isLoggable(MLevel.FINEST)) {
            logger.log(MLevel.FINEST, "Excluded resource " + object, (Throwable)new Exception("DEBUG STACK TRACE: Excluded resource stack trace"));
        }
        this.asyncFireResourceRemoved(object, true, this.managed.size(), this.unused.size(), this.excluded.size());
    }

    private void removeTowards(int n) {
        assert (Thread.holdsLock(this));
        int n2 = this.managed.size() - n;
        Iterator iterator = this.cloneOfUnused().iterator();
        for (int i = 0; iterator.hasNext() && i < n2; ++i) {
            Object e = iterator.next();
            this.removeResource(e);
        }
    }

    private void cullExpired() {
        assert (Thread.holdsLock(this));
        if (logger.isLoggable(MLevel.FINER)) {
            logger.log(MLevel.FINER, "BEGIN check for expired resources.  [" + this + "]");
        }
        Collection<Object> collection = this.destroy_unreturned_resc_time > 0L ? this.cloneOfManaged().keySet() : this.cloneOfUnused();
        for (Object object : collection) {
            if (!this.shouldExpire(object)) continue;
            if (logger.isLoggable(MLevel.FINER)) {
                logger.log(MLevel.FINER, "Removing expired resource: " + object + " [" + this + "]");
            }
            this.target_pool_size = Math.max(this.min, this.target_pool_size - 1);
            this.removeResource(object);
        }
        if (logger.isLoggable(MLevel.FINER)) {
            logger.log(MLevel.FINER, "FINISHED check for expired resources.  [" + this + "]");
        }
        this.ensureMinResources();
    }

    private void checkIdleResources() {
        assert (Thread.holdsLock(this));
        LinkedList linkedList = this.cloneOfUnused();
        for (Object e : linkedList) {
            if (!this.idleCheckResources.add(e)) continue;
            this.taskRunner.postRunnable((Runnable)new AsyncTestIdleResourceTask(e));
        }
    }

    private boolean shouldExpire(Object object) {
        assert (Thread.holdsLock(this));
        boolean bl = false;
        PunchCard punchCard = (PunchCard)this.managed.get(object);
        if (punchCard == null) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.fine("Resource " + object + " was being tested for expiration, but has already been removed from the pool.");
            }
            return true;
        }
        long l = System.currentTimeMillis();
        if (punchCard.checkout_time < 0L) {
            long l2 = l - punchCard.last_checkin_time;
            if (this.excess_max_idle_time > 0L) {
                int n = this.managed.size();
                boolean bl2 = bl = n > this.min && l2 > this.excess_max_idle_time;
                if (bl && logger.isLoggable(MLevel.FINER)) {
                    logger.log(MLevel.FINER, "EXPIRED excess idle resource: " + object + " ---> idle_time: " + l2 + "; excess_max_idle_time: " + this.excess_max_idle_time + "; pool_size: " + n + "; min_pool_size: " + this.min + " [" + this + "]");
                }
            }
            if (!bl && this.max_idle_time > 0L) {
                boolean bl3 = bl = l2 > this.max_idle_time;
                if (bl && logger.isLoggable(MLevel.FINER)) {
                    logger.log(MLevel.FINER, "EXPIRED idle resource: " + object + " ---> idle_time: " + l2 + "; max_idle_time: " + this.max_idle_time + " [" + this + "]");
                }
            }
            if (!bl && this.max_resource_age > 0L) {
                long l3 = l - punchCard.acquisition_time;
                boolean bl4 = bl = l3 > this.max_resource_age;
                if (bl && logger.isLoggable(MLevel.FINER)) {
                    logger.log(MLevel.FINER, "EXPIRED old resource: " + object + " ---> absolute_age: " + l3 + "; max_absolute_age: " + this.max_resource_age + " [" + this + "]");
                }
            }
        } else {
            long l4 = l - punchCard.checkout_time;
            bl = l4 > this.destroy_unreturned_resc_time;
        }
        return bl;
    }

    private void ensureStartResources() {
        this.recheckResizePool();
    }

    private void ensureMinResources() {
        this.recheckResizePool();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean attemptRefurbishResourceOnCheckout(Object object) {
        assert (!Thread.holdsLock(this));
        try {
            this.mgr.refurbishResourceOnCheckout(object);
            return true;
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "A resource could not be refurbished for checkout. [" + object + ']', (Throwable)exception);
            }
            BasicResourcePool basicResourcePool = this;
            synchronized (basicResourcePool) {
                ++this.failed_checkouts;
                this.setLastCheckoutFailure(exception);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean attemptRefurbishResourceOnCheckin(Object object) {
        assert (!Thread.holdsLock(this));
        try {
            this.mgr.refurbishResourceOnCheckin(object);
            return true;
        }
        catch (Exception exception) {
            if (logger.isLoggable(MLevel.FINE)) {
                logger.log(MLevel.FINE, "A resource could not be refurbished on checkin. [" + object + ']', (Throwable)exception);
            }
            BasicResourcePool basicResourcePool = this;
            synchronized (basicResourcePool) {
                ++this.failed_checkins;
                this.setLastCheckinFailure(exception);
            }
            return false;
        }
    }

    private void ensureNotBroken() throws ResourcePoolException {
        assert (Thread.holdsLock(this));
        if (this.broken) {
            throw new ResourcePoolException("Attempted to use a closed or broken resource pool");
        }
    }

    private synchronized void syncTrace() {
        this.trace();
    }

    private void trace() {
        assert (Thread.holdsLock(this));
        if (logger.isLoggable(MLevel.FINEST)) {
            String string = this.exampleResource == null ? "" : " (e.g. " + this.exampleResource + ")";
            logger.finest("trace " + this + " [managed: " + this.managed.size() + ", unused: " + this.unused.size() + ", excluded: " + this.excluded.size() + ']' + string);
        }
    }

    private final HashMap cloneOfManaged() {
        assert (Thread.holdsLock(this));
        return (HashMap)this.managed.clone();
    }

    private final LinkedList cloneOfUnused() {
        assert (Thread.holdsLock(this));
        return (LinkedList)this.unused.clone();
    }

    private final HashSet cloneOfExcluded() {
        assert (Thread.holdsLock(this));
        return (HashSet)this.excluded.clone();
    }

    static {
        String string = MConfig.readVmConfig().getProperty(USE_SCATTERED_ACQUIRE_TASK_KEY);
        if (string != null && string.trim().toLowerCase().equals("false")) {
            USE_SCATTERED_ACQUIRE_TASK = false;
            if (logger.isLoggable(MLevel.INFO)) {
                logger.info(BasicResourcePool.class.getName() + " using traditional, Thread-blocking AcquireTask. Yuk. Why? It's no longer supported.");
            }
        } else {
            USE_SCATTERED_ACQUIRE_TASK = true;
        }
    }

    static final class PunchCard {
        long acquisition_time;
        long last_checkin_time;
        long checkout_time;
        Exception checkoutStackTraceException;

        PunchCard() {
            this.last_checkin_time = this.acquisition_time = System.currentTimeMillis();
            this.checkout_time = -1L;
            this.checkoutStackTraceException = null;
        }
    }

    class AsyncTestIdleResourceTask
    implements Runnable {
        Object resc;
        boolean pending = true;
        boolean failed;

        AsyncTestIdleResourceTask(Object object) {
            this.resc = object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            assert (!Thread.holdsLock(BasicResourcePool.this));
            try {
                try {
                    BasicResourcePool.this.mgr.refurbishIdleResource(this.resc);
                }
                catch (Exception exception) {
                    if (logger.isLoggable(MLevel.FINE)) {
                        logger.log(MLevel.FINE, "BasicResourcePool: An idle resource is broken and will be purged. [" + this.resc + ']', (Throwable)exception);
                    }
                    BasicResourcePool basicResourcePool = BasicResourcePool.this;
                    synchronized (basicResourcePool) {
                        if (BasicResourcePool.this.managed.keySet().contains(this.resc)) {
                            BasicResourcePool.this.removeResource(this.resc);
                            BasicResourcePool.this.ensureMinResources();
                        }
                        ++BasicResourcePool.this.failed_idle_tests;
                        BasicResourcePool.this.setLastIdleCheckFailure(exception);
                    }
                }
            }
            finally {
                BasicResourcePool basicResourcePool = BasicResourcePool.this;
                synchronized (basicResourcePool) {
                    BasicResourcePool.this.idleCheckResources.remove(this.resc);
                    BasicResourcePool.this.notifyAll();
                }
            }
        }
    }

    class CheckIdleResourcesTask
    extends TimerTask {
        CheckIdleResourcesTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (logger.isLoggable(MLevel.FINER)) {
                    logger.log(MLevel.FINER, "Refurbishing idle resources - " + new Date() + " [" + BasicResourcePool.this + "]");
                }
                BasicResourcePool basicResourcePool = BasicResourcePool.this;
                synchronized (basicResourcePool) {
                    BasicResourcePool.this.checkIdleResources();
                }
            }
            catch (ResourceClosedException resourceClosedException) {
                if (logger.isLoggable(MLevel.FINE)) {
                    logger.log(MLevel.FINE, "a resource pool async thread died.", (Throwable)resourceClosedException);
                }
                BasicResourcePool.this.unexpectedBreak();
            }
        }
    }

    class CullTask
    extends TimerTask {
        CullTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (logger.isLoggable(MLevel.FINER)) {
                    logger.log(MLevel.FINER, "Checking for expired resources - " + new Date() + " [" + BasicResourcePool.this + "]");
                }
                BasicResourcePool basicResourcePool = BasicResourcePool.this;
                synchronized (basicResourcePool) {
                    BasicResourcePool.this.cullExpired();
                }
            }
            catch (ResourceClosedException resourceClosedException) {
                if (logger.isLoggable(MLevel.FINE)) {
                    logger.log(MLevel.FINE, "a resource pool async thread died.", (Throwable)resourceClosedException);
                }
                BasicResourcePool.this.unexpectedBreak();
            }
        }
    }

    class RemoveTask
    implements Runnable {
        public RemoveTask() {
            BasicResourcePool.this.incrementPendingRemoves();
        }

        @Override
        public void run() {
            try {
                BasicResourcePool.this.synchronousRemoveArbitraryResource();
                BasicResourcePool.this.recheckResizePool();
            }
            finally {
                BasicResourcePool.this.decrementPendingRemoves();
            }
        }
    }

    class AcquireTask
    implements Runnable {
        boolean success = false;

        public AcquireTask() {
            BasicResourcePool.this.incrementPendingAcquires();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean bl = false;
            boolean bl2 = false;
            try {
                Exception exception = null;
                int n = 0;
                while (this.shouldTry(n)) {
                    try {
                        if (n > 0) {
                            Thread.sleep(BasicResourcePool.this.acq_attempt_delay);
                        }
                        if (this.goodAttemptNumber(n + 1)) {
                            BasicResourcePool.this.doAcquireAndDecrementPendingAcquiresWithinLockOnSuccess();
                            bl = true;
                        } else {
                            bl = true;
                            bl2 = true;
                            BasicResourcePool.this.doAcquireAndDecrementPendingAcquiresWithinLockAlways();
                        }
                        this.success = true;
                    }
                    catch (InterruptedException interruptedException) {
                        throw interruptedException;
                    }
                    catch (Exception exception2) {
                        MLevel mLevel;
                        MLevel mLevel2 = mLevel = BasicResourcePool.this.num_acq_attempts > 0 ? MLevel.FINE : MLevel.INFO;
                        if (logger.isLoggable(mLevel)) {
                            logger.log(mLevel, "An exception occurred while acquiring a poolable resource. Will retry.", (Throwable)exception2);
                        }
                        exception = exception2;
                        BasicResourcePool.this.setLastAcquisitionFailure(exception2);
                    }
                    ++n;
                }
                if (!this.success) {
                    if (logger.isLoggable(MLevel.WARNING)) {
                        logger.log(MLevel.WARNING, this + " -- Acquisition Attempt Failed!!! Clearing pending acquires. While trying to acquire a needed new resource, we failed to succeed more than the maximum number of allowed acquisition attempts (" + BasicResourcePool.this.num_acq_attempts + "). " + (exception == null ? "" : "Last acquisition attempt exception: "), (Throwable)exception);
                    }
                    if (BasicResourcePool.this.break_on_acquisition_failure) {
                        if (logger.isLoggable(MLevel.SEVERE)) {
                            logger.severe("A RESOURCE POOL IS PERMANENTLY BROKEN! [" + this + "]");
                        }
                        BasicResourcePool.this.unexpectedBreak();
                    } else {
                        BasicResourcePool.this.forceKillAcquires();
                    }
                } else {
                    BasicResourcePool.this.recheckResizePool();
                }
            }
            catch (ResourceClosedException resourceClosedException) {
                if (logger.isLoggable(MLevel.FINE)) {
                    logger.log(MLevel.FINE, "a resource pool async thread died.", (Throwable)resourceClosedException);
                }
                BasicResourcePool.this.unexpectedBreak();
            }
            catch (InterruptedException interruptedException) {
                if (logger.isLoggable(MLevel.WARNING)) {
                    logger.log(MLevel.WARNING, BasicResourcePool.this + " -- Thread unexpectedly interrupted while performing an acquisition attempt.", (Throwable)interruptedException);
                }
                BasicResourcePool.this.recheckResizePool();
            }
            finally {
                if (!bl) {
                    BasicResourcePool.this.decrementPendingAcquires();
                }
                if (bl2) {
                    BasicResourcePool.this.recheckResizePool();
                }
            }
        }

        private boolean shouldTry(int n) {
            return !this.success && !BasicResourcePool.this.isForceKillAcquiresPending() && this.goodAttemptNumber(n);
        }

        private boolean goodAttemptNumber(int n) {
            return BasicResourcePool.this.num_acq_attempts <= 0 || n < BasicResourcePool.this.num_acq_attempts;
        }
    }

    class ScatteredAcquireTask
    implements Runnable {
        int attempts_remaining;

        ScatteredAcquireTask() {
            this(basicResourcePool.num_acq_attempts >= 0 ? basicResourcePool.num_acq_attempts : -1, true);
        }

        private ScatteredAcquireTask(int n, boolean bl) {
            this.attempts_remaining = n;
            if (bl) {
                BasicResourcePool.this.incrementPendingAcquires();
                if (logger.isLoggable(MLevel.FINEST)) {
                    logger.finest("Starting acquisition series. Incremented pending_acquires [" + BasicResourcePool.this.pending_acquires + "],  attempts_remaining: " + n);
                }
            } else if (logger.isLoggable(MLevel.FINEST)) {
                logger.finest("Continuing acquisition series. pending_acquires [" + BasicResourcePool.this.pending_acquires + "],  attempts_remaining: " + n);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block24: {
                boolean bl = false;
                try {
                    boolean bl2;
                    boolean bl3;
                    BasicResourcePool basicResourcePool = BasicResourcePool.this;
                    synchronized (basicResourcePool) {
                        bl3 = BasicResourcePool.this.force_kill_acquires;
                        bl2 = BasicResourcePool.this.broken;
                    }
                    if (!bl2 && !bl3) {
                        BasicResourcePool.this.doAcquireAndDecrementPendingAcquiresWithinLockOnSuccess();
                    } else {
                        BasicResourcePool.this.decrementPendingAcquires();
                        bl = true;
                    }
                    try {
                        if (logger.isLoggable(MLevel.FINEST)) {
                            logger.finest("Acquisition series terminated " + (bl2 ? "because this resource pool has been close()ed" : (bl3 ? "because force-kill-acquires is pending" : "successfully")) + ". Decremented pending_acquires [" + BasicResourcePool.this.pending_acquires + "],  attempts_remaining: " + this.attempts_remaining);
                        }
                    }
                    catch (Exception exception) {
                        System.err.println("Exception during logging:");
                        exception.printStackTrace();
                    }
                }
                catch (Exception exception) {
                    MLevel mLevel;
                    BasicResourcePool.this.setLastAcquisitionFailure(exception);
                    if (this.attempts_remaining == 0) {
                        BasicResourcePool.this.decrementPendingAcquires();
                        if (logger.isLoggable(MLevel.WARNING)) {
                            logger.log(MLevel.WARNING, this + " -- Acquisition Attempt Failed!!! Clearing pending acquires. While trying to acquire a needed new resource, we failed to succeed more than the maximum number of allowed acquisition attempts (" + BasicResourcePool.this.num_acq_attempts + "). Last acquisition attempt exception: ", (Throwable)exception);
                        }
                        if (BasicResourcePool.this.break_on_acquisition_failure) {
                            if (logger.isLoggable(MLevel.SEVERE)) {
                                logger.severe("A RESOURCE POOL IS PERMANENTLY BROKEN! [" + this + "] (because a series of " + BasicResourcePool.this.num_acq_attempts + " acquisition attempts failed.)");
                            }
                            BasicResourcePool.this.unexpectedBreak();
                        } else {
                            try {
                                BasicResourcePool.this.forceKillAcquires();
                            }
                            catch (InterruptedException interruptedException) {
                                if (logger.isLoggable(MLevel.WARNING)) {
                                    logger.log(MLevel.WARNING, "Failed to force-kill pending acquisition attempts after acquisition failue,  due to an InterruptedException!", (Throwable)interruptedException);
                                }
                                bl = true;
                            }
                        }
                        if (logger.isLoggable(MLevel.FINEST)) {
                            logger.finest("Acquisition series terminated unsuccessfully. Decremented pending_acquires [" + BasicResourcePool.this.pending_acquires + "],  attempts_remaining: " + this.attempts_remaining);
                        }
                        break block24;
                    }
                    MLevel mLevel2 = mLevel = this.attempts_remaining > 0 ? MLevel.FINE : MLevel.INFO;
                    if (logger.isLoggable(mLevel)) {
                        logger.log(mLevel, "An exception occurred while acquiring a poolable resource. Will retry.", (Throwable)exception);
                    }
                    TimerTask timerTask = new TimerTask(){

                        @Override
                        public void run() {
                            BasicResourcePool.this.taskRunner.postRunnable((Runnable)new ScatteredAcquireTask(ScatteredAcquireTask.this.attempts_remaining - 1, false));
                        }
                    };
                    BasicResourcePool.this.cullAndIdleRefurbishTimer.schedule(timerTask, BasicResourcePool.this.acq_attempt_delay);
                }
                finally {
                    if (bl) {
                        BasicResourcePool.this.recheckResizePool();
                    }
                }
            }
        }
    }
}

