/*
 * Decompiled with CFR 0.152.
 */
package com.mashape.unirest.request;

import com.mashape.unirest.http.HttpMethod;
import com.mashape.unirest.request.HttpRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetRequest
extends HttpRequest {
    public GetRequest(HttpMethod method, String url) {
        super(method, url);
    }

    @Override
    public GetRequest routeParam(String name, String value) {
        super.routeParam(name, value);
        return this;
    }

    public GetRequest field(String name, Object value) {
        StringBuilder queryString = new StringBuilder();
        if (this.url.contains("?")) {
            queryString.append("&");
        } else {
            queryString.append("?");
        }
        try {
            queryString.append(name).append("=").append(URLEncoder.encode(value == null ? "" : value.toString(), "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.url = this.url + queryString.toString();
        return this;
    }

    public GetRequest fields(Map<String, Object> parameters) {
        if (parameters != null) {
            for (Map.Entry<String, Object> param : parameters.entrySet()) {
                if (param.getValue() instanceof String || param.getValue() instanceof Number || param.getValue() instanceof Boolean) {
                    this.field(param.getKey(), param.getValue());
                    continue;
                }
                throw new RuntimeException("Parameter \"" + param.getKey() + "\" can't be sent with a GET request because of type: " + param.getValue().getClass().getName());
            }
        }
        return this;
    }

    @Override
    public GetRequest basicAuth(String username, String password) {
        super.basicAuth(username, password);
        return this;
    }
}

