/*
 * Decompiled with CFR 0.152.
 */
package com.mashape.unirest.request.body;

import com.mashape.unirest.http.utils.MapUtil;
import com.mashape.unirest.request.BaseRequest;
import com.mashape.unirest.request.HttpRequest;
import com.mashape.unirest.request.body.Body;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;

public class MultipartBody
extends BaseRequest
implements Body {
    private List<String> keyOrder = new ArrayList<String>();
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private boolean hasFile;
    private HttpRequest httpRequestObj;

    public MultipartBody(HttpRequest httpRequest) {
        super(httpRequest);
        this.httpRequestObj = httpRequest;
    }

    public MultipartBody field(String name, String value) {
        this.keyOrder.add(name);
        this.parameters.put(name, value);
        return this;
    }

    public MultipartBody field(String name, Object value) {
        this.keyOrder.add(name);
        this.parameters.put(name, value);
        return this;
    }

    public MultipartBody field(String name, File file) {
        this.keyOrder.add(name);
        this.parameters.put(name, file);
        this.hasFile = true;
        return this;
    }

    public MultipartBody basicAuth(String username, String password) {
        this.httpRequestObj.basicAuth(username, password);
        return this;
    }

    public HttpEntity getEntity() {
        if (this.hasFile) {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            for (String key : this.keyOrder) {
                Object value = this.parameters.get(key);
                if (value instanceof File) {
                    builder.addPart(key, (ContentBody)new FileBody((File)value));
                    continue;
                }
                builder.addPart(key, (ContentBody)new StringBody(value.toString(), ContentType.APPLICATION_FORM_URLENCODED));
            }
            return builder.build();
        }
        try {
            return new UrlEncodedFormEntity(MapUtil.getList(this.parameters), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

