/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.qconsole.impl;

import com.marklogic.client.DatabaseClient;
import com.marklogic.client.eval.EvalResultIterator;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.client.ext.qconsole.WorkspaceManager;
import com.marklogic.client.ext.qconsole.impl.QconsoleScripts;
import com.marklogic.client.io.DOMHandle;
import com.marklogic.client.io.FileHandle;
import com.marklogic.client.io.Format;
import com.marklogic.client.io.marker.AbstractReadHandle;
import com.marklogic.client.io.marker.AbstractWriteHandle;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.util.FileCopyUtils;

public class DefaultWorkspaceManager
extends LoggingObject
implements WorkspaceManager {
    private DatabaseClient client;
    private File baseDir;

    public DefaultWorkspaceManager(DatabaseClient client) {
        this.client = client;
    }

    @Override
    public List<File> exportWorkspaces(String user, String ... workspaceNames) {
        if (this.baseDir == null) {
            this.baseDir = this.getDefaultWorkspacesDir();
        }
        File userDir = new File(this.baseDir, user);
        userDir.mkdirs();
        ArrayList<File> files = new ArrayList<File>();
        for (String workspaceName : workspaceNames) {
            EvalResultIterator result = this.client.newServerEval().addVariable("user", user).addVariable("workspace", workspaceName).xquery(QconsoleScripts.EXPORT).eval();
            while (result.hasNext()) {
                DOMHandle dom = (DOMHandle)result.next().get((AbstractReadHandle)new DOMHandle());
                File f = new File(userDir, workspaceName + ".xml");
                try {
                    FileCopyUtils.copy((byte[])dom.toBuffer(), (File)f);
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info(this.format("Exported workspace %s to %s", workspaceName, f.getAbsolutePath()));
                    }
                    files.add(f);
                }
                catch (IOException ie) {
                    throw new RuntimeException("Unable to write workspace XML to file, workspace: " + workspaceName + "; cause: " + ie.getMessage());
                }
            }
        }
        return files;
    }

    @Override
    public List<File> importWorkspaces(String user, String ... workspaceNames) {
        if (this.baseDir == null) {
            this.baseDir = this.getDefaultWorkspacesDir();
        }
        ArrayList<File> files = new ArrayList<File>();
        File userDir = new File(this.baseDir, user);
        if (!userDir.exists()) {
            return files;
        }
        String importQuery = this.determineImportScriptToUse();
        for (String workspace : workspaceNames) {
            File f = new File(userDir, workspace + ".xml");
            if (!f.isFile() || !f.exists()) continue;
            this.client.newServerEval().addVariable("user", user).addVariable("exported-workspace", (AbstractWriteHandle)new FileHandle(f).withFormat(Format.XML)).xquery(importQuery).eval();
            if (this.logger.isInfoEnabled()) {
                this.logger.info(this.format("Imported workspace from %s", f.getAbsolutePath()));
            }
            files.add(f);
        }
        return files;
    }

    protected String determineImportScriptToUse() {
        String version = (String)this.client.newServerEval().xquery("xdmp:version()").evalAs(String.class);
        String xquery = QconsoleScripts.IMPORT;
        if (version != null && version.startsWith("8")) {
            return xquery.replace("qconsole-model:default-database()", "qconsole-model:default-content-source()");
        }
        return xquery;
    }

    protected File getDefaultWorkspacesDir() {
        File homeDir = new File(System.getProperty("user.home"));
        File qcDir = new File(homeDir, ".qconsole");
        File dir = new File(qcDir, "workspaces");
        dir.mkdirs();
        return dir;
    }

    public void setBaseDir(File baseDir) {
        this.baseDir = baseDir;
    }
}

