/*
 * Decompiled with CFR 0.152.
 */
package com.marklogic.client.ext.file;

import com.marklogic.client.ext.file.DocumentFile;
import com.marklogic.client.ext.file.DocumentFileProcessor;
import com.marklogic.client.ext.file.SupportsTokenReplacer;
import com.marklogic.client.ext.helper.LoggingObject;
import com.marklogic.client.ext.tokenreplacer.TokenReplacer;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.util.Enumeration;
import java.util.Properties;

public abstract class PropertiesDrivenDocumentFileProcessor
extends LoggingObject
implements DocumentFileProcessor,
FileFilter,
SupportsTokenReplacer {
    private final String propertiesFilename;
    private Properties properties;
    private TokenReplacer tokenReplacer;

    protected PropertiesDrivenDocumentFileProcessor(String propertiesFilename) {
        this.propertiesFilename = propertiesFilename;
    }

    @Override
    public boolean accept(File file) {
        return !file.getName().equals(this.propertiesFilename);
    }

    @Override
    public DocumentFile processDocumentFile(DocumentFile documentFile) {
        File file = documentFile.getFile();
        if (!this.accept(file)) {
            return null;
        }
        this.processProperties(documentFile, this.properties);
        return documentFile;
    }

    private void processProperties(DocumentFile documentFile, Properties properties) {
        Path filename = documentFile.getFile().toPath().getFileName();
        Enumeration<?> patterns = properties.propertyNames();
        while (patterns.hasMoreElements()) {
            String pattern = (String)patterns.nextElement();
            PathMatcher matcher = FileSystems.getDefault().getPathMatcher("glob:" + pattern);
            if (!matcher.matches(filename)) continue;
            String value = this.getPropertyValue(properties, pattern);
            this.applyPropertyMatch(documentFile, pattern, value);
        }
    }

    protected abstract void applyPropertyMatch(DocumentFile var1, String var2, String var3);

    protected final Properties loadProperties(File propertiesFile) throws IOException {
        this.properties = new Properties();
        try (FileReader reader = new FileReader(propertiesFile);){
            this.properties.load(reader);
            Properties properties = this.properties;
            return properties;
        }
    }

    private String getPropertyValue(Properties properties, String propertyName) {
        if (properties == null || propertyName == null) {
            return null;
        }
        String value = properties.getProperty(propertyName);
        return this.tokenReplacer != null && value != null ? this.tokenReplacer.replaceTokens(value) : value;
    }

    public String getPropertiesFilename() {
        return this.propertiesFilename;
    }

    @Override
    public void setTokenReplacer(TokenReplacer tokenReplacer) {
        this.tokenReplacer = tokenReplacer;
    }

    protected void setProperties(Properties properties) {
        this.properties = properties;
    }

    protected Properties getProperties() {
        return this.properties;
    }
}

